package dev.amble.ait.data.schema.exterior.variant.dalek_mod.client;

import org.joml.Vector3f;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.models.exteriors.SimpleExteriorModel;
import dev.amble.ait.client.models.exteriors.advent.DalekModExteriorModel;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.data.datapack.exterior.BiomeOverrides;
import dev.amble.ait.data.schema.exterior.ClientExteriorVariantSchema;
import net.minecraft.class_2960;


public abstract class ClientDalekModVariant extends ClientExteriorVariantSchema {
    private final String name;
    protected static final String CATEGORY_PATH = "textures/blockentities/exteriors/dalek_mod";
    protected static final class_2960 CATEGORY_IDENTIFIER = new class_2960(AITMod.MOD_ID,
            CATEGORY_PATH + "/dalek_mod.png");
    protected static final class_2960 BIOME_IDENTIFIER = AITMod.id(CATEGORY_PATH + "/biome" + "/dalek_mod.png");
    protected static final String TEXTURE_PATH = CATEGORY_PATH + "/dalek_mod_";

    protected static final BiomeOverrides OVERRIDES = BiomeOverrides.builder()
            .with(type -> type.getTexture(BIOME_IDENTIFIER), BiomeHandler.BiomeType.SNOWY,
                    BiomeHandler.BiomeType.SCULK, BiomeHandler.BiomeType.CHORUS, BiomeHandler.BiomeType.CHERRY,
                    BiomeHandler.BiomeType.SANDY, BiomeHandler.BiomeType.RED_SANDY, BiomeHandler.BiomeType.MUDDY)
            .build();


    protected ClientDalekModVariant(String name) {
        super(AITMod.id("exterior/dalek_mod/" + name));

        this.name = name;
    }

    @Override
    public SimpleExteriorModel model() {
        return new DalekModExteriorModel(DalekModExteriorModel.getTexturedModelData().method_32109());
    }

    @Override
    public class_2960 texture() {
        return AITMod.id(TEXTURE_PATH + name + ".png");
    }

    @Override
    public class_2960 emission() {
        return AITMod.id(TEXTURE_PATH + name + "_emission" + ".png");
    }

    @Override
    public Vector3f sonicItemTranslations() {
        return new Vector3f(0.5f, 1.2f, 1.15f);
    }

    @Override
    public BiomeOverrides overrides() {
        return null;
    }
}
