package dev.amble.ait.datagen.datagen_providers;


import java.util.concurrent.CompletableFuture;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITTags;
import dev.amble.ait.module.ModuleRegistry;
import dev.amble.ait.module.planet.core.PlanetItems;

public class AITItemTagProvider extends FabricTagProvider<class_1792> {
    public AITItemTagProvider(FabricDataOutput output,
            @Nullable CompletableFuture<class_7225.class_7874> completableFuture) {
        super(output, class_7924.field_41197, completableFuture);
    }

    @Override
    protected void method_10514(class_7225.class_7874 arg) {
        // Items
        method_10512(AITTags.Items.SONIC_ITEM).add(AITItems.SONIC_SCREWDRIVER);

        method_10512(class_3489.field_23969).add(AITItems.DRIFTING_MUSIC_DISC)
               .add(AITItems.WONDERFUL_TIME_IN_SPACE_MUSIC_DISC)
                .add(AITItems.GOOD_MAN_MUSIC_DISC).add(AITItems.CHRONOLOGY_MUSIC_DISC)
                .add(AITItems.EARTH_MUSIC_DISC).add(AITItems.VENUS_MUSIC_DISC);

        method_10512(AITTags.Items.CLUSTER_MAX_HARVESTABLES).add(AITItems.ZEITON_SHARD);

        method_10512(AITTags.Items.NO_BOP).add(AITItems.SONIC_SCREWDRIVER);

        method_10512(AITTags.Items.FULL_RESPIRATORS).add(AITItems.RESPIRATOR);

        method_10512(AITTags.Items.HALF_RESPIRATORS).add(AITItems.FACELESS_RESPIRATOR);

        /*if (isUnlockedOnThisDay(Calendar.DECEMBER, 27)) {
            getOrCreateTagBuilder(AITTags.Items.HALF_RESPIRATORS).add(AITItems.SANTA_HAT);
        }*/

        method_10512(AITTags.Items.KEY).add(AITItems.IRON_KEY, AITItems.GOLD_KEY, AITItems.CLASSIC_KEY,
                AITItems.NETHERITE_KEY, AITItems.SKELETON_KEY);

        /*getOrCreateTagBuilder(AITTags.Items.GOAT_HORN).add(AITItems.IRON_GOAT_HORN, AITItems.GOLD_GOAT_HORN, AITItems.CLASSIC_GOAT_HORN,
                AITItems.NETHERITE_GOAT_HORN);*/

        method_10512(AITTags.Items.REPAIRS_SUBSYSTEM).add(class_1802.field_8620,class_1802.field_8695, class_1802.field_27022);

        method_10512(AITTags.Items.IS_TARDIS_FUEL).add(AITItems.ZEITON_DUST, AITItems.ZEITON_SHARD,
                AITBlocks.TARDIS_CORAL_BLOCK.method_8389(), AITBlocks.TARDIS_CORAL_SLAB.method_8389(),
                AITBlocks.TARDIS_CORAL_FAN.method_8389(), AITBlocks.TARDIS_CORAL_STAIRS.method_8389(),
                AITItems.CORAL_FRAGMENT);
        method_10512(AITTags.Items.IS_TARDIS_FUEL).forceAddTag(class_3489.field_23212);
        method_10512(AITTags.Items.IS_TARDIS_FUEL).forceAddTag(class_3489.field_17487);
        method_10512(AITTags.Items.IS_TARDIS_FUEL).add(class_1802.field_8187);

        // Rifts

        method_10512(AITTags.Items.RIFT_SUCCESS_EXTRA_ITEM).add(AITItems.ZEITON_SHARD);
        method_10512(AITTags.Items.RIFT_FAIL_ITEM).add(class_1802.field_8407);

        //Linkable

        method_10512(AITTags.Items.LINK).add(AITItems.SONIC_SCREWDRIVER, AITItems.CLASSIC_KEY, AITItems.GOLD_KEY, AITItems.IRON_KEY, AITItems.REMOTE_ITEM,AITItems.NETHERITE_KEY, PlanetItems.HANDLES);

        ModuleRegistry.instance().iterator().forEachRemaining(module -> {
            module.getDataGenerator().ifPresent(generator -> {
                generator.itemTags(this);
            });
        });
    }

    @Override
    public FabricTagProvider<class_1792>.FabricTagBuilder method_10512(class_6862<class_1792> tag) {
        return super.method_10512(tag);
    }
}
