package dev.amble.ait.datagen.datagen_providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import dev.amble.lib.datagen.model.AmbleModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.data.client.*;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.module.ModuleRegistry;


public class AITModelProvider extends AmbleModelProvider {
    private final List<class_2248> directionalBlocksToRegister = new ArrayList<>();
    private final List<class_2248> simpleBlocksToRegister = new ArrayList<>();
    private final List<class_3545<class_2248, class_2248>> coralFanBlocksToRegister = new ArrayList<>();

    public AITModelProvider(FabricDataOutput output) {
        super(output);
    }

    private static class_4942 item(String modid, String parent, class_4945... requiredTextureKeys) {
        return new class_4942(Optional.of(new class_2960(modid, "item/" + parent)), Optional.empty(), requiredTextureKeys);
    }

    private static class_4942 item(String parent, class_4945... requiredTextureKeys) {
        return item(AITMod.MOD_ID, parent, requiredTextureKeys);
    }

    private static class_4942 item(class_4945... requiredTextureKeys) {
        return item("minecraft", "generated", requiredTextureKeys);
    }

    private static class_4942 item(String name) {
        return item(name, class_4945.field_23006);
    }

    private static String getItemName(class_1792 item) {
        return item.method_7876().split("\\.")[2];
    }

    @Override
    public void generateBlockStateModels(class_4910 generator) {
        for (class_2248 block : directionalBlocksToRegister) {
            // Identifier identifier = new
            // Identifier(block.getTranslationKey().split("\\.")[1]);
            generator.field_22830.accept(class_4922.method_25758(block).method_25760(
                    class_4918.method_25744().method_25751(class_2741.field_12481, class_2350.field_11043),
                    class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22890)));
        }
        for (class_2248 block : simpleBlocksToRegister) {
            generator.method_25641(block);
        }

        for (class_3545<class_2248, class_2248> pair : coralFanBlocksToRegister) {
            generator.method_25601(pair.method_15442(), pair.method_15441());
        }

        ModuleRegistry.instance().iterator().forEachRemaining(module -> {
            module.getDataGenerator().ifPresent(data -> data.models(this, generator));
            module.getBlockRegistry().ifPresent(this::withBlocks);
        });

        class_4910.class_4912 tardis_coral_pool = generator.method_25650(AITBlocks.TARDIS_CORAL_BLOCK);
        tardis_coral_pool.method_25725(AITBlocks.TARDIS_CORAL_STAIRS);
        tardis_coral_pool.method_25724(AITBlocks.TARDIS_CORAL_SLAB);

        super.generateBlockStateModels(generator);
    }

    @Override
    public void generateItemModels(class_4915 generator) {
        ModuleRegistry.instance().iterator().forEachRemaining(module -> {
            module.getItemRegistry().ifPresent(this::withItems);
            module.getBlockRegistry().ifPresent(this::withBlocks);
            module.getDataGenerator().ifPresent(data -> data.generateItemModels(this, generator));
        });

        this.withItems(AITItems.class);
        this.withBlocks(AITBlocks.class);

        super.generateItemModels(generator);
    }

    public void registerDirectionalBlock(class_2248 block) {
        directionalBlocksToRegister.add(block);
    }

    public void registerCoralFanBlock(class_2248 fanBlock, class_2248 wallFanBlock) {
        coralFanBlocksToRegister.add(new class_3545<>(fanBlock, wallFanBlock));
    }

    public void registerSimpleBlock(class_2248 block) {
        simpleBlocksToRegister.add(block);
    }

    private void registerItem(class_4915 generator, class_1792 item, String modid) {
        class_4942 model = item(class_4945.field_23006);
        model.method_25852(class_4941.method_25840(item), createTextureMap(item, modid), generator.field_22844);
    }

    private class_4944 createTextureMap(class_1792 item, String modid) {
        class_2960 texture = new class_2960(modid, "item/" + getItemName(item));
        if (!(doesTextureExist(texture))) {
            texture = AITMod.id("item/error");
        }

        return new class_4944().method_25868(class_4945.field_23006, texture);
    }

    public boolean doesTextureExist(class_2960 texture) {
        return this.output.getModContainer().findPath("assets/" + texture.method_12836() + "/textures/" + texture.method_12832() + ".png").isPresent();
    }
}
