package dev.amble.ait.datagen.datagen_providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_2960;
import net.minecraft.class_3981;
import net.minecraft.class_7800;
import net.minecraft.class_7803;
import net.minecraft.class_8074;
import net.minecraft.data.server.recipe.*;
import dev.amble.ait.AITMod;

public class AITRecipeProvider extends FabricRecipeProvider {
    public List<class_2450> shapelessRecipes = new ArrayList<>();
    public List<class_2447> shapedRecipes = new ArrayList<>();
    public HashMap<class_8074, class_2960> smithingTransformRecipes = new HashMap<>();
    public HashMap<class_2450, class_2960> shapelessRecipesWithNameHashMap = new HashMap<>();
    public HashMap<class_3981, class_2960> stonecutting = new HashMap<>();
    public List<BlastFurnaceRecipeEntry> blasting = new ArrayList<>();
    public List<FurnaceRecipeEntry> smelting = new ArrayList<>();
    public record FurnaceRecipeEntry(class_2454 builder, class_2960 id) {}
    public record BlastFurnaceRecipeEntry(class_2454 builder, class_2960 id) {}


    public AITRecipeProvider(FabricDataOutput output) {
        super(output);
    }

    @Override
    public void method_10419(Consumer<class_2444> exporter) {
        for (class_2450 shapelessRecipeJsonBuilder : shapelessRecipes) {
            shapelessRecipeJsonBuilder.method_10431(exporter);
        }
        for (class_2447 shapedRecipeJsonBuilder : shapedRecipes) {
            shapedRecipeJsonBuilder.method_10431(exporter);
        }
        shapelessRecipesWithNameHashMap.forEach((shapelessRecipeJsonBuilder, identifier) -> {
            shapelessRecipeJsonBuilder.method_17972(exporter, identifier);
        });
        smithingTransformRecipes.forEach((smithingTransformRecipeJsonBuilder, identifier) -> {
            smithingTransformRecipeJsonBuilder.method_48537(exporter, identifier);
        });

        stonecutting.forEach((stonecuttingRecipeJsonBuilder, identifier) -> {
            stonecuttingRecipeJsonBuilder.method_17972(exporter, identifier);
        });

        for (BlastFurnaceRecipeEntry entry : blasting) {
            entry.builder().method_17972(exporter, entry.id());
        }

        for (FurnaceRecipeEntry entry : smelting) {
            entry.builder().method_17972(exporter, entry.id());
        }


    }

    public void addShapelessRecipe(class_2450 builder) {
        if (!shapelessRecipes.contains(builder)) {
            shapelessRecipes.add(builder);
        }
    }

    public void addShapelessRecipeWithCustomname(class_2450 builder, class_2960 id) {
        shapelessRecipesWithNameHashMap.put(builder, id);
    }

    public void addSmithingTransformRecipe(class_8074 builder, class_2960 id) {
        smithingTransformRecipes.put(builder, id);
    }


    public void addShapedRecipe(class_2447 builder) {
        if (!shapedRecipes.contains(builder)) {
            shapedRecipes.add(builder);
        }
    }

    public void addStonecutting(class_2248 in, class_2248 out, int count) {
        class_2960 id = getStonecuttingIdentifier(in, out);

        stonecutting.put(class_3981.method_17969(class_1856.method_8091(in), class_7800.field_40634, out, count).method_17970("has_block", class_7803.method_10426(in)), id);
    }
    public void addStonecutting(class_2248 in, class_2248 out) {
        addStonecutting(in, out, 1);
    }

    private class_2960 getStonecuttingIdentifier(class_2248 in, class_2248 out) {
        return AITMod.id(fixupBlockKey(in.method_9539()) + "_to_" + fixupBlockKey(out.method_9539()) + "_stonecutting");
    }
    private String fixupBlockKey(String key) {
        return key.substring(key.lastIndexOf(".") + 1);
    }

    public void addBlastFurnaceRecipe(class_2454 cookingBuilder, class_2960 id) {
        blasting.add(new BlastFurnaceRecipeEntry(cookingBuilder, id));
    }

    public void addFurnaceRecipe(class_2454 cookingBuilder, class_2960 id) {
        smelting.add(new FurnaceRecipeEntry(cookingBuilder, id));
    }

}
