package dev.amble.ait.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import dev.amble.ait.api.ConsumableBlock;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_2614;
import net.minecraft.class_2680;

@Mixin(class_2614.class)
public abstract class HopperBlockEntityMixin {

    @Inject(method = "insert(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/inventory/Inventory;)Z",
            at = @At("HEAD"), cancellable = true)
    private static void ait$insertIntoConsumableBlock(
            class_1937 world, class_2338 pos, class_2680 state, class_1263 inventory, CallbackInfoReturnable<Boolean> cir
    ) {
        class_2350 direction = state.method_11654(class_2377.field_11129);
        class_2338 targetPos = pos.method_10093(direction);
        class_2680 targetState = world.method_8320(targetPos);

        if (!(targetState.method_26204() instanceof ConsumableBlock block)) return;

        for (int slot = 0; slot < inventory.method_5439(); slot++) {
            class_1799 stack = inventory.method_5438(slot);
            if (stack.method_7960()) continue;

            if (!block.canAcceptItem(world, targetPos, stack, direction.method_10153())) continue;

            class_1799 attempt = stack.method_46651(1);
            class_1799 leftover = block.insertItem(world, targetPos, attempt, direction.method_10153(), false);

            if (leftover.method_7960()) {
                stack.method_7934(1);
                cir.setReturnValue(true);
                return;
            }
        }
    }

}
