package dev.amble.ait.mixin.client;

import static dev.amble.ait.core.AITItems.isInAdvent;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.AITModClient;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8020;

@Mixin(class_8020.class)
public class DefaultLogoMixin {

    @Unique private static final class_2960 AIT_LOGO = AITMod.id("textures/gui/title/ait_logo.png");
    @Unique private static final class_2960 AIT_CHRISTMAS_LOGO = AITMod.id("textures/gui/title/ait_christmas_logo.png");
    @Unique private final class_310 client = class_310.method_1551();
    @Unique boolean isChristmas = isInAdvent();

    @Redirect(method = "draw(Lnet/minecraft/client/gui/DrawContext;IFI)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIFFIIII)V", ordinal = 0))
    private void ait$drawCustomLogo(class_332 context, class_2960 texture, int x, int y, float u, float v, int width,
                                    int height, int textureWidth, int textureHeight) {

        class_2960 currentLogo;
        if (isChristmas) {
            currentLogo = AIT_CHRISTMAS_LOGO;
        } else {
            currentLogo = AIT_LOGO;
        }

        if (!AITModClient.CONFIG.customMenu) {
            context.method_25290(texture, x, y, u, v, width, height, textureWidth, textureHeight);
            return;
        }

        int screenWidth = this.client.method_22683().method_4486();
        int centerX = screenWidth / 2 - 128;
        if (isChristmas) {
            context.method_25290(currentLogo, centerX, y - 18, 0.0f, 0.0f, 266,  74, 266, 74);
        } else {
            context.method_25290(currentLogo, centerX, y - 18, 0.0f, 0.0f, 266, 94, 266, 94);
        }
    }

    @Redirect(method = "draw(Lnet/minecraft/client/gui/DrawContext;IFI)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIFFIIII)V", ordinal = 1))
    private void ait$skipEdition(class_332 context, class_2960 texture, int x, int y, float u, float v, int width,
                                 int height, int textureWidth, int textureHeight) {
        if (!AITModClient.CONFIG.customMenu)
            context.method_25290(texture, x, y, u, v, width, height, textureWidth, textureHeight);
    }

    @Inject(method = "draw(Lnet/minecraft/client/gui/DrawContext;IFI)V", at = @At("TAIL"))
    private void renderWarningMessage(class_332 context, int screenWidth, float alpha, int y, CallbackInfo ci) {
        if (AITMod.isUnsafeBranch()) {

            String warningMessage;
            if (isChristmas) {
                warningMessage =  "HO HO HO!: You are using an experimental branch (" + AITMod.BRANCH + "), please be cautious when testing or the grinch will smell you toes!";
            } else {
                warningMessage =  "WARNING!: You are using an experimental version (" + AITMod.BRANCH + "), please be cautious when testing!";
            }

            screenWidth = this.client.method_22683().method_4486();
            int textWidth = this.client.field_1772.method_1727(warningMessage);


            int x = (screenWidth - textWidth) / 2;
            y = 10;
            int padding = 7;


            context.method_25294(0, y - padding, screenWidth, y + this.client.field_1772.field_2000 + padding, 0xAA000000);

            context.method_51433(this.client.field_1772, warningMessage, x, y, 0xFFFF0000, true);
        }
    }
}