package dev.amble.ait.mixin.client.experimental_screen;

import com.mojang.serialization.Lifecycle;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import dev.amble.ait.client.AITModClient;
import net.minecraft.class_31;
import net.minecraft.class_525;
import net.minecraft.class_7193;
import net.minecraft.class_7659;
import net.minecraft.class_7723;
import net.minecraft.class_7780;

@SuppressWarnings("deprecation")
@Mixin(value = class_525.class)
public abstract class CreateWorldScreenMixin {
    @Shadow
    private boolean recreated;

    @Shadow
    protected abstract void startServer(class_31.class_7729 specialProperty,
            class_7780<class_7659> combinedDynamicRegistries, Lifecycle lifecycle);

    @Inject(method = "createLevel", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/integrated/IntegratedServerLoader;tryLoad(Lnet/minecraft/client/MinecraftClient;Lnet/minecraft/client/gui/screen/world/CreateWorldScreen;Lcom/mojang/serialization/Lifecycle;Ljava/lang/Runnable;Z)V"), locals = LocalCapture.CAPTURE_FAILSOFT, cancellable = true)
    private void onCreate(CallbackInfo ci, class_7193 holder,
            class_7723.class_7725 config,
            class_7780<class_7659> registries, Lifecycle lifecycle, Lifecycle lifecycle2,
            Lifecycle lifecycle3, boolean showWarnings) {
        if (this.recreated)
            return;

        if (!AITModClient.CONFIG.showExperimentalWarning) {
            this.startServer(config.comp_1018(), registries, lifecycle3);
            ci.cancel();
        }
    }
}
