package dev.amble.ait.mixin.client.rendering;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import dev.amble.ait.api.AITUseActions;
import dev.amble.ait.core.AITTags;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_759;

@Mixin(class_759.class)
public class HeldItemRendererMixin {

    @Shadow
    @Final
    private class_310 client;

    @Inject(method = "applyEquipOffset", at = @At("HEAD"), cancellable = true)
    private void applyEquipProgress(class_4587 matrices, class_1306 arm, float equipProgress, CallbackInfo ci) {
        if (this.client.field_1724 == null)
            return;

        class_1657 player = this.client.field_1724;
        class_1799 stack = player.method_6030();

        if (noBop(stack)) {
            int i = arm == class_1306.field_6183 ? 1 : -1;
            matrices.method_46416((float) i * 0.56F, -0.52F, -0.72F);

            ci.cancel();
        }
    }

    @Redirect(method = "renderFirstPersonItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;getUseAction()Lnet/minecraft/util/UseAction;"))
    private class_1839 getUseAction(class_1799 instance) {
        class_1839 result = instance.method_7976();

        return result == ((AITUseActions) (Object) class_1839.field_8952).ait$sonic()
                ? class_1839.field_8952 : result;
    }

    @Unique private static boolean noBop(class_1799 stack) {
        return stack.method_41409().method_40220(AITTags.Items.NO_BOP);
    }
}
