package dev.amble.ait.mixin.client.rendering;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITItems;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_763;
import net.minecraft.class_811;
import net.minecraft.class_918;

@Mixin(class_918.class)
public class ItemRendererMixin {

    @Unique private static final class_2960 HAND_MODEL = new class_2960(AITMod.MOD_ID, "tardis_item");

    @Unique private static final class_1091 HAND_MODEL_ID = new class_1091(HAND_MODEL, "inventory");

    @Final
    @Shadow
    private class_763 models;


    @Inject(method = "getModel(Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/LivingEntity;I)Lnet/minecraft/client/render/model/BakedModel;", at = @At("HEAD"), cancellable = true)
    private void ait$getModel(class_1799 stack, class_1937 world, class_1309 entity, int seed, CallbackInfoReturnable<class_1087> cir) {
        if (stack.method_31574(AITItems.TARDIS_ITEM)) {
            class_1087 bakedModel = this.models.method_3303().method_4742(HAND_MODEL_ID);
            class_638 clientWorld = world instanceof class_638 ? (class_638) world : null;
            class_1087 bakedModel2 = bakedModel.method_4710().method_3495(bakedModel, stack, clientWorld, entity, seed);
            cir.setReturnValue(bakedModel2 == null ? this.models.method_3303().method_4744() : bakedModel2);
        }
    }

    @ModifyVariable(method = "renderItem*", at = @At(value = "HEAD"), argsOnly = true)
    public class_1087 useItem(class_1087 value, class_1799 stack, class_811 renderMode, boolean leftHanded, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        if (stack.method_31574(AITItems.TARDIS_ITEM) && renderMode != class_811.field_4317 && renderMode != class_811.field_4318) {
            return this.models.method_3303().method_4742(HAND_MODEL_ID);
        }
        return value;
    }
}
