package dev.amble.ait.mixin.client.sonic;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.data.schema.sonic.SonicSchema;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_763;
import net.minecraft.class_918;

@Mixin(class_918.class)
public class SonicItemRendererMixin {

    @Shadow @Final private class_763 models;

    @Inject(method = "getModel", at = @At("HEAD"), cancellable = true)
    public void getModel(class_1799 stack, class_1937 world, class_1309 entity, int seed, CallbackInfoReturnable<class_1087> cir) {
        if (!stack.method_31574(AITItems.SONIC_SCREWDRIVER))
            return;

        SonicSchema.Models models = SonicItem.schema(stack).models();
        class_1087 model;

        if (entity == null || !(entity.method_6030() == stack && entity.method_6115())) {
            model = this.getOrMissing(models.inactive());
        } else {
            model = this.getOrMissing(SonicItem.mode(stack).model(models));
        }

        model.method_4710().method_3495(model, stack, (class_638) world, entity, seed);
        cir.setReturnValue(model);
    }

    @Unique private class_1087 getOrMissing(class_2960 id) {
        class_1087 model = this.models.method_3303().getModel(
                id
        );

        if (model == null)
            return this.models.method_3303().method_4744();

        return model;
    }
}
