package dev.amble.ait.mixin.compat.portals;

import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.drtheo.multidim.api.MultiDimServerWorld;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import qouteall.q_misc_util.MiscNetworking;
import qouteall.q_misc_util.api.DimensionAPI;
import qouteall.q_misc_util.dimension.DimensionIdManagement;

@Mixin(TardisServerWorld.class)
public class TardisServerWorldMixin {

    @Inject(method = "create", at = @At("RETURN"), remap = false)
    private static void create(ServerTardis tardis, CallbackInfoReturnable<TardisServerWorld> cir) {
        aitportals$handleWorld(cir.getReturnValue());
    }

    // makes sure that we don't handle the world twice in case it gets created
    @Redirect(method = "load", at = @At(value = "INVOKE", target = "Ldev/amble/ait/core/world/TardisServerWorld;setTardis(Ldev/amble/ait/core/tardis/ServerTardis;)V"))
    private static void load(TardisServerWorld instance, ServerTardis tardis) {
        instance.setTardis(tardis);
        aitportals$handleWorld(instance);
    }

    @Unique
    private static MultiDimServerWorld aitportals$handleWorld(MultiDimServerWorld world) {
        // may happen if this is called during #load and the world doesn't exist!
        if (world == null)
            return null;

        MinecraftServer server = world.method_8503();
        class_5321<class_1937> key = world.method_27983();

        // An excerpt from `qouteall.q_misc_util.dimension.DynamicDimensionsImpl#addDimensionDynamically`
        // FIXME: this line MAY be causing issues with the relogs
        //  basically, the game crashes because it's trying to load a tardis world
        //  which shouldn't have been loaded, but fails miserably because it finds
        //  out that it's a normal server world, resulting in a cast exception.
        //  if commenting out this line wont work (still have to hear back from QA),
        //  then we should mixin into wherever it saves the world metadata and lobotomize it
        //    - Theo

        // UPDATE: commenting out this line DOES NOT fix the issue stated above.?
        // maybe? im lost.
        //DimensionAPI.saveDimensionConfiguration(key);
        DimensionIdManagement.updateAndSaveServerDimIdRecord();

        class_2596<?> dimSyncPacket = MiscNetworking.createDimSyncPacket();

        for (class_3222 player : server.method_3760().method_14571()) {
            player.field_13987.method_14364(dimSyncPacket);
        }

        DimensionAPI.serverDimensionDynamicUpdateEvent.invoker().run(server.method_29435());
        return world;
    }
}
