package dev.amble.ait.mixin.server;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.world.TardisServerWorld;
import net.minecraft.class_1542;
import net.minecraft.class_1937;

@Mixin(class_1542.class)
public abstract class ItemEntityMixin {

    @Inject(method = "tick", at = @At("HEAD"))
    private void ait$tick(CallbackInfo ci) {
        class_1542 entity = (class_1542) (Object) this;
        class_1937 world = entity.method_37908();

        if (world.method_8608())
            return;

        // if entity is in tardis and y is less than the TARDIS' bottom coordinate (currently -64), teleport it to the door
        if (entity.method_23318() < entity.method_37908().method_31607() && world instanceof TardisServerWorld tardisWorld
                && !tardisWorld.getTardis().interiorChanging().regenerating().get())
            TardisUtil.teleportInside(tardisWorld.getTardis(), entity);
    }
}
