package dev.amble.ait.mixin.server;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import dev.amble.ait.api.AITWorldOptions;
import dev.amble.ait.core.events.WorldSaveEvent;
import dev.amble.ait.core.item.SiegeTardisItem;
import dev.amble.ait.core.tardis.Tardis;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_3218;

@Mixin(class_3218.class)
public class ServerWorldMixin implements AITWorldOptions {

    @Unique private boolean canRiftsSpawn;

    @Inject(method = "saveLevel", at = @At("HEAD"))
    private void saveLevel(CallbackInfo ci) {
        WorldSaveEvent.EVENT.invoker().onWorldSave((class_3218) (Object) this);
    }

    @Override
    public void ait$setCanRiftsSpawn(boolean canSpawn) {
        this.canRiftsSpawn = canSpawn;
    }

    @Override
    public boolean ait$canRiftsSpawn() {
        return canRiftsSpawn;
    }

    @Inject(method = "spawnEntity", at = @At("RETURN"))
    public void spawnEntity(class_1297 entity, CallbackInfoReturnable<Boolean> cir) {
        if (!cir.getReturnValueZ()) return;
        if (!(entity instanceof class_1542 itemEntity)) return;

        class_1799 stack = itemEntity.method_6983();

        if (stack.method_7909() instanceof SiegeTardisItem item) {
            Tardis found = item.getTardis(entity.method_37908(), stack);

            if (found == null)
                return;

            // kill ourselves and place down the exterior
            SiegeTardisItem.placeTardis(found, SiegeTardisItem.fromEntity(entity));
            entity.method_5768();
        }
    }
}
