package dev.amble.ait.module;

import java.util.Optional;
import java.util.function.Consumer;

import dev.amble.lib.api.Identifiable;
import dev.amble.lib.container.impl.BlockContainer;
import dev.amble.lib.container.impl.ItemContainer;
import dev.amble.lib.datagen.lang.AmbleLanguageProvider;
import dev.amble.lib.datagen.model.AmbleModelProvider;
import dev.amble.lib.itemgroup.AItemGroup;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_161;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_7923;
import dev.amble.ait.AITMod;
import dev.amble.ait.datagen.datagen_providers.AITBlockTagProvider;
import dev.amble.ait.datagen.datagen_providers.AITItemTagProvider;
import dev.amble.ait.datagen.datagen_providers.AITRecipeProvider;

public abstract class Module implements Identifiable {
    private AItemGroup group;

    public abstract void init();

    @Environment(EnvType.CLIENT)
    public abstract void initClient();

    protected class_1792 register(class_1792 item, class_2960 id) {
        class_2378.method_10230(class_7923.field_41178, id, item);
        return item;
    }
    protected class_3414 register(class_3414 sound, class_2960 id) {
        class_2378.method_10230(class_7923.field_41172, id, sound);
        return sound;
    }
    protected class_3414 registerSound(String name) {
        return register(class_3414.method_47908(AITMod.id(name)), AITMod.id(name));
    }
    protected <T extends class_2586> class_2591<T> register(class_2591<T> type, class_2960 id) {
        class_2378.method_10230(class_7923.field_41181, id, type);
        return type;
    }

    public Optional<Class<? extends BlockContainer>> getBlockRegistry() {
        return Optional.empty();
    }
    public Optional<Class<? extends ItemContainer>> getItemRegistry() {
        return Optional.empty();
    }

    public boolean shouldRegister() {
        return true;
    }

    protected AItemGroup.Builder buildItemGroup() {
        return null;
    }

    public AItemGroup getItemGroup() {
        AItemGroup.Builder builder = buildItemGroup();

        if (builder == null) throw new UnsupportedOperationException("Item Group for module " + this + " is not defined");
        if (!(this.shouldRegister())) throw new UnsupportedOperationException("Tried to access item group for module " + this + " but it is not registered");

        if (group == null) {
            group = builder.build();

            class_2378.method_10230(class_7923.field_44687, group.id(), group);
        }

        return group;
    }

    @Override
    public String toString() {
        return "Module{" +
                "id=" + id() +
                '}';
    }

    public Optional<DataGenerator> getDataGenerator() {
        return Optional.empty();
    }

    public interface DataGenerator {
        /**
         * Called when the ENGLISH language provider is generating
         */
        void lang(AmbleLanguageProvider provider);
        void recipes(AITRecipeProvider provider);
        void blockTags(AITBlockTagProvider provider);
        void itemTags(AITItemTagProvider provider);

        void generateItemModels(AmbleModelProvider provider, class_4915 generator);

        void models(AmbleModelProvider provider, class_4910 generator);

        void advancements(Consumer<class_161> consumer);
    }
}
