package dev.amble.ait.module;

import dev.amble.lib.register.datapack.DatapackRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import dev.amble.ait.module.decoration.DecorationModule;
import dev.amble.ait.module.gun.GunModule;
import dev.amble.ait.module.planet.PlanetModule;

// these arent datapack definable
public class ModuleRegistry extends DatapackRegistry<Module> {
    public static final ModuleRegistry INSTANCE = new ModuleRegistry();

    @Override
    public void onCommonInit() {
        super.onCommonInit();

        register(PlanetModule.instance());
        register(DecorationModule.instance());
        register(GunModule.instance());

        iterator().forEachRemaining(Module::init);
    }

    @Environment(EnvType.CLIENT)
    @Override
    public void onClientInit() {
        super.onClientInit();

        iterator().forEachRemaining(Module::initClient);
    }

    @Override
    public Module register(Module schema) {
        if (!schema.shouldRegister()) return schema;

        return super.register(schema);
    }

    @Override
    public Module fallback() {
        return null;
    }

    @Override
    public void syncToClient(class_3222 player) {

    }

    @Override
    public void readFromServer(class_2540 buf) {

    }

    public static ModuleRegistry instance() {
        return INSTANCE;
    }
}
