package dev.amble.ait.module.gun.client;

import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import dev.amble.ait.AITMod;
import dev.amble.ait.module.gun.core.item.StaserRifleItem;

public class ScopeOverlay implements HudRenderCallback {

    private static final class_2960 SPYGLASS_SCOPE = AITMod.id("textures/gui/overlay/scope.png");
    private int scaledWidth, scaledHeight;
    private float spyglassScale;

    @Override
    public void onHudRender(class_332 drawContext, float v) {
        this.scaledWidth = drawContext.method_51421();
        this.scaledHeight = drawContext.method_51443();

        class_310 mc = class_310.method_1551();

        if(mc.field_1724 == null) return;

        if(mc.field_1724.method_6047().method_7909() instanceof StaserRifleItem && mc.field_1690.method_31044().method_31034()) {
            if (mc.field_1690.field_1904.method_1434()) {
                float f = class_310.method_1551().method_1534();
                this.spyglassScale = class_3532.method_16439(0.5f * f, this.spyglassScale, 1.125f);
                this.renderSpyglassOverlay(drawContext, this.spyglassScale);
            }
        }

        if (mc.field_1724 == null)
            return;
    }

    private void renderSpyglassOverlay(class_332 context, float scale) {
        float f;
        float g = f = (float)Math.min(this.scaledWidth, this.scaledHeight);
        float h = Math.min((float)this.scaledWidth / f, (float)this.scaledHeight / g) * scale;
        int i = class_3532.method_15375(f * h);
        int j = class_3532.method_15375(g * h);
        int k = (this.scaledWidth - i) / 2;
        int l = (this.scaledHeight - j) / 2;
        int m = k + i;
        int n = l + j;
        context.method_25291(SPYGLASS_SCOPE, k, l, -100, 0.0f, 0.0f, i, j, i, j);
        context.method_48196(class_1921.method_51785(), 0, n, this.scaledWidth, this.scaledHeight, -90, -16777216);
        context.method_48196(class_1921.method_51785(), 0, 0, this.scaledWidth, l, -90, -16777216);
        context.method_48196(class_1921.method_51785(), 0, l, k, n, -90, -16777216);
        context.method_48196(class_1921.method_51785(), m, l, this.scaledWidth, n, -90, -16777216);
    }
}
