package dev.amble.ait.module.gun.core.item;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import org.jetbrains.annotations.Nullable;
import dev.amble.ait.api.ArtronHolderItem;
import dev.amble.ait.core.item.ZeitonShardItem;
import dev.amble.ait.module.gun.core.entity.GunEntityTypes;
import dev.amble.ait.module.gun.core.entity.StaserBoltEntity;

public class StaserBoltMagazine extends class_1792 implements ArtronHolderItem {
    public StaserBoltMagazine(class_1793 settings) {
        super(settings);
    }

    public static final double MAX_FUEL = 64;

    public class_1665 createStaserbolt(class_1937 world, class_1799 stack, class_1309 shooter) {
        StaserBoltEntity staserBoltEntity = new StaserBoltEntity(GunEntityTypes.STASER_BOLT_ENTITY_TYPE, world);
        return staserBoltEntity.createFromConstructor(world, shooter);
    }
    @Override
    public class_1799 method_7854() {
        class_1799 stack = new class_1799(this);
        class_2487 nbt = stack.method_7948();

        nbt.method_10549(FUEL_KEY, MAX_FUEL);

        return stack;
    }

    @Override
    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (otherStack.method_7909() instanceof ZeitonShardItem) {
            int shardCount = otherStack.method_7947();
            if (stack.method_7909() instanceof StaserBoltMagazine mag) {
                double ammo = mag.getCurrentFuel(stack);
                if (clickType == class_5536.field_27014 && mag.getCurrentFuel(stack) < mag.getMaxFuel(stack)) {
                    int residual = (int) ((ammo + shardCount) - mag.getCurrentFuel(stack));
                    mag.setCurrentFuel(Math.min(MAX_FUEL, ammo + shardCount), stack);
                    otherStack.method_7934(residual);
                    return true;
                }
            }
        }
        return super.method_31566(stack, otherStack, slot, clickType, player, cursorStackReference);
    }

    @Override
    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        super.method_7843(stack, world, player);
        class_2487 nbt = stack.method_7948();
        nbt.method_10549(FUEL_KEY, 0);
    }

    @Override
    public double getMaxFuel(class_1799 stack) {
        return MAX_FUEL;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        int currentFuel = (int) Math.round(this.getCurrentFuel(stack));
        class_124 fuelColor = currentFuel > (MAX_FUEL / 4) ? class_124.field_1060 : class_124.field_1061;

        tooltip.add(
                class_2561.method_43469("message.ait.artron_units", currentFuel)
                        .method_27692(fuelColor)
                        .method_10852(class_2561.method_43470(" / ").method_27692(class_124.field_1080))
                        .method_10852(class_2561.method_43470(String.valueOf(MAX_FUEL)).method_27692(class_124.field_1080))
        );

        super.method_7851(stack, world, tooltip, context);
    }
}
