package dev.amble.ait.module.gun.mixin.client;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import dev.amble.ait.module.gun.core.item.BaseGunItem;
import dev.amble.ait.module.gun.core.item.GunItems;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_746;
import net.minecraft.class_757;

@Mixin(class_757.class)
public abstract class GameRendererMixin {

    @Unique private boolean goBackFOV;
    @Unique private final double targetFOV = 45;
    @Unique private double currentFOV = targetFOV;

    @Inject(method = "getFov(Lnet/minecraft/client/render/Camera;FZ)D", at = @At("RETURN"), cancellable = true)
    public void ait$getFov(class_4184 camera, float tickDelta, boolean changingFov, CallbackInfoReturnable<Double> cir) {
        if (!changingFov) return;

        double d = cir.getReturnValue();
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) return;
        double newFov = setADS(d, class_310.method_1551().field_1724);
        if (d != newFov) cir.setReturnValue(newFov);
    }

    @Unique private static boolean isADS(class_746 player) {
        return class_310.method_1551().field_1690.field_1904.method_1434() && class_310.method_1551().field_1690.method_31044().method_31034() && player.method_6047().method_7909() instanceof BaseGunItem;
    }

    @Unique private double setADS(double fov, class_746 player) {
        double realTargetFOV = Math.max((player.method_6047().method_7909() == GunItems.CULT_STASER_RIFLE ? 10 : 30), currentFOV - (player.method_6047().method_7909() == GunItems.CULT_STASER_RIFLE ? 70 : targetFOV));
        if (isADS(player)) {
            float speed = player.method_6047().method_7909() == GunItems.CULT_STASER_RIFLE ? 0.2f : 0.4f;
            currentFOV = class_3532.method_16436(Math.min(speed * class_310.method_1551().method_1488(), speed), currentFOV, realTargetFOV);
            goBackFOV = true;
            return currentFOV;
        }
        else if (goBackFOV && Math.abs(currentFOV - fov) > 0.00001) {
            currentFOV = class_3532.method_16436(Math.min(0.95f * class_310.method_1551().method_1488(), 0.95f), currentFOV, fov);
            return currentFOV;
        } else {
            currentFOV = fov;
            goBackFOV = false;
            return fov;
        }
    }
}
