package dev.amble.ait.module.planet;

import static net.minecraft.class_2446.*;

import java.util.Optional;
import java.util.function.Consumer;

import dev.amble.ait.core.util.SpaceUtils;
import dev.amble.lib.container.RegistryContainer;
import dev.amble.lib.container.impl.BlockContainer;
import dev.amble.lib.container.impl.ItemContainer;
import dev.amble.lib.datagen.lang.AmbleLanguageProvider;
import dev.amble.lib.datagen.model.AmbleModelProvider;
import dev.amble.lib.itemgroup.AItemGroup;
import dev.amble.lib.register.AmbleRegistries;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_161;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_189;
import net.minecraft.class_1999;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4943;
import net.minecraft.class_5321;
import net.minecraft.class_7800;
import net.minecraft.class_7924;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.advancement.TardisCriterions;
import dev.amble.ait.datagen.datagen_providers.AITBlockTagProvider;
import dev.amble.ait.datagen.datagen_providers.AITItemTagProvider;
import dev.amble.ait.datagen.datagen_providers.AITRecipeProvider;
import dev.amble.ait.module.Module;
import dev.amble.ait.module.planet.client.SpaceSuitOverlay;
import dev.amble.ait.module.planet.core.PlanetBlockEntities;
import dev.amble.ait.module.planet.core.PlanetBlocks;
import dev.amble.ait.module.planet.core.PlanetItems;
import dev.amble.ait.module.planet.core.space.planet.PlanetRegistry;
import dev.amble.ait.module.planet.core.util.PlanetCustomTrades;

public class PlanetModule extends Module {
    private static final PlanetModule INSTANCE = new PlanetModule();

    public static final class_2960 ID = AITMod.id("planet");

    @Override
    public void init() {
        SpaceUtils.init();

        PlanetCustomTrades.registerCustomTrades();
        AmbleRegistries.getInstance().register(PlanetRegistry.getInstance());

        RegistryContainer.register(PlanetItems.class, AITMod.MOD_ID);
        RegistryContainer.register(PlanetBlocks.class, AITMod.MOD_ID);
        RegistryContainer.register(PlanetBlockEntities.class, AITMod.MOD_ID);
    }

    @Override
    protected AItemGroup.Builder buildItemGroup() {
        return AItemGroup.builder(id()).icon(() -> new class_1799(PlanetItems.SPACESUIT_HELMET));
    }

    @Environment(EnvType.CLIENT)
    @Override
    public void initClient() {
        HudRenderCallback.EVENT.register(new SpaceSuitOverlay());
    }

    @Override
    public class_2960 id() {
        return ID;
    }


    @Override
    public Optional<Class<? extends BlockContainer>> getBlockRegistry() {
        return Optional.of(PlanetBlocks.class);
    }

    @Override
    public Optional<Class<? extends ItemContainer>> getItemRegistry() {
        return Optional.of(PlanetItems.class);
    }

    @Override
    public Optional<DataGenerator> getDataGenerator() {
        return Optional.of(new DataGenerator() {
            @Override
            public void lang(AmbleLanguageProvider provider) {
                provider.addTranslation(getItemGroup(), "AIT: Planetary Exploration");
                provider.addTranslation("itemGroup.ait.planet", "AIT: Planetary Exploration");
                provider.addTranslation("message.ait.oxygen", "Stored Oxygen: %s");
                provider.addTranslation("achievements.ait.title.planet_root", "Planetary Exploration");
                provider.addTranslation("achievements.ait.description.planet_root", "Explore the planets of the universe");
                provider.addTranslation("achievements.ait.title.enter_mars", "You were not the first");
                provider.addTranslation("achievements.ait.description.enter_mars", "Landed on Mars for the first time");
                provider.addTranslation("achievements.ait.title.enter_moon", "One small step for Time Lords");
                provider.addTranslation("achievements.ait.description.enter_moon", "Landed on the Moon for the first time");
                provider.addTranslation("achievements.ait.find_planet_structure.title", "Veneration.");
                provider.addTranslation("achievements.ait.find_planet_structure.description", "Dread.");
            }

            @Override
            public void recipes(AITRecipeProvider provider) {

                // Martian
                provider.addStonecutting(PlanetBlocks.MARTIAN_STONE, PlanetBlocks.MARTIAN_BRICKS);
                provider.addStonecutting(PlanetBlocks.MARTIAN_STONE, PlanetBlocks.MARTIAN_BRICK_WALL);
                provider.addStonecutting(PlanetBlocks.MARTIAN_STONE, PlanetBlocks.MARTIAN_BRICK_STAIRS);
                provider.addStonecutting(PlanetBlocks.MARTIAN_STONE, PlanetBlocks.MARTIAN_BRICK_SLAB);
                provider.addStonecutting(PlanetBlocks.MARTIAN_STONE, PlanetBlocks.CHISELED_MARTIAN_STONE);
                provider.addStonecutting(PlanetBlocks.MARTIAN_STONE, PlanetBlocks.MARTIAN_STONE_SLAB);
                provider.addStonecutting(PlanetBlocks.MARTIAN_STONE, PlanetBlocks.MARTIAN_STONE_STAIRS);

                provider.addStonecutting(PlanetBlocks.MARTIAN_COBBLESTONE, PlanetBlocks.MARTIAN_COBBLESTONE_SLAB);
                provider.addStonecutting(PlanetBlocks.MARTIAN_COBBLESTONE, PlanetBlocks.MARTIAN_COBBLESTONE_STAIRS);
                provider.addStonecutting(PlanetBlocks.MARTIAN_COBBLESTONE, PlanetBlocks.MARTIAN_COBBLESTONE_WALL);

                provider.addStonecutting(PlanetBlocks.MARTIAN_SANDSTONE, PlanetBlocks.CHISELED_MARTIAN_SANDSTONE);
                provider.addStonecutting(PlanetBlocks.MARTIAN_SANDSTONE, PlanetBlocks.MARTIAN_SANDSTONE_PILLAR);
                provider.addStonecutting(PlanetBlocks.MARTIAN_SANDSTONE, PlanetBlocks.MARTIAN_SANDSTONE_BRICKS);
                provider.addStonecutting(PlanetBlocks.MARTIAN_SANDSTONE, PlanetBlocks.MARTIAN_SANDSTONE_SLAB);
                provider.addStonecutting(PlanetBlocks.MARTIAN_SANDSTONE, PlanetBlocks.MARTIAN_SANDSTONE_STAIRS);
                provider.addStonecutting(PlanetBlocks.MARTIAN_SANDSTONE, PlanetBlocks.MARTIAN_SANDSTONE_WALL);

                provider.addStonecutting(PlanetBlocks.MARTIAN_SANDSTONE_BRICKS, PlanetBlocks.CHISELED_MARTIAN_SANDSTONE);
                provider.addStonecutting(PlanetBlocks.MARTIAN_SANDSTONE_BRICKS, PlanetBlocks.MARTIAN_SANDSTONE_BRICK_SLAB);
                provider.addStonecutting(PlanetBlocks.MARTIAN_SANDSTONE_BRICKS, PlanetBlocks.MARTIAN_SANDSTONE_BRICK_STAIRS);
                provider.addStonecutting(PlanetBlocks.MARTIAN_SANDSTONE_BRICKS, PlanetBlocks.MARTIAN_SANDSTONE_BRICK_WALL);

                provider.addStonecutting(PlanetBlocks.MARTIAN_BRICKS, PlanetBlocks.MARTIAN_BRICK_WALL);
                provider.addStonecutting(PlanetBlocks.MARTIAN_BRICKS, PlanetBlocks.MARTIAN_BRICK_STAIRS);
                provider.addStonecutting(PlanetBlocks.MARTIAN_BRICKS, PlanetBlocks.MARTIAN_BRICK_SLAB);

                provider.addStonecutting(PlanetBlocks.SMOOTH_MARTIAN_STONE, PlanetBlocks.SMOOTH_MARTIAN_STONE_SLAB);

                provider.addStonecutting(PlanetBlocks.POLISHED_MARTIAN_STONE, PlanetBlocks.POLISHED_MARTIAN_STONE_SLAB);
                provider.addStonecutting(PlanetBlocks.POLISHED_MARTIAN_STONE, PlanetBlocks.POLISHED_MARTIAN_STONE_STAIRS);

                provider.addStonecutting(PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE, PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE_SLAB);
                provider.addStonecutting(PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE, PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE_STAIRS);

                // Anorthosite

                provider.addStonecutting(PlanetBlocks.ANORTHOSITE, PlanetBlocks.ANORTHOSITE_BRICKS);
                provider.addStonecutting(PlanetBlocks.ANORTHOSITE, PlanetBlocks.ANORTHOSITE_BRICK_WALL);
                provider.addStonecutting(PlanetBlocks.ANORTHOSITE, PlanetBlocks.ANORTHOSITE_BRICK_STAIRS);
                provider.addStonecutting(PlanetBlocks.ANORTHOSITE, PlanetBlocks.ANORTHOSITE_BRICK_SLAB);
                provider.addStonecutting(PlanetBlocks.ANORTHOSITE, PlanetBlocks.CHISELED_ANORTHOSITE);
                provider.addStonecutting(PlanetBlocks.ANORTHOSITE, PlanetBlocks.ANORTHOSITE_SLAB);
                provider.addStonecutting(PlanetBlocks.ANORTHOSITE, PlanetBlocks.ANORTHOSITE_STAIRS);
                provider.addStonecutting(PlanetBlocks.ANORTHOSITE, PlanetBlocks.ANORTHOSITE_WALL);

                provider.addStonecutting(PlanetBlocks.MOON_SANDSTONE, PlanetBlocks.CHISELED_MOON_SANDSTONE);
                provider.addStonecutting(PlanetBlocks.MOON_SANDSTONE, PlanetBlocks.MOON_SANDSTONE_PILLAR);
                provider.addStonecutting(PlanetBlocks.MOON_SANDSTONE, PlanetBlocks.MOON_SANDSTONE_BRICKS);
                provider.addStonecutting(PlanetBlocks.MOON_SANDSTONE, PlanetBlocks.MOON_SANDSTONE_SLAB);
                provider.addStonecutting(PlanetBlocks.MOON_SANDSTONE, PlanetBlocks.MOON_SANDSTONE_STAIRS);
                provider.addStonecutting(PlanetBlocks.MOON_SANDSTONE, PlanetBlocks.MOON_SANDSTONE_WALL);

                provider.addStonecutting(PlanetBlocks.MOON_SANDSTONE_BRICKS, PlanetBlocks.CHISELED_MOON_SANDSTONE);
                provider.addStonecutting(PlanetBlocks.MOON_SANDSTONE_BRICKS, PlanetBlocks.MOON_SANDSTONE_BRICK_SLAB);
                provider.addStonecutting(PlanetBlocks.MOON_SANDSTONE_BRICKS, PlanetBlocks.MOON_SANDSTONE_BRICK_STAIRS);
                provider.addStonecutting(PlanetBlocks.MOON_SANDSTONE_BRICKS, PlanetBlocks.MOON_SANDSTONE_BRICK_WALL);

                provider.addStonecutting(PlanetBlocks.ANORTHOSITE_BRICKS, PlanetBlocks.ANORTHOSITE_BRICK_WALL);
                provider.addStonecutting(PlanetBlocks.ANORTHOSITE_BRICKS, PlanetBlocks.ANORTHOSITE_BRICK_STAIRS);
                provider.addStonecutting(PlanetBlocks.ANORTHOSITE_BRICKS, PlanetBlocks.ANORTHOSITE_BRICK_SLAB);

                provider.addStonecutting(PlanetBlocks.SMOOTH_ANORTHOSITE, PlanetBlocks.SMOOTH_ANORTHOSITE_SLAB);

                provider.addStonecutting(PlanetBlocks.POLISHED_ANORTHOSITE, PlanetBlocks.POLISHED_ANORTHOSITE_SLAB);
                provider.addStonecutting(PlanetBlocks.POLISHED_ANORTHOSITE, PlanetBlocks.POLISHED_ANORTHOSITE_STAIRS);

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40635, PlanetBlocks.FLAG, 1)
                        .method_10439("GBR")
                        .method_10439("IWW")
                        .method_10439("I  ")
                        .method_10434('G', class_1802.field_8695)
                        .method_10434('I', class_1802.field_8620)
                        .method_10434('B', class_1802.field_19055)
                        .method_10434('R', class_1802.field_19058)
                        .method_10434('W', class_1802.field_19044)
                        .method_10429(method_32807(class_1802.field_8695), method_10426(class_1802.field_8695))
                        .method_10429(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
                        .method_10429(method_32807(class_1802.field_19058), method_10426(class_1802.field_19058))
                        .method_10429(method_32807(class_1802.field_19055), method_10426(class_1802.field_19055))
                        .method_10429(method_32807(class_1802.field_19044), method_10426(class_1802.field_19044)));

                // tendo count your fucking days

                // anorthosite section
                // polished anorthosite
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.POLISHED_ANORTHOSITE, 4)
                        .method_10439("##")
                        .method_10439("##")
                        .method_10434('#', PlanetBlocks.ANORTHOSITE)
                        .method_10429(method_32807(PlanetBlocks.ANORTHOSITE), method_10426(PlanetBlocks.ANORTHOSITE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.POLISHED_ANORTHOSITE_SLAB, 6)
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.POLISHED_ANORTHOSITE)
                        .method_10429(method_32807(PlanetBlocks.POLISHED_ANORTHOSITE), method_10426(PlanetBlocks.POLISHED_ANORTHOSITE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.POLISHED_ANORTHOSITE_STAIRS, 4)
                        .method_10439("#  ")
                        .method_10439("## ")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.POLISHED_ANORTHOSITE)
                        .method_10429(method_32807(PlanetBlocks.POLISHED_ANORTHOSITE), method_10426(PlanetBlocks.POLISHED_ANORTHOSITE)));
                // smooth anorthosite
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.ANORTHOSITE),
                                class_7800.field_40634, PlanetBlocks.SMOOTH_ANORTHOSITE, 0.3f, 200)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE), method_10426(PlanetBlocks.ANORTHOSITE)),
                new class_2960("ait", "smooth_anorthosite_from_anorthosite_smelted"));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.SMOOTH_ANORTHOSITE_SLAB, 6)
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.SMOOTH_ANORTHOSITE)
                        .method_10429(method_32807(PlanetBlocks.SMOOTH_ANORTHOSITE), method_10426(PlanetBlocks.SMOOTH_ANORTHOSITE)));
                //normal anorthosite
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.ANORTHOSITE_WALL, 6)
                        .method_10439("###")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.ANORTHOSITE)
                        .method_10429(method_32807(PlanetBlocks.ANORTHOSITE), method_10426(PlanetBlocks.ANORTHOSITE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.ANORTHOSITE_SLAB, 6)
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.ANORTHOSITE)
                        .method_10429(method_32807(PlanetBlocks.ANORTHOSITE), method_10426(PlanetBlocks.ANORTHOSITE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.ANORTHOSITE_STAIRS, 4)
                        .method_10439("#  ")
                        .method_10439("## ")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.ANORTHOSITE)
                        .method_10429(method_32807(PlanetBlocks.ANORTHOSITE), method_10426(PlanetBlocks.ANORTHOSITE)));
                // anorthosite bricks
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.ANORTHOSITE_BRICKS, 4)
                        .method_10439("##")
                        .method_10439("##")
                        .method_10434('#', PlanetBlocks.SMOOTH_ANORTHOSITE)
                        .method_10429(method_32807(PlanetBlocks.SMOOTH_ANORTHOSITE), method_10426(PlanetBlocks.SMOOTH_ANORTHOSITE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.ANORTHOSITE_BRICK_SLAB, 6)
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.ANORTHOSITE_BRICKS)
                        .method_10429(method_32807(PlanetBlocks.ANORTHOSITE_BRICKS), method_10426(PlanetBlocks.ANORTHOSITE_BRICKS)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.ANORTHOSITE_BRICK_STAIRS, 4)
                        .method_10439("#  ")
                        .method_10439("## ")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.ANORTHOSITE_BRICKS)
                        .method_10429(method_32807(PlanetBlocks.ANORTHOSITE_BRICKS), method_10426(PlanetBlocks.ANORTHOSITE_BRICKS)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.ANORTHOSITE_BRICK_WALL, 6)
                        .method_10439("###")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.ANORTHOSITE_BRICKS)
                        .method_10429(method_32807(PlanetBlocks.ANORTHOSITE_BRICKS), method_10426(PlanetBlocks.ANORTHOSITE_BRICKS)));
                //chiseled anorthosite, anorthosite pillar, cracked anorthosite brick
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.CHISELED_ANORTHOSITE, 1)
                        .method_10439("#")
                        .method_10439("#")
                        .method_10434('#', PlanetBlocks.ANORTHOSITE_SLAB)
                        .method_10429(method_32807(PlanetBlocks.ANORTHOSITE_SLAB), method_10426(PlanetBlocks.ANORTHOSITE_SLAB)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.ANORTHOSITE_PILLAR, 1)
                        .method_10439("#")
                        .method_10439("#")
                        .method_10434('#', PlanetBlocks.SMOOTH_ANORTHOSITE)
                        .method_10429(method_32807(PlanetBlocks.SMOOTH_ANORTHOSITE), method_10426(PlanetBlocks.SMOOTH_ANORTHOSITE)));
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_BRICKS),
                                        class_7800.field_40634, PlanetBlocks.CRACKED_ANORTHOSITE_BRICKS, 0.7f, 200)
                                .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_BRICKS), method_10426(PlanetBlocks.ANORTHOSITE_BRICKS)),
                        new class_2960("ait", "cracked_anorthosite_bricks_from_anorthosite_bricks_smelted"));

                // anorthosite ores
                //coal
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_COAL_ORE),
                                class_7800.field_40642, class_1802.field_8713, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_COAL_ORE), method_10426(PlanetBlocks.ANORTHOSITE_COAL_ORE)),
                new class_2960("ait", "coal_from_anorthosite_smelted"));

                provider.addBlastFurnaceRecipe(class_2454.method_10473(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_COAL_ORE),
                                class_7800.field_40642, class_1802.field_8713, 0.7f, 100)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_COAL_ORE), method_10426(PlanetBlocks.ANORTHOSITE_COAL_ORE)),
                new class_2960("ait", "coal_from_anorthosite_blasted"));
                //copper
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_COPPER_ORE),
                                class_7800.field_40642, class_1802.field_27022, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_COPPER_ORE), method_10426(PlanetBlocks.ANORTHOSITE_COPPER_ORE)),
                new class_2960("ait", "copper_from_anorthosite_smelted"));
                provider.addBlastFurnaceRecipe(class_2454.method_10473(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_COPPER_ORE),
                                class_7800.field_40642, class_1802.field_27022, 0.7f, 100)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_COPPER_ORE), method_10426(PlanetBlocks.ANORTHOSITE_COPPER_ORE)),
                new class_2960("ait", "copper_from_anorthosite_blasted"));
                //iron
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_IRON_ORE),
                                class_7800.field_40642, class_1802.field_8620, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_IRON_ORE), method_10426(PlanetBlocks.ANORTHOSITE_IRON_ORE)),
                new class_2960("ait", "iron_from_anorthosite_smelted"));
                provider.addBlastFurnaceRecipe(class_2454.method_10473(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_IRON_ORE),
                                class_7800.field_40642, class_1802.field_8620, 0.7f, 100)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_IRON_ORE), method_10426(PlanetBlocks.ANORTHOSITE_IRON_ORE)),
                new class_2960("ait", "iron_from_anorthosite_blasted"));
                //gold
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_GOLD_ORE),
                                class_7800.field_40642, class_1802.field_8695, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_GOLD_ORE), method_10426(PlanetBlocks.ANORTHOSITE_GOLD_ORE)),
                new class_2960("ait", "gold_from_anorthosite_smelted"));
                provider.addBlastFurnaceRecipe(class_2454.method_10473(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_GOLD_ORE),
                                class_7800.field_40642, class_1802.field_8695, 0.7f, 100)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_GOLD_ORE), method_10426(PlanetBlocks.ANORTHOSITE_GOLD_ORE)),
                new class_2960("ait", "gold_from_anorthosite_blasted"));
                //redstone
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_REDSTONE_ORE),
                                class_7800.field_40642, class_1802.field_8725, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_REDSTONE_ORE), method_10426(PlanetBlocks.ANORTHOSITE_REDSTONE_ORE)),
                new class_2960("ait", "redstone_from_anorthosite_smelted"));
                provider.addBlastFurnaceRecipe(class_2454.method_10473(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_REDSTONE_ORE),
                                class_7800.field_40642, class_1802.field_8725, 0.7f, 100)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_REDSTONE_ORE), method_10426(PlanetBlocks.ANORTHOSITE_REDSTONE_ORE)),
                new class_2960("ait", "redstone_from_anorthosite_blasted"));
                //lapis
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_LAPIS_ORE),
                                class_7800.field_40642, class_1802.field_8759, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_LAPIS_ORE), method_10426(PlanetBlocks.ANORTHOSITE_LAPIS_ORE)),
                new class_2960("ait", "lapis_from_anorthosite_smelted"));
                provider.addBlastFurnaceRecipe(class_2454.method_10473(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_LAPIS_ORE),
                                class_7800.field_40642, class_1802.field_8759, 0.7f, 100)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_LAPIS_ORE), method_10426(PlanetBlocks.ANORTHOSITE_LAPIS_ORE)),
                new class_2960("ait", "lapis_from_anorthosite_blasted"));
                //diamond
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_DIAMOND_ORE),
                                class_7800.field_40642, class_1802.field_8477, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_DIAMOND_ORE), method_10426(PlanetBlocks.ANORTHOSITE_DIAMOND_ORE)),
                new class_2960("ait", "diamond_from_anorthosite_smelted"));
                provider.addBlastFurnaceRecipe(class_2454.method_10473(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_DIAMOND_ORE),
                                class_7800.field_40642, class_1802.field_8477, 0.7f, 100)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_DIAMOND_ORE), method_10426(PlanetBlocks.ANORTHOSITE_DIAMOND_ORE)),
                new class_2960("ait", "diamond_from_anorthosite_blasted"));
                //emerald
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_EMERALD_ORE),
                                class_7800.field_40642, class_1802.field_8687, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_EMERALD_ORE), method_10426(PlanetBlocks.ANORTHOSITE_EMERALD_ORE)),
                new class_2960("ait", "emerald_from_anorthosite_smelted"));
                provider.addBlastFurnaceRecipe(class_2454.method_10473(class_1856.method_8091(PlanetBlocks.ANORTHOSITE_EMERALD_ORE),
                                class_7800.field_40642, class_1802.field_8687, 0.7f, 100)
                        .method_10469(method_32807(PlanetBlocks.ANORTHOSITE_EMERALD_ORE), method_10426(PlanetBlocks.ANORTHOSITE_EMERALD_ORE)),
                new class_2960("ait", "emerald_from_anorthosite_blasted"));

                // moon sandstone section
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MOON_SANDSTONE_WALL, 6)
                        .method_10439("###")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MOON_SANDSTONE)
                        .method_10429(method_32807(PlanetBlocks.MOON_SANDSTONE), method_10426(PlanetBlocks.MOON_SANDSTONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MOON_SANDSTONE_SLAB, 6)
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MOON_SANDSTONE)
                        .method_10429(method_32807(PlanetBlocks.MOON_SANDSTONE), method_10426(PlanetBlocks.MOON_SANDSTONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MOON_SANDSTONE_STAIRS, 4)
                        .method_10439("#  ")
                        .method_10439("## ")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MOON_SANDSTONE)
                        .method_10429(method_32807(PlanetBlocks.MOON_SANDSTONE), method_10426(PlanetBlocks.MOON_SANDSTONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.POLISHED_MOON_SANDSTONE, 4)
                        .method_10439("##")
                        .method_10439("##")
                        .method_10434('#', PlanetBlocks.MOON_SANDSTONE)
                        .method_10429(method_32807(PlanetBlocks.MOON_SANDSTONE), method_10426(PlanetBlocks.MOON_SANDSTONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MOON_SANDSTONE_BRICKS, 4)
                        .method_10439("##")
                        .method_10439("##")
                        .method_10434('#', PlanetBlocks.POLISHED_MOON_SANDSTONE)
                        .method_10429(method_32807(PlanetBlocks.POLISHED_MOON_SANDSTONE), method_10426(PlanetBlocks.POLISHED_MOON_SANDSTONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MOON_SANDSTONE_BRICK_WALL, 6)
                        .method_10439("###")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MOON_SANDSTONE_BRICKS)
                        .method_10429(method_32807(PlanetBlocks.MOON_SANDSTONE_BRICKS), method_10426(PlanetBlocks.MOON_SANDSTONE_BRICKS)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MOON_SANDSTONE_BRICK_SLAB, 6)
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MOON_SANDSTONE_BRICKS)
                        .method_10429(method_32807(PlanetBlocks.MOON_SANDSTONE_BRICKS), method_10426(PlanetBlocks.MOON_SANDSTONE_BRICKS)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MOON_SANDSTONE_BRICK_STAIRS, 4)
                        .method_10439("#  ")
                        .method_10439("## ")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MOON_SANDSTONE_BRICKS)
                        .method_10429(method_32807(PlanetBlocks.MOON_SANDSTONE_BRICKS), method_10426(PlanetBlocks.MOON_SANDSTONE_BRICKS)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.CHISELED_MOON_SANDSTONE, 1)
                        .method_10439("#")
                        .method_10439("#")
                        .method_10434('#', PlanetBlocks.MOON_SANDSTONE_SLAB)
                        .method_10429(method_32807(PlanetBlocks.MOON_SANDSTONE_SLAB), method_10426(PlanetBlocks.MOON_SANDSTONE_SLAB)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MOON_SANDSTONE_PILLAR, 1)
                        .method_10439("#")
                        .method_10439("#")
                        .method_10434('#', PlanetBlocks.POLISHED_MOON_SANDSTONE)
                        .method_10429(method_32807(PlanetBlocks.POLISHED_MOON_SANDSTONE), method_10426(PlanetBlocks.POLISHED_MOON_SANDSTONE)));
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.MOON_SANDSTONE_BRICKS),
                                class_7800.field_40634, PlanetBlocks.CRACKED_MOON_SANDSTONE_BRICKS, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.MOON_SANDSTONE_BRICKS), method_10426(PlanetBlocks.MOON_SANDSTONE_BRICKS)),
                new class_2960("ait", "cracked_moon_sandstone_bricks_from_moon_sandstone_bricks_smelted"));
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.MOON_SANDSTONE),
                                class_7800.field_40634, PlanetBlocks.CRACKED_MOON_SANDSTONE, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.MOON_SANDSTONE), method_10426(PlanetBlocks.MOON_SANDSTONE)),
                new class_2960("ait", "cracked_moon_sandstone_from_moon_sandstone_smelted"));

                // martian section

                // martian ores
                //coal
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.MARTIAN_COAL_ORE),
                                class_7800.field_40642, class_1802.field_8713, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_COAL_ORE), method_10426(PlanetBlocks.MARTIAN_COAL_ORE)),
                new class_2960("ait", "coal_from_martian_smelted"));
                provider.addBlastFurnaceRecipe(class_2454.method_10473(class_1856.method_8091(PlanetBlocks.MARTIAN_COAL_ORE),
                                class_7800.field_40642, class_1802.field_8713, 0.7f, 100)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_COAL_ORE), method_10426(PlanetBlocks.MARTIAN_COAL_ORE)),
                new class_2960("ait", "coal_from_martian_blasted"));
                //copper
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.MARTIAN_COPPER_ORE),
                                class_7800.field_40642, class_1802.field_27022, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_COPPER_ORE), method_10426(PlanetBlocks.MARTIAN_COPPER_ORE)),
                new class_2960("ait", "copper_from_martian_smelted"));
                provider.addBlastFurnaceRecipe(class_2454.method_10473(class_1856.method_8091(PlanetBlocks.MARTIAN_COPPER_ORE),
                                class_7800.field_40642, class_1802.field_27022, 0.7f, 100)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_COPPER_ORE), method_10426(PlanetBlocks.MARTIAN_COPPER_ORE)),
                new class_2960("ait", "copper_from_martian_blasted"));
                //iron
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.MARTIAN_IRON_ORE),
                                class_7800.field_40642, class_1802.field_8620, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_IRON_ORE), method_10426(PlanetBlocks.MARTIAN_IRON_ORE)),
                new class_2960("ait", "iron_from_martian_smelted"));
                provider.addBlastFurnaceRecipe(class_2454.method_10473(class_1856.method_8091(PlanetBlocks.MARTIAN_IRON_ORE),
                                class_7800.field_40642, class_1802.field_8620, 0.7f, 100)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_IRON_ORE), method_10426(PlanetBlocks.MARTIAN_IRON_ORE)),
                new class_2960("ait", "iron_from_martian_blasted"));
                //gold
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.MARTIAN_GOLD_ORE),
                                class_7800.field_40642, class_1802.field_8695, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_GOLD_ORE), method_10426(PlanetBlocks.MARTIAN_GOLD_ORE)),
                new class_2960("ait", "gold_from_martian_smelted"));
                provider.addBlastFurnaceRecipe(class_2454.method_10473(class_1856.method_8091(PlanetBlocks.MARTIAN_GOLD_ORE),
                                class_7800.field_40642, class_1802.field_8695, 0.7f, 100)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_GOLD_ORE), method_10426(PlanetBlocks.MARTIAN_GOLD_ORE)),
                new class_2960("ait", "gold_from_martian_blasted"));
                //redstone
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.MARTIAN_REDSTONE_ORE),
                                class_7800.field_40642, class_1802.field_8725, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_REDSTONE_ORE), method_10426(PlanetBlocks.MARTIAN_REDSTONE_ORE)),
                new class_2960("ait", "redstone_from_martian_smelted"));
                provider.addBlastFurnaceRecipe(class_2454.method_10473(class_1856.method_8091(PlanetBlocks.MARTIAN_REDSTONE_ORE),
                                class_7800.field_40642, class_1802.field_8725, 0.7f, 100)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_REDSTONE_ORE), method_10426(PlanetBlocks.MARTIAN_REDSTONE_ORE)),
                new class_2960("ait", "redstone_from_martian_blasted"));
                //lapis
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.MARTIAN_LAPIS_ORE),
                                class_7800.field_40642, class_1802.field_8759, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_LAPIS_ORE), method_10426(PlanetBlocks.MARTIAN_LAPIS_ORE)),
                new class_2960("ait", "lapis_from_martian_smelted"));
                provider.addBlastFurnaceRecipe(class_2454.method_10473(class_1856.method_8091(PlanetBlocks.MARTIAN_LAPIS_ORE),
                                class_7800.field_40642, class_1802.field_8759, 0.7f, 100)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_LAPIS_ORE), method_10426(PlanetBlocks.MARTIAN_LAPIS_ORE)),
                new class_2960("ait", "lapis_from_martian_blasted"));
                //diamond
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.MARTIAN_DIAMOND_ORE),
                                class_7800.field_40642, class_1802.field_8477, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_DIAMOND_ORE), method_10426(PlanetBlocks.MARTIAN_DIAMOND_ORE)),
                new class_2960("ait", "diamond_from_martian_smelted"));
                provider.addBlastFurnaceRecipe(class_2454.method_10473(class_1856.method_8091(PlanetBlocks.MARTIAN_DIAMOND_ORE),
                                class_7800.field_40642, class_1802.field_8477, 0.7f, 100)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_DIAMOND_ORE), method_10426(PlanetBlocks.MARTIAN_DIAMOND_ORE)),
                new class_2960("ait", "diamond_from_martian_blasted"));
                //emerald
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.MARTIAN_EMERALD_ORE),
                                class_7800.field_40642, class_1802.field_8687, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_EMERALD_ORE), method_10426(PlanetBlocks.MARTIAN_EMERALD_ORE)),
                new class_2960("ait", "emerald_from_martian_smelted"));
                provider.addBlastFurnaceRecipe(class_2454.method_10473(class_1856.method_8091(PlanetBlocks.MARTIAN_EMERALD_ORE),
                                class_7800.field_40642, class_1802.field_8687, 0.7f, 100)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_EMERALD_ORE), method_10426(PlanetBlocks.MARTIAN_EMERALD_ORE)),
                new class_2960("ait", "emerald_from_martian_blasted"));

                // martian stones
                provider.addShapelessRecipe(class_2450.method_10448(class_7800.field_40636, PlanetBlocks.MARTIAN_STONE_BUTTON, 1)
                        .method_10454(PlanetBlocks.MARTIAN_STONE)
                        .method_10442(method_32807(PlanetBlocks.MARTIAN_STONE), method_10426(PlanetBlocks.MARTIAN_STONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_STONE_PRESSURE_PLATE, 1)
                        .method_10439("##")
                        .method_10434('#', PlanetBlocks.MARTIAN_STONE)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_STONE), method_10426(PlanetBlocks.MARTIAN_STONE)));
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.MARTIAN_COBBLESTONE),
                                class_7800.field_40634, PlanetBlocks.MARTIAN_STONE, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_COBBLESTONE), method_10426(PlanetBlocks.MARTIAN_COBBLESTONE)),
                new class_2960("ait", "martian_stone_from_martian_cobblestone_smelted"));
                // martian cobblestones
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_COBBLESTONE_WALL, 6)
                        .method_10439("###")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MARTIAN_COBBLESTONE)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_COBBLESTONE), method_10426(PlanetBlocks.MARTIAN_COBBLESTONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_COBBLESTONE_SLAB, 6)
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MARTIAN_COBBLESTONE)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_COBBLESTONE), method_10426(PlanetBlocks.MARTIAN_COBBLESTONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_COBBLESTONE_STAIRS, 4)
                        .method_10439("#  ")
                        .method_10439("## ")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MARTIAN_COBBLESTONE)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_COBBLESTONE), method_10426(PlanetBlocks.MARTIAN_COBBLESTONE)));
                // polished martian stone
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.POLISHED_MARTIAN_STONE, 4)
                        .method_10439("##")
                        .method_10439("##")
                        .method_10434('#', PlanetBlocks.MARTIAN_STONE)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_STONE), method_10426(PlanetBlocks.MARTIAN_STONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.POLISHED_MARTIAN_STONE_SLAB, 6)
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.POLISHED_MARTIAN_STONE)
                        .method_10429(method_32807(PlanetBlocks.POLISHED_MARTIAN_STONE), method_10426(PlanetBlocks.POLISHED_MARTIAN_STONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.POLISHED_MARTIAN_STONE_STAIRS, 4)
                        .method_10439("#  ")
                        .method_10439("## ")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.POLISHED_MARTIAN_STONE)
                        .method_10429(method_32807(PlanetBlocks.POLISHED_MARTIAN_STONE), method_10426(PlanetBlocks.POLISHED_MARTIAN_STONE)));
                // smooth martian stone
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.MARTIAN_STONE),
                                class_7800.field_40634, PlanetBlocks.SMOOTH_MARTIAN_STONE, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_STONE), method_10426(PlanetBlocks.MARTIAN_STONE)),
                new class_2960("ait", "smooth_martian_stone_from_martian_stone_smelted"));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.SMOOTH_MARTIAN_STONE_SLAB, 6)
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.SMOOTH_MARTIAN_STONE)
                        .method_10429(method_32807(PlanetBlocks.SMOOTH_MARTIAN_STONE), method_10426(PlanetBlocks.SMOOTH_MARTIAN_STONE)));
                // martian sandstone
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_SANDSTONE, 1)
                        .method_10439("##")
                        .method_10439("##")
                        .method_10434('#', PlanetBlocks.MARTIAN_SAND)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_SAND), method_10426(PlanetBlocks.MARTIAN_SAND)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.POLISHED_MARTIAN_SANDSTONE, 4)
                        .method_10439("##")
                        .method_10439("##")
                        .method_10434('#', PlanetBlocks.MARTIAN_SANDSTONE)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_SANDSTONE), method_10426(PlanetBlocks.MARTIAN_SANDSTONE)));
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.MARTIAN_SANDSTONE),
                                class_7800.field_40634, PlanetBlocks.CRACKED_MARTIAN_SANDSTONE, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_SANDSTONE), method_10426(PlanetBlocks.MARTIAN_SANDSTONE)),
                new class_2960("ait", "cracked_martian_sandstone_from_martian_sandstone_smelted"));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_SANDSTONE_WALL, 6)
                        .method_10439("###")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MARTIAN_SANDSTONE)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_SANDSTONE), method_10426(PlanetBlocks.MARTIAN_SANDSTONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_SANDSTONE_SLAB, 6)
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MARTIAN_SANDSTONE)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_SANDSTONE), method_10426(PlanetBlocks.MARTIAN_SANDSTONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_SANDSTONE_STAIRS, 4)
                        .method_10439("#  ")
                        .method_10439("## ")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MARTIAN_SANDSTONE)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_SANDSTONE), method_10426(PlanetBlocks.MARTIAN_SANDSTONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_SANDSTONE_PILLAR, 1)
                        .method_10439("#")
                        .method_10439("#")
                        .method_10434('#', PlanetBlocks.POLISHED_MARTIAN_SANDSTONE)
                        .method_10429(method_32807(PlanetBlocks.POLISHED_MARTIAN_SANDSTONE), method_10426(PlanetBlocks.POLISHED_MARTIAN_SANDSTONE)));
                // martian sandstone bricks, martian sandstone brick wall, slab, stairs, cracked, chiseled
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_SANDSTONE_BRICKS, 4)
                        .method_10439("##")
                        .method_10439("##")
                        .method_10434('#', PlanetBlocks.POLISHED_MARTIAN_SANDSTONE)
                        .method_10429(method_32807(PlanetBlocks.POLISHED_MARTIAN_SANDSTONE), method_10426(PlanetBlocks.POLISHED_MARTIAN_SANDSTONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_SANDSTONE_BRICK_WALL, 6)
                        .method_10439("###")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MARTIAN_SANDSTONE_BRICKS)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_SANDSTONE_BRICKS), method_10426(PlanetBlocks.MARTIAN_SANDSTONE_BRICKS)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_SANDSTONE_BRICK_SLAB, 6)
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MARTIAN_SANDSTONE_BRICKS)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_SANDSTONE_BRICKS), method_10426(PlanetBlocks.MARTIAN_SANDSTONE_BRICKS)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_SANDSTONE_BRICK_STAIRS, 4)
                        .method_10439("#  ")
                        .method_10439("## ")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MARTIAN_SANDSTONE_BRICKS)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_SANDSTONE_BRICKS), method_10426(PlanetBlocks.MARTIAN_SANDSTONE_BRICKS)));
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.MARTIAN_SANDSTONE_BRICKS),
                                class_7800.field_40634, PlanetBlocks.CRACKED_MARTIAN_SANDSTONE_BRICKS, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_SANDSTONE_BRICKS), method_10426(PlanetBlocks.MARTIAN_SANDSTONE_BRICKS)),
                new class_2960("ait", "cracked_martian_sandstone_bricks_from_martian_sandstone_bricks_smelted"));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.CHISELED_MARTIAN_SANDSTONE, 1)
                        .method_10439("#")
                        .method_10439("#")
                        .method_10434('#', PlanetBlocks.MARTIAN_SANDSTONE_SLAB)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_SANDSTONE_SLAB), method_10426(PlanetBlocks.MARTIAN_SANDSTONE_SLAB)));
                // martian bricks
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_BRICKS, 4)
                        .method_10439("##")
                        .method_10439("##")
                        .method_10434('#', PlanetBlocks.SMOOTH_MARTIAN_STONE)
                        .method_10429(method_32807(PlanetBlocks.SMOOTH_MARTIAN_STONE), method_10426(PlanetBlocks.SMOOTH_MARTIAN_STONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_BRICK_WALL, 6)
                        .method_10439("###")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MARTIAN_BRICKS)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_BRICKS), method_10426(PlanetBlocks.MARTIAN_BRICKS)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_BRICK_SLAB, 6)
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MARTIAN_BRICKS)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_BRICKS), method_10426(PlanetBlocks.MARTIAN_BRICKS)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_BRICK_STAIRS, 4)
                        .method_10439("#  ")
                        .method_10439("## ")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MARTIAN_BRICKS)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_BRICKS), method_10426(PlanetBlocks.MARTIAN_BRICKS)));
                provider.addFurnaceRecipe(class_2454.method_17802(class_1856.method_8091(PlanetBlocks.MARTIAN_BRICKS),
                                class_7800.field_40634, PlanetBlocks.CRACKED_MARTIAN_BRICKS, 0.7f, 200)
                        .method_10469(method_32807(PlanetBlocks.MARTIAN_BRICKS), method_10426(PlanetBlocks.MARTIAN_BRICKS)),
                new class_2960("ait", "cracked_martian_bricks_from_martian_bricks_smelted"));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_PILLAR, 1)
                        .method_10439("#")
                        .method_10439("#")
                        .method_10434('#', PlanetBlocks.POLISHED_MARTIAN_STONE)
                        .method_10429(method_32807(PlanetBlocks.POLISHED_MARTIAN_STONE), method_10426(PlanetBlocks.POLISHED_MARTIAN_STONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.CHISELED_MARTIAN_STONE, 1)
                        .method_10439("#")
                        .method_10439("#")
                        .method_10434('#', PlanetBlocks.MARTIAN_BRICK_SLAB)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_BRICK_SLAB), method_10426(PlanetBlocks.MARTIAN_BRICK_SLAB)));
                // mossy martian cobblestone
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE, 1)
                        .method_10439("#M")
                        .method_10434('#', PlanetBlocks.MARTIAN_COBBLESTONE)
                        .method_10428('M', class_1856.method_8091(class_1802.field_28654, class_1802.field_17523))
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_COBBLESTONE), method_10426(PlanetBlocks.MARTIAN_COBBLESTONE))
                        .method_10429(method_32807(class_1802.field_28654), method_10426(class_1802.field_28654))
                        .method_10429(method_32807(class_1802.field_17523), method_10426(class_1802.field_17523)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE_WALL, 6)
                        .method_10439("###")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE)
                        .method_10429(method_32807(PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE), method_10426(PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE_SLAB, 6)
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE)
                        .method_10429(method_32807(PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE), method_10426(PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE)));
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE_STAIRS, 4)
                        .method_10439("#  ")
                        .method_10439("## ")
                        .method_10439("###")
                        .method_10434('#', PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE)
                        .method_10429(method_32807(PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE), method_10426(PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE)));


                // Spacesuits
                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40635, PlanetItems.SPACESUIT_BOOTS, 1)
                        .method_10439("   ")
                        .method_10439("F F")
                        .method_10439("FBF")
                        .method_10434('F', PlanetItems.FABRIC)
                        .method_10434('B', class_1802.field_8660)
                        .method_10429(method_32807(PlanetItems.FABRIC), method_10426(PlanetItems.FABRIC))
                        .method_10429(method_32807(class_1802.field_8660), method_10426(class_1802.field_8660)));

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40635, PlanetItems.SPACESUIT_LEGGINGS, 1)
                        .method_10439("FLF")
                        .method_10439("F F")
                        .method_10439("F F")
                        .method_10434('F', PlanetItems.FABRIC)
                        .method_10434('L', class_1802.field_8396)
                        .method_10429(method_32807(PlanetItems.FABRIC), method_10426(PlanetItems.FABRIC))
                        .method_10429(method_32807(class_1802.field_8396), method_10426(class_1802.field_8396)));

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40635, PlanetItems.SPACESUIT_CHESTPLATE, 1)
                        .method_10439("F F")
                        .method_10439("FCF")
                        .method_10439("FBF")
                        .method_10434('F', PlanetItems.FABRIC)
                        .method_10434('B', class_1802.field_8550)
                        .method_10434('C', class_1802.field_8523)
                        .method_10429(method_32807(PlanetItems.FABRIC), method_10426(PlanetItems.FABRIC))
                        .method_10429(method_32807(class_1802.field_8550), method_10426(class_1802.field_8550))
                        .method_10429(method_32807(class_1802.field_8523), method_10426(class_1802.field_8523)));

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40635, PlanetItems.SPACESUIT_HELMET, 1)
                        .method_10439("FHF")
                        .method_10439("FGF")
                        .method_10439("FFF")
                        .method_10434('F', PlanetItems.FABRIC)
                        .method_10434('H', class_1802.field_8743)
                        .method_10434('G', class_1802.field_8703)
                        .method_10429(method_32807(PlanetItems.FABRIC), method_10426(PlanetItems.FABRIC))
                        .method_10429(method_32807(class_1802.field_8743), method_10426(class_1802.field_8743))
                        .method_10429(method_32807(class_1802.field_8703), method_10426(class_1802.field_8703)));

                // Martian Tools

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40638, PlanetItems.MARTIAN_STONE_PICKAXE, 1)
                        .method_10439("MMM")
                        .method_10439(" S ")
                        .method_10439(" S ")
                        .method_10434('M', PlanetBlocks.MARTIAN_COBBLESTONE)
                        .method_10434('S', class_1802.field_8600)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_COBBLESTONE), method_10426(PlanetBlocks.MARTIAN_COBBLESTONE))
                        .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600)));

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40638, PlanetItems.MARTIAN_STONE_SWORD, 1)
                        .method_10439(" M ")
                        .method_10439(" M ")
                        .method_10439(" S ")
                        .method_10434('M', PlanetBlocks.MARTIAN_COBBLESTONE)
                        .method_10434('S', class_1802.field_8600)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_COBBLESTONE), method_10426(PlanetBlocks.MARTIAN_COBBLESTONE))
                        .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600)));

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40638, PlanetItems.MARTIAN_STONE_SHOVEL, 1)
                        .method_10439(" M ")
                        .method_10439(" S ")
                        .method_10439(" S ")
                        .method_10434('M', PlanetBlocks.MARTIAN_COBBLESTONE)
                        .method_10434('S', class_1802.field_8600)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_COBBLESTONE), method_10426(PlanetBlocks.MARTIAN_COBBLESTONE))
                        .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600)));

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40638, PlanetItems.MARTIAN_STONE_HOE, 1)
                        .method_10439(" MM")
                        .method_10439(" S ")
                        .method_10439(" S ")
                        .method_10434('M', PlanetBlocks.MARTIAN_COBBLESTONE)
                        .method_10434('S', class_1802.field_8600)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_COBBLESTONE), method_10426(PlanetBlocks.MARTIAN_COBBLESTONE))
                        .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600)));

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40638, PlanetItems.MARTIAN_STONE_AXE, 1)
                        .method_10439(" MM")
                        .method_10439(" SM")
                        .method_10439(" S ")
                        .method_10434('M', PlanetBlocks.MARTIAN_COBBLESTONE)
                        .method_10434('S', class_1802.field_8600)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_COBBLESTONE), method_10426(PlanetBlocks.MARTIAN_COBBLESTONE))
                        .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600)));

                // Anorthosite Tools

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40638, PlanetItems.ANORTHOSITE_PICKAXE, 1)
                        .method_10439("MMM")
                        .method_10439(" S ")
                        .method_10439(" S ")
                        .method_10434('M', PlanetBlocks.ANORTHOSITE)
                        .method_10434('S', class_1802.field_8600)
                        .method_10429(method_32807(PlanetBlocks.ANORTHOSITE), method_10426(PlanetBlocks.ANORTHOSITE))
                        .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600)));

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40638, PlanetItems.ANORTHOSITE_SWORD, 1)
                        .method_10439(" M ")
                        .method_10439(" M ")
                        .method_10439(" S ")
                        .method_10434('M', PlanetBlocks.ANORTHOSITE)
                        .method_10434('S', class_1802.field_8600)
                        .method_10429(method_32807(PlanetBlocks.ANORTHOSITE), method_10426(PlanetBlocks.ANORTHOSITE))
                        .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600)));

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40638, PlanetItems.ANORTHOSITE_SHOVEL, 1)
                        .method_10439(" M ")
                        .method_10439(" S ")
                        .method_10439(" S ")
                        .method_10434('M', PlanetBlocks.ANORTHOSITE)
                        .method_10434('S', class_1802.field_8600)
                        .method_10429(method_32807(PlanetBlocks.ANORTHOSITE), method_10426(PlanetBlocks.ANORTHOSITE))
                        .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600)));

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40638, PlanetItems.ANORTHOSITE_HOE, 1)
                        .method_10439(" MM")
                        .method_10439(" S ")
                        .method_10439(" S ")
                        .method_10434('M', PlanetBlocks.ANORTHOSITE)
                        .method_10434('S', class_1802.field_8600)
                        .method_10429(method_32807(PlanetBlocks.ANORTHOSITE), method_10426(PlanetBlocks.ANORTHOSITE))
                        .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600)));

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40638, PlanetItems.ANORTHOSITE_AXE, 1)
                        .method_10439(" MM")
                        .method_10439(" SM")
                        .method_10439(" S ")
                        .method_10434('M', PlanetBlocks.ANORTHOSITE)
                        .method_10434('S', class_1802.field_8600)
                        .method_10429(method_32807(PlanetBlocks.ANORTHOSITE), method_10426(PlanetBlocks.ANORTHOSITE))
                        .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600)));

                // Martian Stone

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_STONE_WALL, 1)
                        .method_10439("   ")
                        .method_10439("SSS")
                        .method_10439("SSS")
                        .method_10434('S', PlanetBlocks.MARTIAN_STONE)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_STONE), method_10426(PlanetBlocks.MARTIAN_STONE)));

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_STONE_STAIRS, 1)
                        .method_10439("S  ")
                        .method_10439("SS ")
                        .method_10439("SSS")
                        .method_10434('S', PlanetBlocks.MARTIAN_STONE)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_STONE), method_10426(PlanetBlocks.MARTIAN_STONE)));

                provider.addShapedRecipe(class_2447.method_10436(class_7800.field_40634, PlanetBlocks.MARTIAN_STONE_SLAB, 1)
                        .method_10439("   ")
                        .method_10439("   ")
                        .method_10439("SSS")
                        .method_10434('S', PlanetBlocks.MARTIAN_STONE)
                        .method_10429(method_32807(PlanetBlocks.MARTIAN_STONE), method_10426(PlanetBlocks.MARTIAN_STONE)));



            }


            @Override
            public void blockTags(AITBlockTagProvider provider) {
                // Martian Blocks
                provider.method_10512(class_3481.field_15504)
                        .add(PlanetBlocks.MARTIAN_BRICK_WALL).add(PlanetBlocks.MARTIAN_COBBLESTONE_WALL).add(PlanetBlocks.MARTIAN_SANDSTONE_WALL).add(PlanetBlocks.MARTIAN_STONE_WALL).add(PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE_WALL).add(PlanetBlocks.MARTIAN_BRICK_WALL).add(PlanetBlocks.MARTIAN_SANDSTONE_BRICK_WALL);

                // Anorthosite Blocks
                provider.method_10512(class_3481.field_15504)
                        .add(PlanetBlocks.ANORTHOSITE_BRICK_WALL).add(PlanetBlocks.ANORTHOSITE_WALL).add(PlanetBlocks.MOON_SANDSTONE_BRICK_WALL).add(PlanetBlocks.MOON_SANDSTONE_WALL);

            }

            @Override
            public void itemTags(AITItemTagProvider provider) {
                provider.method_10512(class_3489.field_41890).add(PlanetItems.SPACESUIT_BOOTS).add(PlanetItems.SPACESUIT_LEGGINGS).add(PlanetItems.SPACESUIT_CHESTPLATE).add(PlanetItems.SPACESUIT_HELMET);
            }


            @Override
            public void generateItemModels(AmbleModelProvider provider, class_4915 generator) {
                generator.method_48523((class_1738) PlanetItems.SPACESUIT_BOOTS);
                generator.method_48523((class_1738) PlanetItems.SPACESUIT_CHESTPLATE);
                generator.method_48523((class_1738) PlanetItems.SPACESUIT_LEGGINGS);
                generator.method_48523((class_1738) PlanetItems.SPACESUIT_HELMET);

                generator.method_25733(PlanetItems.MARTIAN_STONE_SWORD, class_4943.field_22939);
                generator.method_25733(PlanetItems.MARTIAN_STONE_SHOVEL, class_4943.field_22939);
                generator.method_25733(PlanetItems.MARTIAN_STONE_PICKAXE, class_4943.field_22939);
                generator.method_25733(PlanetItems.MARTIAN_STONE_HOE, class_4943.field_22939);
                generator.method_25733(PlanetItems.MARTIAN_STONE_AXE, class_4943.field_22939);

                generator.method_25733(PlanetItems.ANORTHOSITE_SWORD, class_4943.field_22939);
                generator.method_25733(PlanetItems.ANORTHOSITE_SHOVEL, class_4943.field_22939);
                generator.method_25733(PlanetItems.ANORTHOSITE_PICKAXE, class_4943.field_22939);
                generator.method_25733(PlanetItems.ANORTHOSITE_HOE, class_4943.field_22939);
                generator.method_25733(PlanetItems.ANORTHOSITE_AXE, class_4943.field_22939);
            }

            @Override
            public void models(AmbleModelProvider provider, class_4910 generator) {
                //Martian (Slabs, Walls, etc.)
                class_4910.class_4912 martian_stone_pool = generator.method_25650(PlanetBlocks.MARTIAN_STONE);
                martian_stone_pool.method_25725(PlanetBlocks.MARTIAN_STONE_STAIRS);
                martian_stone_pool.method_25720(PlanetBlocks.MARTIAN_STONE_WALL);
                martian_stone_pool.method_25724(PlanetBlocks.MARTIAN_STONE_SLAB);
                martian_stone_pool.method_25716(PlanetBlocks.MARTIAN_STONE_BUTTON);
                martian_stone_pool.method_25723(PlanetBlocks.MARTIAN_STONE_PRESSURE_PLATE);

                class_4910.class_4912 martian_bricks_pool = generator.method_25650(PlanetBlocks.MARTIAN_BRICKS);
                martian_bricks_pool.method_25725(PlanetBlocks.MARTIAN_BRICK_STAIRS);
                martian_bricks_pool.method_25720(PlanetBlocks.MARTIAN_BRICK_WALL);
                martian_bricks_pool.method_25724(PlanetBlocks.MARTIAN_BRICK_SLAB);

                class_4910.class_4912 martian_cobblestone_pool = generator.method_25650(PlanetBlocks.MARTIAN_COBBLESTONE);
                martian_cobblestone_pool.method_25725(PlanetBlocks.MARTIAN_COBBLESTONE_STAIRS);
                martian_cobblestone_pool.method_25720(PlanetBlocks.MARTIAN_COBBLESTONE_WALL);
                martian_cobblestone_pool.method_25724(PlanetBlocks.MARTIAN_COBBLESTONE_SLAB);


                class_4910.class_4912 mossy_martian_cobblestone_pool = generator.method_25650(PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE);
                mossy_martian_cobblestone_pool.method_25725(PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE_STAIRS);
                mossy_martian_cobblestone_pool.method_25720(PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE_WALL);
                mossy_martian_cobblestone_pool.method_25724(PlanetBlocks.MOSSY_MARTIAN_COBBLESTONE_SLAB);

                class_4910.class_4912 martian_sandstone_pool = generator.method_25650(PlanetBlocks.MARTIAN_SANDSTONE);
                martian_sandstone_pool.method_25725(PlanetBlocks.MARTIAN_SANDSTONE_STAIRS);
                martian_sandstone_pool.method_25720(PlanetBlocks.MARTIAN_SANDSTONE_WALL);
                martian_sandstone_pool.method_25724(PlanetBlocks.MARTIAN_SANDSTONE_SLAB);

                class_4910.class_4912 martian_sandstone_bricks_pool = generator.method_25650(PlanetBlocks.MARTIAN_SANDSTONE_BRICKS);
                martian_sandstone_bricks_pool.method_25725(PlanetBlocks.MARTIAN_SANDSTONE_BRICK_STAIRS);
                martian_sandstone_bricks_pool.method_25720(PlanetBlocks.MARTIAN_SANDSTONE_BRICK_WALL);
                martian_sandstone_bricks_pool.method_25724(PlanetBlocks.MARTIAN_SANDSTONE_BRICK_SLAB);

                class_4910.class_4912 smooth_martian_stone_pool = generator.method_25650(PlanetBlocks.SMOOTH_MARTIAN_STONE);
                smooth_martian_stone_pool.method_25724(PlanetBlocks.SMOOTH_MARTIAN_STONE_SLAB);

                class_4910.class_4912 polished_martian_stone_pool = generator.method_25650(PlanetBlocks.POLISHED_MARTIAN_STONE);
                polished_martian_stone_pool.method_25725(PlanetBlocks.POLISHED_MARTIAN_STONE_STAIRS);
                polished_martian_stone_pool.method_25724(PlanetBlocks.POLISHED_MARTIAN_STONE_SLAB);


                //Anorthosite (Slabs, Walls, etc.)

                class_4910.class_4912 anorthosite_pool = generator.method_25650(PlanetBlocks.ANORTHOSITE);
                anorthosite_pool.method_25725(PlanetBlocks.ANORTHOSITE_STAIRS);
                anorthosite_pool.method_25720(PlanetBlocks.ANORTHOSITE_WALL);
                anorthosite_pool.method_25724(PlanetBlocks.ANORTHOSITE_SLAB);

                class_4910.class_4912 anorthosite_bricks_pool = generator.method_25650(PlanetBlocks.ANORTHOSITE_BRICKS);
                anorthosite_bricks_pool.method_25725(PlanetBlocks.ANORTHOSITE_BRICK_STAIRS);
                anorthosite_bricks_pool.method_25720(PlanetBlocks.ANORTHOSITE_BRICK_WALL);
                anorthosite_bricks_pool.method_25724(PlanetBlocks.ANORTHOSITE_BRICK_SLAB);

                class_4910.class_4912 smooth_anorthosite_stone_pool = generator.method_25650(PlanetBlocks.SMOOTH_ANORTHOSITE);
                smooth_anorthosite_stone_pool.method_25724(PlanetBlocks.SMOOTH_ANORTHOSITE_SLAB);

                class_4910.class_4912 polished_anorthosite_stone_pool = generator.method_25650(PlanetBlocks.POLISHED_ANORTHOSITE);
                polished_anorthosite_stone_pool.method_25725(PlanetBlocks.POLISHED_ANORTHOSITE_STAIRS);
                polished_anorthosite_stone_pool.method_25724(PlanetBlocks.POLISHED_ANORTHOSITE_SLAB);

                class_4910.class_4912 moon_sandstone_pool = generator.method_25650(PlanetBlocks.MOON_SANDSTONE);
                moon_sandstone_pool.method_25725(PlanetBlocks.MOON_SANDSTONE_STAIRS);
                moon_sandstone_pool.method_25720(PlanetBlocks.MOON_SANDSTONE_WALL);
                moon_sandstone_pool.method_25724(PlanetBlocks.MOON_SANDSTONE_SLAB);

                class_4910.class_4912 moon_sandstone_bricks_pool = generator.method_25650(PlanetBlocks.MOON_SANDSTONE_BRICKS);
                moon_sandstone_bricks_pool.method_25725(PlanetBlocks.MOON_SANDSTONE_BRICK_STAIRS);
                moon_sandstone_bricks_pool.method_25720(PlanetBlocks.MOON_SANDSTONE_BRICK_WALL);
                moon_sandstone_bricks_pool.method_25724(PlanetBlocks.MOON_SANDSTONE_BRICK_SLAB);
            }

            @Override
            public void advancements(Consumer<class_161> consumer) {
                class_161 root = class_161.class_162.method_707()
                        .method_697(
                                PlanetItems.SPACESUIT_HELMET,
                                class_2561.method_43471("achievements.ait.title.planet_root"),
                                class_2561.method_43471("achievements.ait.description.planet_root"),
                                AITMod.id("textures/block/martian_stone.png"),
                                class_189.field_1254,
                                false,
                                false,
                                false
                        )
                        .method_709("enter_tardis", TardisCriterions.ENTER_TARDIS.conditions())
                        .method_694(consumer, AITMod.MOD_ID + "/planet_root");
                class_161 landOnMars = class_161.class_162.method_707()
                        .method_701(root)
                        .method_697(
                                PlanetBlocks.MARTIAN_STONE,
                                class_2561.method_43471("achievements.ait.title.enter_mars"),
                                class_2561.method_43471("achievements.ait.description.enter_mars"),
                                null,
                                class_189.field_1254,
                                true,
                                true,
                                true
                        )
                        .method_709(
                                "enter_mars",
                                class_1999.class_2001.method_8799(
                                        class_5321.method_29179(
                                                class_7924.field_41223,
                                                AITMod.id("mars")
                                        )
                                )
                        )
                        .method_694(consumer, AITMod.MOD_ID + "/enter_mars");
                class_161 landOnMoon = class_161.class_162.method_707()
                        .method_701(root)
                        .method_697(
                                PlanetBlocks.ANORTHOSITE,
                                class_2561.method_43471("achievements.ait.title.enter_moon"),
                                class_2561.method_43471("achievements.ait.description.enter_moon"),
                                null,
                                class_189.field_1254,
                                true,
                                true,
                                true
                        )
                        .method_709(
                                "enter_moon",
                                class_1999.class_2001.method_8799(
                                        class_5321.method_29179(
                                                class_7924.field_41223,
                                                AITMod.id("moon")
                                        )
                                )
                        )
                        .method_694(consumer, AITMod.MOD_ID + "/enter_moon");

                // todo - idk how to do this
                // Advancement findStructure = Advancement.Builder.create().parent(root).display(Blocks.REDSTONE_BLOCK, Text.translatable("advancements.ait.find_planet_structure.title"), Text.translatable("advancements.ait.find_planet_structure.description"), null, AdvancementFrame.CHALLENGE, true, true, true).criterion("planet_structure", TickCriterion.Conditions.createLocation(LocationPredicate.feature(RegistryKey.of(RegistryKeys.STRUCTURE, AITMod.id("cult_structures_overworld"))))).build(consumer, AITMod.MOD_ID + "/find_planet_structure");
            }
        });
    }

    public static PlanetModule instance() {
        return INSTANCE;
    }
}
