package dev.amble.ait.module.planet.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_758;
import net.minecraft.class_7833;
import net.minecraft.class_8251;
import net.minecraft.client.render.*;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.renderers.AITRenderLayers;
import dev.amble.ait.module.planet.client.models.CelestialBodyModel;


public class CelestialBodyRenderer {

    public static void renderFarAwayBody(class_243 targetPosition, Vector3f scale, class_2960 texture, boolean hasClouds, boolean hasAtmosphere, Vector3f atmosphereColor) {
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_4597.class_4598 provider = mc.method_22940().method_23000();

        class_243 cameraPos = camera.method_19326();

        class_243 targetPos = new class_243(camera.method_19326().method_10216() + targetPosition.method_10216(),
                camera.method_19326().method_10214() + targetPosition.method_10214(),
                camera.method_19326().method_10215() + targetPosition.method_10215());

        class_243 diff = targetPos.method_1020(cameraPos);

        class_4587 matrixStack = new class_4587();
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0F));
        matrixStack.method_22904(diff.field_1352, diff.field_1351, diff.field_1350);
        matrixStack.method_22905(scale.x, scale.y, scale.z);

        class_758.method_23792();
        //RenderSystem.depthFunc(GL11.GL_NOTEQUAL);
        RenderSystem.setProjectionMatrix(matrixStack.method_23760().method_23761().perspective(90, 1, 0.05f, 10000000), class_8251.field_43361);

        CelestialBodyModel.getTexturedModelData().method_32109().method_22699(matrixStack,
                provider.getBuffer(AITRenderLayers.method_23592(texture, false)),
                0xf000f0, class_4608.field_21444, 1, 1, 1, 1f);
        provider.method_22993();

        if (hasAtmosphere) {
            atmosphereRenderer(matrixStack, atmosphereColor, provider, false, hasClouds);
            provider.method_22993();
        }
        provider.method_22993();
        RenderSystem.restoreProjectionMatrix();
        //RenderSystem.depthFunc(GL11.GL_EQUAL);
    }

    public static void renderStarBody(boolean isTardisSkybox, class_243 targetPosition, Vector3f scale, Vector3f rotation, class_2960 texture, boolean hasAtmosphere, Vector3f atmosphereColor) {
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_4597.class_4598 provider = mc.method_22940().method_23000();

        class_243 cameraPos = camera.method_19326();

        class_243 targetPos = new class_243(targetPosition.method_10216(),targetPosition.method_10214(),targetPosition.method_10215());

        class_243 diff = targetPos.method_1020(cameraPos);

        class_4587 matrixStack = new class_4587();

        if (mc.field_1687 == null)
            return;

        matrixStack.method_22903();

        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0F));
        if (isTardisSkybox) {
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(mc.field_1687.method_30274(mc.method_1488()) * 360.0f));
            matrixStack.method_46416(0, -4000, 0);
            matrixStack.method_22905(0.25f, 0.25f, 0.25f);
        }
        matrixStack.method_22904(diff.field_1352, diff.field_1351, diff.field_1350);
        matrixStack.method_22905(scale.x, scale.y, scale.z);

        class_758.method_23792();


        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotation.y()));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(rotation.x()));
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(rotation.z()));

        CelestialBodyModel model = new CelestialBodyModel(CelestialBodyModel.getTexturedModelData().method_32109());

        RenderSystem.depthMask(true);

        //RenderSystem.setShaderColor(atmosphereColor.x + 0.25f, atmosphereColor.y + 0.25f, atmosphereColor.z + 0.25f, 1f);
        model.method_2828(matrixStack,
                provider.getBuffer(AITRenderLayers.method_23592(texture, false)),
                0xf000f00, class_4608.field_21444, 1 - atmosphereColor.x, 1 - atmosphereColor.y, 1 - atmosphereColor.z, 1f);
        provider.method_22993();
        //RenderSystem.setShaderColor(1f, 1f, 1f, 1f);

        if (hasAtmosphere) {
            atmosphereRenderer(matrixStack, atmosphereColor, provider, true,false);
            provider.method_22993();
        }
        //RenderSystem.depthFunc(GL11.GL_EQUAL);
        matrixStack.method_22909();
    }

    public static void renderComprehendableBody(boolean isTardisSkybox, class_243 targetPosition, Vector3f scale, Vector3f rotation, class_2960 texture, boolean isSkyRendered, boolean hasClouds, boolean hasAtmosphere, Vector3f atmosphereColor, boolean hasRings) {
        renderComprehendableBody(0, isTardisSkybox, targetPosition, scale, rotation, texture, isSkyRendered, hasClouds, hasAtmosphere, atmosphereColor, hasRings);
    }

    public static void renderComprehendableBody(float skyboxRot, boolean isTardisSkybox, class_243 targetPosition, Vector3f scale, Vector3f rotation, class_2960 texture, boolean isSkyRendered, boolean hasClouds, boolean hasAtmosphere, Vector3f atmosphereColor, boolean hasRings) {
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_4597.class_4598 provider = mc.method_22940().method_23000();

        class_243 cameraPos = camera.method_19326();

        class_243 targetPos = new class_243(targetPosition.method_10216(),targetPosition.method_10214(),targetPosition.method_10215());

        class_243 diff = targetPos.method_1020(cameraPos);

        class_4587 matrixStack = new class_4587();
        matrixStack.method_22903();
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0F + skyboxRot));
        if (isTardisSkybox) {
            matrixStack.method_46416(0, 4000, 0);
            matrixStack.method_22905(0.25f, 0.25f, 0.25f);
        }
        matrixStack.method_22904(diff.field_1352, diff.field_1351, diff.field_1350);
        matrixStack.method_22905(scale.x, scale.y, scale.z);

        class_758.method_23792();
        //RenderSystem.depthMask(true);
        if (isSkyRendered) {
            RenderSystem.depthMask(true);
            GL11.glEnable(GL11.GL_DEPTH_TEST);
            GL11.glDepthFunc(GL11.GL_ALWAYS);
        }

        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotation.y()));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(180 + rotation.x()));
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(rotation.z()));

        CelestialBodyModel celestialBodyModel = new CelestialBodyModel(CelestialBodyModel.getTexturedModelData().method_32109());
        celestialBodyModel.method_2828(matrixStack,
                provider.getBuffer(AITRenderLayers.method_23588(texture)),
                0xf000f0, class_4608.field_21444, 1, 1, 1, 1f);
        if (hasRings) {
            celestialBodyModel.ring.method_22699(matrixStack,
                    provider.getBuffer(AITRenderLayers.method_23588(texture)),
                    0xf000f0, class_4608.field_21444, 1, 1, 1, 1f);
        }
        provider.method_22993();

        if (hasAtmosphere) {
            atmosphereRenderer(matrixStack, atmosphereColor, provider, false, hasClouds);
            provider.method_22993();
        }

        if (isSkyRendered) {
            RenderSystem.depthMask(false);
            GL11.glDepthFunc(GL11.GL_EQUAL);
            GL11.glDisable(GL11.GL_DEPTH_TEST);
        }
        matrixStack.method_22909();
    }

    public static void atmosphereRenderer(class_4587 matrixStack, Vector3f color, class_4597.class_4598 provider, boolean isStar, boolean hasClouds) {
        CelestialBodyModel model = new CelestialBodyModel(CelestialBodyModel.getTexturedModelData().method_32109());
        for (int i = 0; i < 6; i++) {
            float alpha = (float) (0.1f - Math.log(i + 1) * 0.001f);
            matrixStack.method_22903();
            float gg = 1.0f + ((i != 0 ? i : i + 1) * 0.025f);
            matrixStack.method_22905(gg, gg, gg);
            float delta = (class_310.method_1551().method_1488() + class_310.method_1551().field_1724.field_6012) * 0.00001f;
            class_1921 renderLayer = AITRenderLayers.method_29379(new class_2960("textures/environment/clouds.png"));//RenderLayer.getEnergySwirl(new Identifier("textures/environment/clouds.png"), delta % 1.0F, (delta * 0.1F) % 1.0F);
            class_2960 texture = AITMod.id("textures/environment/atmosphere.png");
            if (i != 1) {
                //System.out.println("min" + (Math.min(color.z + (0.05f * i + i), 1.0f)));
                model.method_2828(matrixStack,
                        provider.getBuffer(isStar && (i == 2 || i == 3 || i == 4) ?
                                AITRenderLayers.method_23026(texture) : AITRenderLayers.method_29379(texture)),
                        15728864, class_4608.field_21444,  1 + Math.min(color.x + (0.015f * i), 5.0f), 1 + Math.min(color.y + (0.015f * i), 5.0f), 1 + Math.min(color.z + (0.015f * i), 5.0f), -1 + alpha);
            } else if (hasClouds) {
                model.method_2828(matrixStack,
                        provider.getBuffer(renderLayer),
                        15728864, class_4608.field_21444, 1, 1, 1, 1F);
                matrixStack.method_22905(1.01f, 1.01f, 1.01f);
                model.method_2828(matrixStack,
                        provider.getBuffer(renderLayer),
                        15728864, class_4608.field_21444, 1, 1, 1, 1F);
            }
            matrixStack.method_22909();
        }
    }
}
