package dev.amble.ait.module.planet.client.renderers.wearables;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3881;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_742;
import dev.amble.ait.AITMod;
import dev.amble.ait.module.planet.client.models.wearables.SpacesuitModel;
import dev.amble.ait.module.planet.core.item.SpacesuitItem;

@Environment(value = EnvType.CLIENT)
public class SpacesuitFeatureRenderer<T extends class_1309, M extends class_583<T> & class_3881>
        extends
            class_3887<T, M> {

    public static final class_2960 BLANK_SPACESUIT = AITMod.id(
            "textures/entity/wearables/spacesuit/nasa/blank_spacesuit.png");
    private final SpacesuitModel model;

    public SpacesuitFeatureRenderer(class_3883<T, M> context, class_5599 loader) {
        super(context);
        this.model = new SpacesuitModel(SpacesuitModel.getTexturedModelData().method_32109());
    }

    @Override
    public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, T livingEntity,
                       float f, float g, float h, float j, float k, float l) {

        if (!(livingEntity instanceof class_742 || livingEntity instanceof class_1531))
            return;

        matrixStack.method_22903();
        matrixStack.method_46416(0, -1.5f, 0);

        // god bless america
        for (BodyParts part : BodyParts.values()) {
            class_1799 stack = getModelForSlot(livingEntity, part);
            if (stack.method_7909() instanceof SpacesuitItem) {
                enablePart(model, part);
            } else {
                disablePart(model, part);
            }
        }

        this.model.Head.method_17138(((class_572) method_17165()).field_3398);
        this.model.Body.method_17138(((class_572) method_17165()).field_3391);
        this.model.LeftArm.method_17138(((class_572) method_17165()).field_27433);
        this.model.RightArm.method_17138(((class_572) method_17165()).field_3401);
        this.model.LeftLeg.method_17138(((class_572) method_17165()).field_3397);
        this.model.RightLeg.method_17138(((class_572) method_17165()).field_3392);
        this.model.setAngles(livingEntity, f, g, j, k, l);

        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_28116(BLANK_SPACESUIT));
        this.model.method_2828(matrixStack, vertexConsumer, i, class_4608.field_21444, 1, 1, 1, 1f);

        matrixStack.method_22909();
    }

    public static void enablePart(SpacesuitModel model, BodyParts part) {
        switch (part) {
            case HEAD:
                model.Head.field_3665 = true;
                break;
            case CHEST:
                model.Body.field_3665 = true;
                model.LeftArm.field_3665 = true;
                model.RightArm.field_3665 = true;
                break;
            case LEGS:
                model.LeftLeg.method_32086("left_leg_pant").field_3665 = true;
                model.RightLeg.method_32086("right_leg_pant").field_3665 = true;

                break;
            case FEET:
                model.LeftFoot.field_3665 = true;
                model.RightFoot.field_3665 = true;
                break;
        }
    }

    public static void disablePart(SpacesuitModel model, BodyParts part) {
        switch (part) {
            case HEAD:
                model.Head.field_3665 = false;
                break;
            case CHEST:
                model.Body.field_3665 = false;
                model.LeftArm.field_3665 = false;
                model.RightArm.field_3665 = false;
                break;
            case LEGS:
                model.LeftLeg.method_32086("left_leg_pant").field_3665 = false;
                model.RightLeg.method_32086("right_leg_pant").field_3665 = false;
                break;
            case FEET:
                model.LeftFoot.field_3665 = false;
                model.RightFoot.field_3665 = false;
                break;
        }
    }

    public static class_1799 getModelForSlot(class_1309 entity, BodyParts parts) {
        return switch(parts) {
            default -> entity.method_6118(class_1304.field_6169);
            case CHEST -> entity.method_6118(class_1304.field_6174);
            case LEGS -> entity.method_6118(class_1304.field_6172);
            case FEET -> entity.method_6118(class_1304.field_6166);
        };
    }


    public enum BodyParts {
        HEAD,
        CHEST,
        LEGS,
        FEET
    }
}
