package dev.amble.ait.module.planet.core.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_5134;
import net.minecraft.class_5150;
import net.minecraft.item.*;
import dev.amble.ait.core.AITStatusEffects;

public class AnorthositeSwordItem extends class_1831 implements class_5150 {
    private final float attackDamage;
    private final Multimap<class_1320, class_1322> attributeModifiers;

    public AnorthositeSwordItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, settings);
        this.attackDamage = (float)attackDamage + toolMaterial.method_8028();
        ImmutableMultimap.Builder<class_1320, class_1322> builder = ImmutableMultimap.builder();
        builder.put(class_5134.field_23721, new class_1322(field_8006, "Weapon modifier", (double)this.attackDamage, class_1322.class_1323.field_6328));
        builder.put(class_5134.field_23723, new class_1322(field_8001, "Weapon modifier", (double)attackSpeed, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    @Override
    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return !miner.method_7337();
    }

    @Override
    public float method_7865(class_1799 stack, class_2680 state) {
        if (state.method_27852(class_2246.field_10343)) {
            return 15.0f;
        }
        return state.method_26164(class_3481.field_44469) ? 1.5f : 1.0f;
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        stack.method_7956(1, attacker, e -> e.method_20235(class_1304.field_6173));
        target.method_6092(new class_1293(AITStatusEffects.LUNAR_SICKNESS, 200, 1));
        return true;
    }

    @Override
    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (state.method_26214(world, pos) != 0.0f) {
            stack.method_7956(2, miner, e -> e.method_20235(class_1304.field_6173));
        }
        return true;
    }

    @Override
    public boolean method_7856(class_2680 state) {
        return state.method_27852(class_2246.field_10343);
    }

    @Override
    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        if (slot == class_1304.field_6173) {
            return this.attributeModifiers;
        }
        return super.method_7844(slot);
    }
}
