package dev.amble.ait.module.planet.core.space.planet;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_7924;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.lib.api.Identifiable;
import dev.amble.lib.util.ServerLifecycleHooks;
import dev.amble.ait.AITMod;
import dev.amble.ait.module.planet.core.item.SpacesuitItem;

public record Planet(class_2960 dimension, float gravity, boolean hasOxygen, boolean hasLandableSurface, int temperature,
                     PlanetRenderInfo render, PlanetTransition transition) implements Identifiable {
    public static final Codec<Planet> CODEC = class_5699.method_42114(RecordCodecBuilder.create(instance -> instance.group(
            class_2960.field_25139.fieldOf("dimension").forGetter(Planet::dimension),
            Codec.FLOAT.optionalFieldOf("gravity", -1f).forGetter(Planet::gravity),
            Codec.BOOL.fieldOf("has_oxygen").forGetter(Planet::hasOxygen),
            Codec.BOOL.fieldOf("has_landable_surface").forGetter(Planet::hasLandableSurface),
            Codec.INT.optionalFieldOf("temperature", 288).forGetter(Planet::temperature),
            PlanetRenderInfo.CODEC.optionalFieldOf("render", PlanetRenderInfo.EMPTY).forGetter(Planet::render),
            PlanetTransition.CODEC.optionalFieldOf("transition", PlanetTransition.EMPTY).forGetter(Planet::transition)
    ).apply(instance, Planet::new)));

    public static boolean hasFullSuit(class_1309 entity) {
        return entity.method_6118(class_1304.field_6169).method_7909() instanceof SpacesuitItem
                && entity.method_6118(class_1304.field_6174).method_7909() instanceof SpacesuitItem
                && entity.method_6118(class_1304.field_6172).method_7909() instanceof SpacesuitItem
                && entity.method_6118(class_1304.field_6166).method_7909() instanceof SpacesuitItem;
    }

    public static double getOxygenInTank(class_1309 entity) {
        class_1799 chestplate = entity.method_6118(class_1304.field_6174);
        if (chestplate.method_7909() instanceof SpacesuitItem) {
            return chestplate.method_7948().method_10574(SpacesuitItem.OXYGEN_KEY);
        }
        return 0.0D;
    }

    public static boolean hasOxygenInTank(class_1309 entity) {
        return Planet.getOxygenInTank(entity) > 0.0D;
    }

    public static Planet fromInputStream(InputStream stream) {
        return fromJson(JsonParser.parseReader(new InputStreamReader(stream)).getAsJsonObject());
    }

    public static Planet fromJson(JsonObject json) {
        AtomicReference<Planet> created = new AtomicReference<>();

        CODEC.decode(JsonOps.INSTANCE, json).get().ifLeft(planet -> created.set(planet.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack planet: {}", err);
        });

        return created.get();
    }

    @Override
    public class_2960 id() {
        return this.dimension();
    }

    // Use Celsius since it's more accurate in terms of water temperature
    public float celsius() {
        return this.temperature() - 273.15f;
    }

    // Temperature is in Kelvin because SCIENCE BITCH
    public float kelvin() {
        return this.temperature();
    }

    // Celsius -> Fahrenheit conversion isn't always the most accurate but oh well cope harder I guess
    public float fahrenheit() {
        return celsius() * 1.8f + 32f;
    }

    public boolean isFreezing() {
        return this.celsius() <= 0;
    }

    public boolean zeroGravity() {
        return this.gravity() == 0.8f; // exploding head emoji
    }

    public boolean hasGravityModifier() {
        return this.gravity() >= 0;
    }

    public boolean hasNoFallDamage() {
        return this.hasGravityModifier() && this.gravity() < 1 && this.gravity() != 0;
    }

    public class_3218 toWorld() {
        return ServerLifecycleHooks.get().method_3847(class_5321.method_29179(class_7924.field_41223, this.dimension));
    }

    public Planet with(class_2960 dimension) {
        return new Planet(dimension, this.gravity, this.hasOxygen, this.hasLandableSurface, this.temperature, this.render, this.transition);
    }
}
