package dev.amble.ait.module.planet.core.space.planet;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.lib.util.ServerLifecycleHooks;
import dev.amble.lib.util.TeleportUtil;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import dev.amble.ait.core.AITDimensions;

/**
 * Represents a transition between two planets.
 * @param target the planet to be teleported to
 * @param height the height at which the player should be teleported
 */
public record PlanetTransition(class_2960 target, int height) {
    public static final Codec<PlanetTransition> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_2960.field_25139.fieldOf("target").forGetter(PlanetTransition::target),
            Codec.INT.fieldOf("height").forGetter(PlanetTransition::height)
    ).apply(instance, PlanetTransition::new));

    public class_3218 getTargetWorld() {
        return ServerLifecycleHooks.get().method_3847(class_5321.method_29179(class_7924.field_41223, target));
    }

    /**
     * Teleports the entity to the target planet.
     * @param entity the entity to be teleported
     * @return true if the entity was teleported, false otherwise
     */
    public boolean run(class_1309 entity) {
        if (this.isEmpty()) return false;

        // check if is to space
        if (target.equals(AITDimensions.SPACE.method_29177())) {
            // teleport to that planets position in space
            Planet planet = PlanetRegistry.getInstance().get(entity.method_37908());
            if (planet == null || planet.render().isEmpty()) {
                return false;
            }

            //if (entity.hasVehicle())
            //    if (entity.getVehicle() instanceof FlightTardisEntity)
            //        FabricDimensions.teleport(entity.getVehicle(), getTargetWorld(),
            //                new TeleportTarget(planet.render().position().add(0, height, 0),
            //                        entity.getVelocity(), entity.getBodyYaw(), entity.getPitch()));
            TeleportUtil.teleport(entity, getTargetWorld(), planet.render().position().method_1031(0, height, 0), entity.method_43078());
            return true;
        }

        //if (entity.hasVehicle())
        //    if (entity.getVehicle() instanceof FlightTardisEntity)
        //        FabricDimensions.teleport(entity.getVehicle(), getTargetWorld(),
        //                new TeleportTarget(new Vec3d(entity.getX(), height, entity.getZ()),
        //                        entity.getVelocity(), entity.getBodyYaw(), entity.getPitch()));
        TeleportUtil.teleport(entity, getTargetWorld(), new class_243(entity.method_23317(), height, entity.method_23321()), entity.method_43078()); // height might not be the right place to teleport here, im not sure.
        return true;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }
    public static final PlanetTransition EMPTY = new PlanetTransition(new class_2960("empty"), 0);
    public static PlanetTransition toSpace(int height) {
        return new PlanetTransition(AITDimensions.SPACE.method_29177(), height);
    }
}
