package dev.amble.ait.module.planet.core.world;

import java.util.List;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3124;
import net.minecraft.class_3819;
import net.minecraft.class_3825;
import net.minecraft.class_5321;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import dev.amble.ait.AITMod;
import dev.amble.ait.module.planet.core.PlanetBlocks;

public class PlanetConfiguredFeatures {
   public static final class_5321<class_2975<?, ?>> MARTIAN_COAL_ORE = registryKey("martian_coal_ore");
   public static final class_5321<class_2975<?, ?>> MARTIAN_COPPER_ORE = registryKey("martian_copper_ore");
   public static final class_5321<class_2975<?, ?>> MARTIAN_IRON_ORE = registryKey("martian_iron_ore");
   public static final class_5321<class_2975<?, ?>> MARTIAN_GOLD_ORE = registryKey("martian_gold_ore");
   public static final class_5321<class_2975<?, ?>> MARTIAN_REDSTONE_ORE = registryKey("martian_redstone_ore");
   public static final class_5321<class_2975<?, ?>> MARTIAN_LAPIS_ORE = registryKey("martian_lapis_ore");
   public static final class_5321<class_2975<?, ?>> MARTIAN_DIAMOND_ORE = registryKey("martian_diamond_ore");
   public static final class_5321<class_2975<?, ?>> MARTIAN_EMERALD_ORE = registryKey("martian_emerald_ore");

    public static final class_5321<class_2975<?, ?>> ANORTHOSITE_COAL_ORE = registryKey("anorthosite_coal_ore");
    public static final class_5321<class_2975<?, ?>> ANORTHOSITE_COPPER_ORE = registryKey("anorthosite_copper_ore");
    public static final class_5321<class_2975<?, ?>> ANORTHOSITE_IRON_ORE = registryKey("anorthosite_iron_ore");
    public static final class_5321<class_2975<?, ?>> ANORTHOSITE_GOLD_ORE = registryKey("anorthosite_gold_ore");
    public static final class_5321<class_2975<?, ?>> ANORTHOSITE_REDSTONE_ORE = registryKey("anorthosite_redstone_ore");
    public static final class_5321<class_2975<?, ?>> ANORTHOSITE_LAPIS_ORE = registryKey("anorthosite_lapis_ore");
    public static final class_5321<class_2975<?, ?>> ANORTHOSITE_DIAMOND_ORE = registryKey("anorthosite_diamond_ore");
    public static final class_5321<class_2975<?, ?>> ANORTHOSITE_EMERALD_ORE = registryKey("anorthosite_emerald_ore");

   public static void bootstrap(class_7891<class_2975<?, ?>> context) {
       class_3825 martianStoneReplaceables = new class_3819(PlanetBlocks.MARTIAN_STONE);
       class_3825 anorthositeReplaceables = new class_3819(PlanetBlocks.ANORTHOSITE);

       List<class_3124.class_5876> marsOres =
               List.of(class_3124.method_33994(martianStoneReplaceables, PlanetBlocks.MARTIAN_COAL_ORE.method_9564()),
                       class_3124.method_33994(martianStoneReplaceables, PlanetBlocks.MARTIAN_COPPER_ORE.method_9564()),
                       class_3124.method_33994(martianStoneReplaceables, PlanetBlocks.MARTIAN_IRON_ORE.method_9564()),
                       class_3124.method_33994(martianStoneReplaceables, PlanetBlocks.MARTIAN_GOLD_ORE.method_9564()),
                       class_3124.method_33994(martianStoneReplaceables, PlanetBlocks.MARTIAN_REDSTONE_ORE.method_9564()),
                       class_3124.method_33994(martianStoneReplaceables, PlanetBlocks.MARTIAN_LAPIS_ORE.method_9564()),
                       class_3124.method_33994(martianStoneReplaceables, PlanetBlocks.MARTIAN_DIAMOND_ORE.method_9564()),
                       class_3124.method_33994(martianStoneReplaceables, PlanetBlocks.MARTIAN_EMERALD_ORE.method_9564()));


       List<class_3124.class_5876> anorthorsiteOres =
               List.of(class_3124.method_33994(anorthositeReplaceables, PlanetBlocks.ANORTHOSITE_COAL_ORE.method_9564()),
                       class_3124.method_33994(anorthositeReplaceables, PlanetBlocks.ANORTHOSITE_COPPER_ORE.method_9564()),
                       class_3124.method_33994(anorthositeReplaceables, PlanetBlocks.ANORTHOSITE_IRON_ORE.method_9564()),
                       class_3124.method_33994(anorthositeReplaceables, PlanetBlocks.ANORTHOSITE_GOLD_ORE.method_9564()),
                       class_3124.method_33994(anorthositeReplaceables, PlanetBlocks.ANORTHOSITE_REDSTONE_ORE.method_9564()),
                       class_3124.method_33994(anorthositeReplaceables, PlanetBlocks.ANORTHOSITE_LAPIS_ORE.method_9564()),
                       class_3124.method_33994(anorthositeReplaceables, PlanetBlocks.ANORTHOSITE_DIAMOND_ORE.method_9564()),
                       class_3124.method_33994(anorthositeReplaceables, PlanetBlocks.ANORTHOSITE_EMERALD_ORE.method_9564()));


       register(context, MARTIAN_COAL_ORE, class_3031.field_13517, new class_3124(marsOres, 12));
       register(context, MARTIAN_COPPER_ORE, class_3031.field_13517, new class_3124(marsOres, 10));
       register(context, MARTIAN_IRON_ORE, class_3031.field_13517, new class_3124(marsOres, 8));
       register(context, MARTIAN_GOLD_ORE, class_3031.field_13517, new class_3124(marsOres, 6));
       register(context, MARTIAN_REDSTONE_ORE, class_3031.field_13517, new class_3124(marsOres, 6));
       register(context, MARTIAN_LAPIS_ORE, class_3031.field_13517, new class_3124(marsOres, 4));
       register(context, MARTIAN_DIAMOND_ORE, class_3031.field_13517, new class_3124(marsOres, 3));
       register(context, MARTIAN_EMERALD_ORE, class_3031.field_13517, new class_3124(marsOres, 1));


       register(context, ANORTHOSITE_COAL_ORE, class_3031.field_13517, new class_3124(anorthorsiteOres, 12));
       register(context, ANORTHOSITE_COPPER_ORE, class_3031.field_13517, new class_3124(anorthorsiteOres, 10));
       register(context, ANORTHOSITE_IRON_ORE, class_3031.field_13517, new class_3124(anorthorsiteOres, 8));
       register(context, ANORTHOSITE_GOLD_ORE, class_3031.field_13517, new class_3124(anorthorsiteOres, 6));
       register(context, ANORTHOSITE_REDSTONE_ORE, class_3031.field_13517, new class_3124(anorthorsiteOres, 6));
       register(context, ANORTHOSITE_LAPIS_ORE, class_3031.field_13517, new class_3124(anorthorsiteOres, 4));
       register(context, ANORTHOSITE_DIAMOND_ORE, class_3031.field_13517, new class_3124(anorthorsiteOres, 3));
       register(context, ANORTHOSITE_EMERALD_ORE, class_3031.field_13517, new class_3124(anorthorsiteOres, 1));
   }

    public static class_5321<class_2975<?, ?>> registryKey(String name) {
        return class_5321.method_29179(class_7924.field_41239, AITMod.id(name));
    }

    private static <FC extends class_3037, F extends class_3031<FC>> void register(class_7891<class_2975<?, ?>> context,
                                                                                   class_5321<class_2975<?, ?>> key, F feature, FC configuration) {
        context.method_46838(key, new class_2975<>(feature, configuration));
    }


}
