package dev.amble.ait.module.planet.mixin;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import dev.amble.ait.core.AITDimensions;
import dev.amble.ait.module.planet.core.space.planet.Planet;
import dev.amble.ait.module.planet.core.space.planet.PlanetWorld;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;

@Mixin(class_1937.class)
public abstract class WorldMixin implements PlanetWorld {

    @Shadow public abstract class_5321<class_1937> getRegistryKey();

    @Unique private Planet planet;

    @Unique private boolean isAPlanet;

    @Override
    public boolean ait_planet$isAPlanet() {
        return isAPlanet;
    }

    @Override
    public @Nullable Planet ait_planet$getPlanet() {
        return planet;
    }

    @Override
    public void ait_planet$setPlanet(Planet planet) {
        this.planet = planet;
    }

    @Override
    public void ait_planet$setIsAPlanet(boolean isAPlanet) {
        this.isAPlanet = isAPlanet;
    }

    @Inject(method = "isInBuildLimit", at = @At("HEAD"), cancellable = true)
    private void ait$isInBuildLimit(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        class_1937 world = (class_1937) (Object) this;
        if (world.method_27983().equals(AITDimensions.SPACE)) {
            cir.setReturnValue(true);
        }
    }
}
