package dev.amble.ait.registry.impl;

import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_1799;
import dev.amble.lib.register.datapack.SimpleDatapackRegistry;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.util.StackUtil;
import dev.amble.ait.data.datapack.DatapackMachineRecipe;
import dev.amble.ait.data.schema.MachineRecipeSchema;

public class MachineRecipeRegistry extends SimpleDatapackRegistry<MachineRecipeSchema> {

    private static MachineRecipeRegistry INSTANCE;

    protected MachineRecipeRegistry() {
        super(DatapackMachineRecipe::fromInputStream, DatapackMachineRecipe.CODEC, "machine_recipe", false, AITMod.MOD_ID);
    }

    @Override
    public MachineRecipeSchema fallback() {
        return null;
    }

    @Override
    protected void defaults() {
    }

    public Optional<MachineRecipeSchema> findMatching(Collection<class_1799> set) {
        for (MachineRecipeSchema schema : REGISTRY.values()) {
            if (StackUtil.equals(set, schema.input()))
                return Optional.of(schema.copy());
        }

        return Optional.empty();
    }

    public Optional<MachineRecipeSchema> findMatching(class_1799 result) {
        for (MachineRecipeSchema schema : REGISTRY.values()) {
            if (class_1799.method_7984(schema.output(), result))
                return Optional.of(schema.copy());
        }

        return Optional.empty();
    }

    public static MachineRecipeRegistry getInstance() {
        if (INSTANCE == null) {
            AITMod.LOGGER.debug("MachineRecipeRegistry was not initialized, creating a new instance");
            INSTANCE = new MachineRecipeRegistry();
        }

        return INSTANCE;
    }
}
