package dev.amble.ait.registry.impl;

import java.util.ArrayList;
import java.util.List;

import dev.amble.lib.data.DirectedBlockPos;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1551;
import net.minecraft.class_1593;
import net.minecraft.class_1642;
import net.minecraft.class_1802;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.control.impl.*;
import dev.amble.ait.core.tardis.control.impl.pos.IncrementControl;
import dev.amble.ait.core.tardis.control.impl.pos.XControl;
import dev.amble.ait.core.tardis.control.impl.pos.YControl;
import dev.amble.ait.core.tardis.control.impl.pos.ZControl;
import dev.amble.ait.core.tardis.control.impl.waypoint.LoadWaypointControl;
import dev.amble.ait.core.tardis.control.sequences.Sequence;
import dev.amble.ait.core.util.WorldUtil;

public class SequenceRegistry {
    public static final class_2370<Sequence> REGISTRY = FabricRegistryBuilder
            .createSimple(class_5321.<Sequence>method_29180(AITMod.id("sequence")))
            .buildAndRegister();
    private static final class_5819 random = class_5819.method_43047();

    public static Sequence register(Sequence schema) {
        return class_2378.method_10230(REGISTRY, schema.id(), schema);
    }

    public static Sequence AVOID_DEBRIS;
    public static Sequence DIMENSIONAL_BREACH;
    public static Sequence ENERGY_DRAIN;
    public static Sequence DIMENSIONAL_DRIFT_X;
    public static Sequence DIMENSIONAL_DRIFT_Y;
    public static Sequence DIMENSIONAL_DRIFT_Z;
    // public static Sequence FORCED_MAT;
    public static Sequence CLOAK_TO_AVOID_VORTEX_TRAPPED_MOBS;
    public static Sequence ANTI_GRAVITY_ERROR;
    public static Sequence POWER_DRAIN_IMMINENT;
    public static Sequence SHIP_COMPUTER_OFFLINE;
    // public static Sequence VORTEX_COLLISION;
    public static Sequence DIRECTIONAL_ERROR;
    // public static Sequence RANDOM_LOCATION_IDENTIFIED;
    public static Sequence SPEED_UP_TO_AVOID_DRIFTING_OUT_OF_VORTEX;
    public static Sequence SLOW_DOWN_TO_AVOID_FLYING_OUT_OF_VORTEX;
    public static Sequence COURSE_CORRECT;
    public static Sequence GROUND_UNSTABLE;
    public static Sequence INCREMENT_SCALE_RECALCULATION_NECESSARY;
    public static Sequence SMALL_DEBRIS_FIELD;

    public static void init() {
        AVOID_DEBRIS = register(Sequence.Builder.create(AITMod.id("avoid_debris"),
                finishedTardis -> finishedTardis.travel().decreaseFlightTime(120), missedTardis -> {
                    missedTardis.removeFuel(-random.method_39332(45, 125));
                    missedTardis.door().openDoors();

                    List<class_1927> explosions = new ArrayList<>();
                    class_3218 world = missedTardis.asServer().world();

                    missedTardis.getDesktop().getConsolePos().forEach(console -> {
                        class_1927 explosion = world.method_46407(null, null, null,
                                console.method_46558(), 3f * 2, false, class_1937.class_7867.field_40889);

                        explosions.add(explosion);
                    });

                    for (class_3222 player : world.method_18456()) {
                        float xVel = AITMod.RANDOM.nextFloat(-2f, 3f);
                        float yVel = AITMod.RANDOM.nextFloat(-1f, 2f);
                        float zVel = AITMod.RANDOM.nextFloat(-2f, 3f);

                        player.method_18800(xVel * 2, yVel * 2, zVel * 2);

                        if (!explosions.isEmpty()) {
                            player.method_5643(world.method_48963().method_48807(explosions.get(0)), 0);
                        } else {
                            player.method_5643(WorldUtil.getOverworld().method_48963().method_48830(), 0);
                        }
                    }
                }, 100L, class_2561.method_43471("sequence.ait.avoid_debris").method_27695(class_124.field_1056, class_124.field_1054),
                new DirectionControl(), new RandomiserControl()));

        DIMENSIONAL_BREACH = register(
                Sequence.Builder.create(AITMod.id("dimensional_breach"), (finishedTardis -> {
                    finishedTardis.travel().decreaseFlightTime(60);
                }), (missedTardis -> {
                    missedTardis.door().openDoors();
                }), 80L, class_2561.method_43471("sequence.ait.dimensional_breach").method_27695(class_124.field_1056, class_124.field_1054),
                        new DimensionControl(), new DoorControl()));

        ENERGY_DRAIN = register(
                Sequence.Builder.create(AITMod.id("energy_drain"), (finishedTardis -> {
                    finishedTardis.travel().decreaseFlightTime(140);
                    finishedTardis.addFuel(random.method_39332(45, 125));
                }), (missedTardis -> missedTardis.removeFuel(random.method_39332(45, 125))), 80L,
                        class_2561.method_43471("sequence.ait.energy_drain").method_27695(class_124.field_1056, class_124.field_1054),
                        new RefuelerControl()));

        POWER_DRAIN_IMMINENT = register(
                Sequence.Builder.create(AITMod.id("power_drain_imminent"), (finishedTardis -> {
                    finishedTardis.travel().decreaseFlightTime(120);
                    finishedTardis.addFuel(random.method_39332(45, 125));
                }), (missedTardis -> {
                    missedTardis.removeFuel(random.method_39332(45, 125));
                    missedTardis.fuel().disablePower();
                }), 110L, class_2561.method_43471("sequence.ait.power_drain_imminent").method_27695(class_124.field_1056, class_124.field_1054),
                        new PowerControl(), new RefuelerControl(), new RandomiserControl()));

        SHIP_COMPUTER_OFFLINE = register(
                Sequence.Builder.create(AITMod.id("ship_computer_offline"), (finishedTardis -> {
                    finishedTardis.travel().decreaseFlightTime(240);
                    finishedTardis.addFuel(random.method_39332(45, 125));
                }), (missedTardis -> {
                    missedTardis.removeFuel(random.method_39332(45, 125));
                    missedTardis.fuel().disablePower();
                }), 110L, class_2561.method_43471("sequence.ait.ship_computer_offline").method_27695(class_124.field_1056,
                        class_124.field_1054), new AutoPilotControl()));

        ANTI_GRAVITY_ERROR = register(
                Sequence.Builder.create(AITMod.id("anti_gravity_error"), (finishedTardis -> {
                    finishedTardis.travel().decreaseFlightTime(120);
                }), (missedTardis -> {
                    missedTardis.removeFuel(random.method_39332(45, 125));
                    missedTardis.travel().antigravs().set(false);
                }), 80L, class_2561.method_43471("sequence.ait.anti_gravity_error").method_27695(class_124.field_1056, class_124.field_1054),
                        new AntiGravsControl()));

        DIMENSIONAL_DRIFT_X = register(
                Sequence.Builder.create(AITMod.id("dimensional_drift_x"), (finishedTardis -> {
                    finishedTardis.travel().decreaseFlightTime(120);
                }), (missedTardis -> missedTardis.travel().forceDestination(cached -> {
                    class_2338 pos = cached.getPos();

                    return cached.pos(random.method_39332(pos.method_10263() - 8, pos.method_10263() + 8), pos.method_10264(),
                            random.method_39332(pos.method_10260() - 8, pos.method_10260() + 8));
                })), 100L, class_2561.method_43471("sequence.ait.dimensional_drift_x").method_27695(class_124.field_1056, class_124.field_1054),
                        new DimensionControl(), new XControl()));

        DIMENSIONAL_DRIFT_Y = register(
                Sequence.Builder.create(AITMod.id("dimensional_drift_y"), (finishedTardis -> {
                    finishedTardis.travel().decreaseFlightTime(120);
                }), (missedTardis -> missedTardis.travel().forceDestination(cached -> {
                    class_2338 pos = cached.getPos();

                    return cached.pos(random.method_39332(pos.method_10263() - 8, pos.method_10263() + 8), pos.method_10264(),
                            random.method_39332(pos.method_10260() - 8, pos.method_10260() + 8));
                })), 100L, class_2561.method_43471("sequence.ait.dimensional_drift_y").method_27695(class_124.field_1056, class_124.field_1054),
                        new DimensionControl(), new YControl()));

        DIMENSIONAL_DRIFT_Z = register(
                Sequence.Builder.create(AITMod.id("dimensional_drift_z"), (finishedTardis -> {
                    finishedTardis.travel().decreaseFlightTime(120);
                }), (missedTardis -> missedTardis.travel().forceDestination(cached -> {
                    class_2338 pos = cached.getPos();

                    return cached.pos(random.method_39332(pos.method_10263() - 8, pos.method_10263() + 8), pos.method_10264(),
                            random.method_39332(pos.method_10260() - 8, pos.method_10260() + 8));
                })), 100L, class_2561.method_43471("sequence.ait.dimensional_drift_z").method_27695(class_124.field_1056, class_124.field_1054),
                        new DimensionControl(), new ZControl()));

        CLOAK_TO_AVOID_VORTEX_TRAPPED_MOBS = register(Sequence.Builder
                .create(AITMod.id("cloak_to_avoid_vortex_trapped_mobs"), (finishedTardis -> {
                    finishedTardis.travel().decreaseFlightTime(180);
                    DirectedBlockPos directedDoorPos = finishedTardis.getDesktop().getDoorPos();

                    if (directedDoorPos == null)
                        return;

                    class_2338 doorPos = directedDoorPos.getPos();

                    if (finishedTardis.door().isOpen() || !(finishedTardis instanceof ServerTardis))
                        return;

                    class_3218 world = finishedTardis.asServer().world();

                    class_1542 rewardForCloaking = new class_1542(class_1299.field_6052, world);
                    rewardForCloaking.method_33574(doorPos.method_46558());

                    rewardForCloaking.method_6979(
                            random.method_43056() ? class_1802.field_8423.method_7854() : class_1802.field_8880.method_7854());
                    world.method_8649(rewardForCloaking);
                }), (missedTardis -> {
                    DirectedBlockPos directedDoorPos = missedTardis.getDesktop().getDoorPos();

                    if (directedDoorPos == null)
                        return;

                    class_2338 doorPos = directedDoorPos.getPos();
                    missedTardis.travel().increaseFlightTime(120);

                    if (missedTardis.door().isOpen() || !(missedTardis instanceof ServerTardis))
                        return;

                    class_3218 interior = missedTardis.asServer().world();
                    class_243 centered = doorPos.method_46558();

                    class_1642 zombieEntity = new class_1642(class_1299.field_6051, interior);
                    zombieEntity.method_33574(centered);

                    class_1551 drownedEntity = new class_1551(class_1299.field_6123,
                            interior);
                    drownedEntity.method_33574(centered);

                    class_1593 phantomEntity = new class_1593(class_1299.field_6078,
                            interior);
                    phantomEntity.method_33574(centered);

                    interior.method_8649(random.method_43056() ? random.method_43056() ? drownedEntity : zombieEntity : phantomEntity);
                }), 80L, class_2561.method_43471("sequence.ait.cloak_to_avoid_vortex_trapped_mobs").method_27695(class_124.field_1056, class_124.field_1054),
                        new CloakControl(), new RandomiserControl()));

        DIRECTIONAL_ERROR = register(
                Sequence.Builder.create(AITMod.id("directional_error"), (finishedTardis -> {
                    finishedTardis.travel().decreaseFlightTime(80);
                }), (missedTardis -> {
                    missedTardis.travel().increaseFlightTime(120);
                }), 80L, class_2561.method_43471("sequence.ait.directional_error").method_27695(class_124.field_1056, class_124.field_1054),
                        new DirectionControl()));

        SPEED_UP_TO_AVOID_DRIFTING_OUT_OF_VORTEX = register(Sequence.Builder
                .create(AITMod.id("speed_up_to_avoid_drifting_out_of_vortex"), (finishedTardis -> {
                    finishedTardis.travel().decreaseFlightTime(180);
                }), (missedTardis -> {
                    missedTardis.removeFuel(random.method_39332(45, 125));
                }), 80L, class_2561.method_43471("sequence.ait.speed_up_to_avoid_drifting_out_of_vortex").method_27695(class_124.field_1056,
                        class_124.field_1054), new IncrementControl(), new ThrottleControl()));

        SLOW_DOWN_TO_AVOID_FLYING_OUT_OF_VORTEX = register(Sequence.Builder
                .create(AITMod.id("slow_down_to_avoid_flying_out_of_vortex"), (finishedTardis -> {
                    finishedTardis.travel().decreaseFlightTime(240);
                }), (missedTardis -> {
                    missedTardis.travel().rematerialize();
                }), 80L, class_2561.method_43471("sequence.ait.slow_down_to_avoid_flying_out_of_vortex").method_27695(class_124.field_1056,
                        class_124.field_1054), new IncrementControl(), new HandBrakeControl(), new ThrottleControl()));


        COURSE_CORRECT = register(
                Sequence.Builder.create(AITMod.id("course_correct"), (finishedTardis -> {
                    finishedTardis.travel().decreaseFlightTime(240);
                }), (missedTardis -> {
                    missedTardis.removeFuel(random.method_39332(65, 250));

                    missedTardis.travel().forceDestination(cached -> {
                        class_2338 pos = cached.getPos();

                        return cached.pos(random.method_39332(pos.method_10263() - 24, pos.method_10263() + 24), pos.method_10264(),
                                random.method_39332(pos.method_10260() - 24, pos.method_10260() + 24));
                    });
                }), 110L, class_2561.method_43471("sequence.ait.course_correct").method_27695(class_124.field_1056, class_124.field_1054),
                        new HandBrakeControl(), new ThrottleControl(), new RandomiserControl()));

        GROUND_UNSTABLE = register(
                Sequence.Builder.create(AITMod.id("ground_unstable"), (finishedTardis -> {
                    finishedTardis.travel().decreaseFlightTime(120);
                    finishedTardis.addFuel(random.method_39332(45, 125));
                }), (missedTardis -> {
                    missedTardis.removeFuel(random.method_39332(45, 125));
                }), 110L, class_2561.method_43471("sequence.ait.ground_unstable").method_27695(class_124.field_1056, class_124.field_1054),
                        new LandTypeControl(), new YControl(), new LoadWaypointControl()));

        INCREMENT_SCALE_RECALCULATION_NECESSARY = register(Sequence.Builder
                .create(AITMod.id("increment_scale_recalculation_necessary"), (finishedTardis -> {
                    finishedTardis.travel().decreaseFlightTime(100);
                    finishedTardis.addFuel(random.method_39332(45, 125));
                }), (missedTardis -> {
                    missedTardis.removeFuel(random.method_39332(45, 125));
                }), 80L, class_2561.method_43471("sequence.ait.increment_scale_recalculation_necessary").method_27695(class_124.field_1056,
                        class_124.field_1054), new IncrementControl()));

        SMALL_DEBRIS_FIELD = register(
                Sequence.Builder.create(AITMod.id("small_debris_field"), (finishedTardis -> {
                    finishedTardis.travel().decreaseFlightTime(110);
                    finishedTardis.addFuel(random.method_39332(45, 125));
                }), (missedTardis -> {
                    missedTardis.removeFuel(random.method_39332(45, 125));
                }), 80L, class_2561.method_43471("sequence.ait.small_debris_field").method_27695(class_124.field_1056, class_124.field_1054),
                        new IncrementControl(), new ShieldsControl()));
    }
}
