package dev.amble.ait.registry.impl.door;


import dev.amble.lib.client.bedrock.BedrockModel;
import dev.amble.lib.client.bedrock.BedrockModelRegistry;
import dev.amble.lib.register.datapack.DatapackRegistry;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import dev.amble.ait.client.models.AnimatedModel;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.blockentities.DoorBlockEntity;
import dev.amble.ait.data.schema.door.AnimatedDoor;
import dev.amble.ait.data.schema.door.ClientDoorSchema;
import dev.amble.ait.data.schema.door.DatapackDoor;
import dev.amble.ait.data.schema.door.DoorSchema;
import dev.amble.ait.data.schema.door.impl.*;
import dev.amble.ait.data.schema.door.impl.exclusive.ClientBlueBoxDoorVariant;
import dev.amble.ait.data.schema.door.impl.exclusive.ClientDoomDoorVariant;

public class ClientDoorRegistry extends DatapackRegistry<ClientDoorSchema> {
    private static final ClientDoorRegistry INSTANCE = new ClientDoorRegistry();

    public static ClientDoorRegistry getInstance() {
        return INSTANCE;
    }

    /**
     * Will return the clients version of a servers door variant
     *
     * @param parent
     * @return the first variant found as there should only be one client version
     */
    public static ClientDoorSchema withParent(DoorSchema parent) {
        for (ClientDoorSchema schema : ClientDoorRegistry.getInstance().toList()) {
            if (schema.parent() == null)
                continue;

            if (schema.parent().id().equals(parent.id()))
                return schema;
        }

        return null;
    }

    public static ClientDoorSchema TARDIM;
    public static ClientDoorSchema CLASSIC;
    public static ClientDoorSchema CLASSIC_HUDOLIN;
    public static ClientDoorSchema BOOTH;
    public static ClientDoorSchema CAPSULE;
    public static ClientDoorSchema BOX;
    public static ClientDoorSchema BOX_CORAL;
    public static ClientDoorSchema BOX_RENAISSANCE;
    public static ClientDoorSchema HEAD;
    public static ClientDoorSchema GROWTH;
    public static ClientDoorSchema PLINTH;
    public static ClientDoorSchema RENEGADE;
    public static ClientDoorSchema BOOKSHELF;
    public static ClientDoorSchema GEOMETRIC;
    public static ClientDoorSchema STALLION;
    public static ClientDoorSchema ADAPTIVE;
    public static ClientDoorSchema DALEK_MOD;
    public static ClientDoorSchema PRESENT;
    public static ClientDoorSchema PIPE;

    public static ClientDoorSchema DOOM;
    public static ClientDoorSchema BLUE_BOX;

    @Override
    public void onClientInit() {
        TARDIM = register(new ClientTardimDoorVariant());
        CLASSIC = register(new ClientClassicDoorVariant());
        CLASSIC_HUDOLIN = register(new ClientClassicHudolinDoorVariant());
        BOOTH = register(new ClientBoothDoorVariant());
        CAPSULE = register(new ClientCapsuleDoorVariant());
        BOX = register(new ClientPoliceBoxDoorVariant());
        BOX_CORAL = register(new ClientPoliceBoxCoralDoorVariant());
        BOX_RENAISSANCE = register(new ClientPoliceBoxRenaissanceDoorVariant());
        HEAD = register(new ClientEasterHeadDoorVariant());
        GROWTH = register(new ClientGrowthDoorVariant());
        PLINTH = register(new ClientPlinthDoorVariant());
        RENEGADE = register(new ClientRenegadeDoorVariant());
        BOOKSHELF = register(new ClientBookshelfDoorVariant());
        GEOMETRIC = register(new ClientGeometricDoorVariant());
        STALLION = register(new ClientStallionDoorVariant());
        ADAPTIVE = register(new ClientAdaptiveDoorVariant());
        DALEK_MOD = register(new ClientDalekModDoorVariant());
        PRESENT = register(new ClientPresentDoorVariant());
        PIPE = register(new ClientPipeDoorVariant());

        DOOM = register(new ClientDoomDoorVariant());
        BLUE_BOX = register(new ClientBlueBoxDoorVariant());
    }

    @Override
    public ClientDoorSchema fallback() {
        return CAPSULE;
    }

    @Override
    public void syncToClient(class_3222 player) {
        // do not call
    }

    @Override
    public void readFromServer(class_2540 buf) {
        for (DoorSchema schema : DoorRegistry.getInstance().toList()) {
            if (!(schema instanceof DatapackDoor variant)) continue;

            ClientDoorSchema clientSchema = convertDatapack(variant);

            if (clientSchema == null) continue;

            this.register(clientSchema);
        }
    }

    public static ClientDoorSchema convertDatapack(DatapackDoor variant) {
        if (!variant.wasDatapack())
            return convertNonDatapack(variant);

        return new ClientDoorSchema(variant.id()) {
            @Override
            public AnimatedModel<DoorBlockEntity> model() {
                BedrockModel model = BedrockModelRegistry.getInstance().get(variant.getModelId());
                class_630 root = model.create().method_32109();

                return new AnimatedModel<>() {
                    @Override
                    public void renderWithAnimations(ClientTardis tardis, DoorBlockEntity be, class_630 root, class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float pAlpha, float tickDelta) {
                        matrices.method_22903();

                        DoorSchema schema = tardis.getExterior().getVariant().door();

                        if (schema instanceof AnimatedDoor animDoor) {
                            this.getPart().method_32088().forEach(class_630::method_41923);
                            animDoor.runAnimations(root, matrices, tickDelta, tardis);
                        }
                        root.method_22699(matrices, vertices, light, overlay, red, green, blue, pAlpha);

                        matrices.method_22909();
                    }

                    @Override
                    public class_630 getPart() {
                        return root;
                    }
                };
            }
        };
    }

    private static ClientDoorSchema convertNonDatapack(DatapackDoor variant) {
        if (variant.wasDatapack())
            return convertDatapack(variant);

        return getInstance().get(variant.id());
    }
}
