package dev.drtheo.gaslighter.mixin;

import dev.drtheo.gaslighter.api.FakeBlockEvents;
import dev.drtheo.gaslighter.api.Twitter;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2885;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3244;
import net.minecraft.class_3965;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_3244.class, priority = 1001)
public abstract class ServerPlayNetworkHandlerMixin {

    @Shadow public class_3222 player;

    @Redirect(method = "onPlayerInteractBlock", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/ServerPlayerInteractionManager;interactBlock(Lnet/minecraft/server/network/ServerPlayerEntity;Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/Hand;Lnet/minecraft/util/hit/BlockHitResult;)Lnet/minecraft/util/ActionResult;"))
    public class_1269 onPlayerInteractBlock(class_3225 instance, class_3222 player, class_1937 world, class_1799 stack, class_1268 hand, class_3965 hitResult) {
        class_3218 serverWorld = this.player.method_51469();
        class_2338 blockPos = hitResult.method_17777();

        if (serverWorld instanceof Twitter twitter && twitter.ait$isFake(blockPos)) {
            FakeBlockEvents.Action action = FakeBlockEvents.INTERACT.invoker().check(player, hand, hitResult.method_17777());

            if (action.shouldRemove())
                return class_1269.field_5811;
        }

        return instance.method_14262(player, world, stack, hand, hitResult);
    }

    @Inject(method = "onPlayerInteractBlock", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/ServerPlayNetworkHandler;sendPacket(Lnet/minecraft/network/packet/Packet;)V"), cancellable = true)
    public void onPlayerInteractBlock(class_2885 packet, CallbackInfo ci) {
        class_3218 serverWorld = this.player.method_51469();

        class_3965 blockHitResult = packet.method_12543();
        class_2338 blockPos = blockHitResult.method_17777();

        class_2680 state = serverWorld.method_8320(blockPos);

        if (serverWorld instanceof Twitter twitter && twitter.ait$isFake(blockPos)) {
            FakeBlockEvents.Action action = FakeBlockEvents.CHECK.invoker().check(player, packet.method_12546(), state, blockPos);

            if (!action.shouldRemove())
                ci.cancel();
        }
    }
}
