/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import dev.amble.ait.api.AITModInitializer;
import dev.amble.ait.config.AITServerConfig;
import dev.amble.ait.core.AITArgumentTypes;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITDimensions;
import dev.amble.ait.core.AITEntityTypes;
import dev.amble.ait.core.AITItemGroups;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITPaintings;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.AITStatusEffects;
import dev.amble.ait.core.AITVillagers;
import dev.amble.ait.core.advancement.TardisCriterions;
import dev.amble.ait.core.commands.DataCommand;
import dev.amble.ait.core.commands.DebugCommand;
import dev.amble.ait.core.commands.EraseChunksCommand;
import dev.amble.ait.core.commands.FlightCommand;
import dev.amble.ait.core.commands.FuelCommand;
import dev.amble.ait.core.commands.GetCreatorCommand;
import dev.amble.ait.core.commands.GetNameCommand;
import dev.amble.ait.core.commands.LinkCommand;
import dev.amble.ait.core.commands.ListCommand;
import dev.amble.ait.core.commands.LoadCommand;
import dev.amble.ait.core.commands.LoyaltyCommand;
import dev.amble.ait.core.commands.PermissionCommand;
import dev.amble.ait.core.commands.RemoveCommand;
import dev.amble.ait.core.commands.RiftChunkCommand;
import dev.amble.ait.core.commands.SafePosCommand;
import dev.amble.ait.core.commands.ScaleCommand;
import dev.amble.ait.core.commands.SetDoorParticleCommand;
import dev.amble.ait.core.commands.SetLockedCommand;
import dev.amble.ait.core.commands.SetMaxSpeedCommand;
import dev.amble.ait.core.commands.SetNameCommand;
import dev.amble.ait.core.commands.SetRepairTicksCommand;
import dev.amble.ait.core.commands.SetSiegeCommand;
import dev.amble.ait.core.commands.SummonTardisCommand;
import dev.amble.ait.core.commands.TeleportInteriorCommand;
import dev.amble.ait.core.commands.ThisTardisCommand;
import dev.amble.ait.core.commands.TravelDebugCommand;
import dev.amble.ait.core.commands.TriggerMoodRollCommand;
import dev.amble.ait.core.commands.UnLinkCommand;
import dev.amble.ait.core.commands.UnlockCommand;
import dev.amble.ait.core.commands.VersionCommand;
import dev.amble.ait.core.drinks.DrinkRegistry;
import dev.amble.ait.core.engine.registry.SubSystemRegistry;
import dev.amble.ait.core.entities.FlightTardisEntity;
import dev.amble.ait.core.entities.RiftEntity;
import dev.amble.ait.core.item.blueprint.BlueprintRegistry;
import dev.amble.ait.core.item.component.AbstractTardisPart;
import dev.amble.ait.core.item.part.MachineItem;
import dev.amble.ait.core.likes.ItemOpinionRegistry;
import dev.amble.ait.core.lock.LockedDimensionRegistry;
import dev.amble.ait.core.loot.SetBlueprintLootFunction;
import dev.amble.ait.core.sounds.flight.FlightSoundRegistry;
import dev.amble.ait.core.sounds.travel.TravelSoundRegistry;
import dev.amble.ait.core.tardis.animation.v2.blockbench.BlockbenchParser;
import dev.amble.ait.core.tardis.animation.v2.datapack.TardisAnimationRegistry;
import dev.amble.ait.core.tardis.control.sound.ControlSoundRegistry;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.tardis.util.AsyncLocatorUtil;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.tardis.vortex.reference.VortexReferenceRegistry;
import dev.amble.ait.core.util.CustomTrades;
import dev.amble.ait.core.util.StackUtil;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.core.world.LandingPadManager;
import dev.amble.ait.core.world.RiftChunkManager;
import dev.amble.ait.data.landing.LandingPadRegion;
import dev.amble.ait.data.schema.MachineRecipeSchema;
import dev.amble.ait.module.ModuleRegistry;
import dev.amble.ait.module.planet.core.space.planet.Crater;
import dev.amble.ait.registry.impl.CategoryRegistry;
import dev.amble.ait.registry.impl.ControlRegistry;
import dev.amble.ait.registry.impl.CreakRegistry;
import dev.amble.ait.registry.impl.DesktopRegistry;
import dev.amble.ait.registry.impl.HandlesResponseRegistry;
import dev.amble.ait.registry.impl.HumRegistry;
import dev.amble.ait.registry.impl.MachineRecipeRegistry;
import dev.amble.ait.registry.impl.MoodEventPoolRegistry;
import dev.amble.ait.registry.impl.SequenceRegistry;
import dev.amble.ait.registry.impl.SonicRegistry;
import dev.amble.ait.registry.impl.TardisComponentRegistry;
import dev.amble.ait.registry.impl.console.ConsoleRegistry;
import dev.amble.ait.registry.impl.console.variant.ConsoleVariantRegistry;
import dev.amble.ait.registry.impl.door.DoorRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;
import dev.amble.lib.container.RegistryContainer;
import dev.amble.lib.register.AmbleRegistries;
import dev.amble.lib.register.Registry;
import dev.amble.lib.util.ServerLifecycleHooks;
import dev.drtheo.multidim.MultiDim;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_2540;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3133;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_39;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_5335;
import net.minecraft.class_5339;
import net.minecraft.class_55;
import net.minecraft.class_6796;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AITMod
implements ModInitializer {
    public static final String MOD_ID = "ait";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ait");
    public static final Random RANDOM = new Random();
    public static AITServerConfig CONFIG;
    public static final class_1928.class_4313<class_1928.class_4310> STASER_GRIEFING;
    public static final class_1928.class_4313<class_1928.class_4310> TARDIS_GRIEFING;
    public static final class_1928.class_4313<class_1928.class_4310> TARDIS_FIRE_GRIEFING;
    public static final class_5321<class_6796> CUSTOM_GEODE_PLACED_KEY;
    public static final class_2400 CORAL_PARTICLE;
    public static final Crater CRATER;
    public static final String BRANCH;
    public static final class_2960 OPEN_SCREEN;
    public static final class_2960 OPEN_SCREEN_TARDIS;
    public static final class_2960 OPEN_SCREEN_CONSOLE;

    public static boolean isUnsafeBranch() {
        return !BRANCH.contains("release");
    }

    public void registerParticles() {
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)AITMod.id("coral_particle"), (Object)CORAL_PARTICLE);
    }

    public void onInitialize() {
        AITServerConfig.INSTANCE.load();
        CONFIG = (AITServerConfig)AITServerConfig.INSTANCE.instance();
        ServerLifecycleHooks.init();
        AsyncLocatorUtil.init();
        MultiDim.init();
        CreakRegistry.init();
        SequenceRegistry.init();
        MoodEventPoolRegistry.init();
        LandingPadManager.init();
        ControlRegistry.init();
        RiftChunkManager.init();
        AmbleRegistries.getInstance().registerAll(new Registry[]{ConsoleRegistry.getInstance(), SonicRegistry.getInstance(), DesktopRegistry.getInstance(), ConsoleVariantRegistry.getInstance(), MachineRecipeRegistry.getInstance(), TravelSoundRegistry.getInstance(), FlightSoundRegistry.getInstance(), VortexReferenceRegistry.getInstance(), BlueprintRegistry.getInstance(), ExteriorVariantRegistry.getInstance(), CategoryRegistry.getInstance(), TardisComponentRegistry.getInstance(), LockedDimensionRegistry.getInstance(), HumRegistry.getInstance(), SubSystemRegistry.getInstance(), ItemOpinionRegistry.getInstance(), DrinkRegistry.getInstance(), TardisAnimationRegistry.getInstance(), DoorRegistry.getInstance()});
        ControlSoundRegistry.init();
        BlockbenchParser.init();
        this.registerParticles();
        FabricLoader.getInstance().invokeEntrypoints("ait-main", AITModInitializer.class, AITModInitializer::onInitializeAIT);
        HandlesResponseRegistry.init();
        AITStatusEffects.init();
        AITVillagers.init();
        AITArgumentTypes.register();
        AITSounds.init();
        AITDimensions.init();
        CustomTrades.register();
        RegistryContainer.register(AITItemGroups.class, (String)MOD_ID);
        RegistryContainer.register(AITItems.class, (String)MOD_ID);
        RegistryContainer.register(AITBlocks.class, (String)MOD_ID);
        RegistryContainer.register(AITBlockEntityTypes.class, (String)MOD_ID);
        RegistryContainer.register(AITEntityTypes.class, (String)MOD_ID);
        RegistryContainer.register(AITPaintings.class, (String)MOD_ID);
        ModuleRegistry.instance().onCommonInit();
        BlueprintRegistry.BLUEPRINT_TYPE = (class_5339)class_2378.method_10230((class_2378)class_7923.field_41134, (class_2960)AITMod.id("set_blueprint"), (Object)new class_5339((class_5335)new SetBlueprintLootFunction.Serializer()));
        WorldUtil.init();
        TardisUtil.init();
        ServerTardisManager.init();
        TardisCriterions.init();
        this.entityAttributeRegister();
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInOverworld(), (class_2893.class_2895)class_2893.class_2895.field_13176, CUSTOM_GEODE_PLACED_KEY);
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.all(), (class_1311)class_1311.field_6303, AITEntityTypes.RIFT_ENTITY, (int)4, (int)1, (int)1);
        class_2378.method_10230((class_2378)class_7923.field_41144, (class_2960)Crater.CRATER_ID, (Object)((Object)CRATER));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            TeleportInteriorCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SummonTardisCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SetLockedCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ThisTardisCommand.register((CommandDispatcher<class_2168>)dispatcher);
            FuelCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SetRepairTicksCommand.register((CommandDispatcher<class_2168>)dispatcher);
            RiftChunkCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ScaleCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TriggerMoodRollCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SetNameCommand.register((CommandDispatcher<class_2168>)dispatcher);
            GetNameCommand.register((CommandDispatcher<class_2168>)dispatcher);
            GetCreatorCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SetMaxSpeedCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SetSiegeCommand.register((CommandDispatcher<class_2168>)dispatcher);
            LinkCommand.register((CommandDispatcher<class_2168>)dispatcher);
            UnLinkCommand.register((CommandDispatcher<class_2168>)dispatcher);
            RemoveCommand.register((CommandDispatcher<class_2168>)dispatcher);
            PermissionCommand.register((CommandDispatcher<class_2168>)dispatcher);
            LoyaltyCommand.register((CommandDispatcher<class_2168>)dispatcher);
            UnlockCommand.register((CommandDispatcher<class_2168>)dispatcher);
            DataCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TravelDebugCommand.register((CommandDispatcher<class_2168>)dispatcher);
            VersionCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SafePosCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ListCommand.register((CommandDispatcher<class_2168>)dispatcher);
            LoadCommand.register((CommandDispatcher<class_2168>)dispatcher);
            DebugCommand.register((CommandDispatcher<class_2168>)dispatcher);
            EraseChunksCommand.register((CommandDispatcher<class_2168>)dispatcher);
            FlightCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SetDoorParticleCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess);
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TardisUtil.REGION_LANDING_CODE, (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            String landingCode = buf.method_19772();
            server.execute(() -> {
                LandingPadRegion region = LandingPadManager.getInstance((class_3218)player.method_37908()).getRegionAt(pos);
                if (region == null) {
                    return;
                }
                region.setLandingCode(landingCode);
                LandingPadManager.Network.syncTracked(LandingPadManager.Network.Action.ADD, player.method_51469(), new class_1923(player.method_24515()));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MachineItem.MACHINE_DISASSEMBLE, (server, player, handler, buf, responseSender) -> {
            class_1799 machine = buf.method_10819();
            Optional<MachineRecipeSchema> schema = MachineRecipeRegistry.getInstance().findMatching(machine);
            if (schema.isEmpty()) {
                return;
            }
            server.execute(() -> {
                MachineItem.disassemble(player, machine, (MachineRecipeSchema)schema.get());
                StackUtil.playBreak((class_1657)player);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)AbstractTardisPart.DISASSEMBLE, (server, player, handler, buf, responseSender) -> {
            class_1799 machine = buf.method_10819();
            Optional<MachineRecipeSchema> schema = MachineRecipeRegistry.getInstance().findMatching(machine);
            if (schema.isEmpty()) {
                return;
            }
            server.execute(() -> {
                AbstractTardisPart.disassemble(player, machine, (MachineRecipeSchema)schema.get());
                StackUtil.playBreak((class_1657)player);
            });
        });
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            if (source.isBuiltin() && (id.equals((Object)class_39.field_615) || id.equals((Object)class_39.field_885) || id.equals((Object)class_39.field_17009) || id.equals((Object)class_39.field_24050)) || id.equals((Object)class_39.field_274) || id.equals((Object)class_39.field_841) || id.equals((Object)class_39.field_472) || id.equals((Object)class_39.field_16751) || id.equals((Object)class_39.field_17107) || id.equals((Object)class_39.field_665) || id.equals((Object)class_39.field_38438) || id.equals((Object)class_39.field_38439) || id.equals((Object)class_39.field_251) || id.equals((Object)class_39.field_43354) || id.equals((Object)class_39.field_43353) || id.equals((Object)class_39.field_43357) || id.equals((Object)class_39.field_43356) || id.equals((Object)class_39.field_44649) || id.equals((Object)class_39.field_854) || id.equals((Object)class_39.field_885) || id.equals((Object)class_39.field_356) || id.equals((Object)class_39.field_683)) {
                class_55.class_56 poolBuilder = class_55.method_347().method_351((class_79.class_80)class_77.method_411((class_1935)AITItems.BLUEPRINT).method_438(SetBlueprintLootFunction.random()).method_437(10));
                tableBuilder.method_336(poolBuilder);
            }
        });
    }

    public void entityAttributeRegister() {
        FabricDefaultAttributeRegistry.register(AITEntityTypes.RIFT_ENTITY, (class_5132.class_5133)RiftEntity.method_26828());
        FabricDefaultAttributeRegistry.register(AITEntityTypes.FLIGHT_TARDIS_TYPE, (class_5132.class_5133)FlightTardisEntity.createDummyAttributes());
    }

    public static void openScreen(class_3222 player, int id) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(id);
        ServerPlayNetworking.send((class_3222)player, (class_2960)OPEN_SCREEN, (class_2540)buf);
    }

    public static void openScreen(class_3222 player, int id, UUID tardis) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(id);
        buf.method_10797(tardis);
        ServerPlayNetworking.send((class_3222)player, (class_2960)OPEN_SCREEN_TARDIS, (class_2540)buf);
    }

    public static void openScreen(class_3222 player, int id, UUID tardis, class_2338 console) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(id);
        buf.method_10797(tardis);
        buf.method_10807(console);
        ServerPlayNetworking.send((class_3222)player, (class_2960)OPEN_SCREEN_CONSOLE, (class_2540)buf);
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    static {
        STASER_GRIEFING = GameRuleRegistry.register((String)"staserGriefing", (class_1928.class_5198)class_1928.class_5198.field_24100, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)true));
        TARDIS_GRIEFING = GameRuleRegistry.register((String)"tardisGriefing", (class_1928.class_5198)class_1928.class_5198.field_24100, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)true));
        TARDIS_FIRE_GRIEFING = GameRuleRegistry.register((String)"tardisFireGriefing", (class_1928.class_5198)class_1928.class_5198.field_24100, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)false));
        CUSTOM_GEODE_PLACED_KEY = class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)new class_2960(MOD_ID, "zeiton_geode"));
        CORAL_PARTICLE = FabricParticleTypes.simple();
        CRATER = new Crater((Codec<class_3133>)class_3133.field_24899);
        String version = ((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).get()).getMetadata().getVersion().getFriendlyString();
        BRANCH = version.substring(version.indexOf("-"), version.lastIndexOf("-"));
        OPEN_SCREEN = AITMod.id("open_screen");
        OPEN_SCREEN_TARDIS = AITMod.id("open_screen_tardis");
        OPEN_SCREEN_CONSOLE = AITMod.id("open_screen_console");
    }
}

