/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.api.tardis;

public abstract class Initializable<T extends Context> {
    protected static <T extends Context> void init(Initializable<T> component, T context) {
        component.init(context);
    }

    protected void init(T context) {
        this.onEarlyInit(context);
        if (context.deserialized()) {
            this.onLoaded();
        } else {
            this.onCreate();
        }
        this.onInit(context);
    }

    protected void onEarlyInit(T ctx) {
    }

    protected void onInit(T ctx) {
    }

    public void onCreate() {
    }

    public void onLoaded() {
    }

    public static interface Context {
        public boolean created();

        public boolean deserialized();
    }
}

