/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.api.tardis;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.Disposable;
import dev.amble.ait.api.tardis.Initializable;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisDesktop;
import dev.amble.ait.core.tardis.TardisExterior;
import dev.amble.ait.core.tardis.TardisHandlersManager;
import dev.amble.ait.core.tardis.TardisManager;
import dev.amble.ait.core.tardis.control.impl.pos.IncrementManager;
import dev.amble.ait.core.tardis.control.sequences.SequenceHandler;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.core.tardis.handler.ButlerHandler;
import dev.amble.ait.core.tardis.handler.ChameleonHandler;
import dev.amble.ait.core.tardis.handler.CloakHandler;
import dev.amble.ait.core.tardis.handler.DoorHandler;
import dev.amble.ait.core.tardis.handler.ExteriorEnvironmentHandler;
import dev.amble.ait.core.tardis.handler.ExtraHandler;
import dev.amble.ait.core.tardis.handler.FuelHandler;
import dev.amble.ait.core.tardis.handler.HadsHandler;
import dev.amble.ait.core.tardis.handler.InteriorChangingHandler;
import dev.amble.ait.core.tardis.handler.LandingPadHandler;
import dev.amble.ait.core.tardis.handler.LoyaltyHandler;
import dev.amble.ait.core.tardis.handler.OpinionHandler;
import dev.amble.ait.core.tardis.handler.RealFlightHandler;
import dev.amble.ait.core.tardis.handler.SelfDestructHandler;
import dev.amble.ait.core.tardis.handler.ServerAlarmHandler;
import dev.amble.ait.core.tardis.handler.ServerHumHandler;
import dev.amble.ait.core.tardis.handler.ShieldHandler;
import dev.amble.ait.core.tardis.handler.SiegeHandler;
import dev.amble.ait.core.tardis.handler.SonicHandler;
import dev.amble.ait.core.tardis.handler.StatsHandler;
import dev.amble.ait.core.tardis.handler.SubSystemHandler;
import dev.amble.ait.core.tardis.handler.TardisCrashHandler;
import dev.amble.ait.core.tardis.handler.WaypointHandler;
import dev.amble.ait.core.tardis.handler.mood.MoodHandler;
import dev.amble.ait.core.tardis.handler.permissions.PermissionHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.enummap.Ordered;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public abstract class TardisComponent
extends Initializable<InitContext>
implements Disposable {
    @Exclude
    protected Tardis tardis;
    @Exclude(strategy=Exclude.Strategy.NETWORK)
    private final IdLike id;

    public TardisComponent(IdLike id) {
        this.id = id;
    }

    public void postInit(InitContext ctx) {
    }

    protected void sync() {
        if (this.isClient()) {
            AITMod.LOGGER.warn("Attempted to sync a component ON a client!", (Throwable)new IllegalAccessException());
            return;
        }
        ServerTardisManager.getInstance().markComponentDirty(this);
    }

    public Tardis tardis() {
        return this.tardis;
    }

    public IdLike getId() {
        return this.id;
    }

    public void setTardis(Tardis tardis) {
        this.tardis = tardis;
    }

    public boolean isClient() {
        return this.tardis() instanceof ClientTardis;
    }

    public boolean isServer() {
        return this.tardis() instanceof ServerTardis;
    }

    public TardisManager<?, ?> parentManager() {
        return TardisManager.getInstance(this.tardis);
    }

    @Override
    public void dispose() {
        this.tardis = null;
    }

    public static void init(TardisComponent component, Tardis tardis, InitContext context) {
        component.setTardis(tardis);
        component.init(context);
    }

    public static void postInit(TardisComponent component, InitContext context) {
        component.postInit(context);
    }

    public static interface IdLike
    extends Ordered {
        public Class<? extends TardisComponent> clazz();

        default public void set(ClientTardis tardis, TardisComponent component) {
            tardis.getHandlers().set(component);
        }

        default public TardisComponent get(ClientTardis tardis) {
            return tardis.handler(this);
        }

        public TardisComponent create();

        public boolean creatable();

        public String name();

        @Override
        public int index();

        public void index(int var1);
    }

    public record InitContext(@Nullable CachedDirectedGlobalPos pos, boolean deserialized) implements Initializable.Context
    {
        public static InitContext createdAt(CachedDirectedGlobalPos pos) {
            return new InitContext(pos, false);
        }

        public static InitContext deserialize() {
            return new InitContext(null, true);
        }

        @Override
        public boolean created() {
            return !this.deserialized;
        }
    }

    public static class AbstractId<T extends TardisComponent>
    implements IdLike {
        private final String name;
        private final Supplier<T> creator;
        private final Class<T> clazz;
        private int index;

        public AbstractId(String name, Supplier<T> creator, Class<T> clazz) {
            this.name = name;
            this.creator = creator;
            this.clazz = clazz;
        }

        public Class<T> clazz() {
            return this.clazz;
        }

        @Override
        public TardisComponent create() {
            return (TardisComponent)this.creator.get();
        }

        @Override
        public boolean creatable() {
            return true;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void index(int i) {
            this.index = i;
        }
    }

    public static enum Id implements IdLike
    {
        DESKTOP(TardisDesktop.class, null),
        EXTERIOR(TardisExterior.class, null),
        HANDLERS(TardisHandlersManager.class, null),
        TRAVEL(TravelHandler.class, TravelHandler::new),
        DOOR(DoorHandler.class, DoorHandler::new),
        SONIC(SonicHandler.class, SonicHandler::new),
        BUTLER(ButlerHandler.class, ButlerHandler::new),
        PERMISSIONS(PermissionHandler.class, PermissionHandler::new),
        LOYALTY(LoyaltyHandler.class, LoyaltyHandler::new),
        FLIGHT(RealFlightHandler.class, RealFlightHandler::new),
        BIOME(BiomeHandler.class, BiomeHandler::new),
        SHIELDS(ShieldHandler.class, ShieldHandler::new),
        STATS(StatsHandler.class, StatsHandler::new),
        EXTRAS(ExtraHandler.class, ExtraHandler::new),
        CRASH_DATA(TardisCrashHandler.class, TardisCrashHandler::new),
        WAYPOINTS(WaypointHandler.class, WaypointHandler::new),
        HUM(ServerHumHandler.class, ServerHumHandler::new),
        ALARMS(ServerAlarmHandler.class, ServerAlarmHandler::new),
        ENVIRONMENT(ExteriorEnvironmentHandler.class, ExteriorEnvironmentHandler::new),
        INTERIOR(InteriorChangingHandler.class, InteriorChangingHandler::new),
        SEQUENCE(SequenceHandler.class, SequenceHandler::new),
        MOOD(MoodHandler.class, MoodHandler::new),
        FUEL(FuelHandler.class, FuelHandler::new),
        HADS(HadsHandler.class, HadsHandler::new),
        SIEGE(SiegeHandler.class, SiegeHandler::new),
        CLOAK(CloakHandler.class, CloakHandler::new),
        INCREMENT(IncrementManager.class, IncrementManager::new),
        LANDING_PAD(LandingPadHandler.class, LandingPadHandler::new),
        CHAMELEON(ChameleonHandler.class, ChameleonHandler::new),
        SELF_DESTRUCT(SelfDestructHandler.class, SelfDestructHandler::new),
        OPINION(OpinionHandler.class, OpinionHandler::new),
        SUBSYSTEM(SubSystemHandler.class, SubSystemHandler::new);

        private final Supplier<TardisComponent> creator;
        private final Class<? extends TardisComponent> clazz;
        private Integer index = null;

        private <T extends TardisComponent> Id(Class<T> clazz, Supplier<T> creator) {
            this.clazz = clazz;
            this.creator = creator;
        }

        @Override
        public Class<? extends TardisComponent> clazz() {
            return this.clazz;
        }

        @Override
        public void set(ClientTardis tardis, TardisComponent component) {
            switch (this.ordinal()) {
                case 0: {
                    tardis.setDesktop((TardisDesktop)component);
                    break;
                }
                case 1: {
                    tardis.setExterior((TardisExterior)component);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    tardis.getHandlers().set(component);
                }
            }
        }

        @Override
        public TardisComponent get(ClientTardis tardis) {
            return switch (this.ordinal()) {
                case 0 -> tardis.getDesktop();
                case 1 -> tardis.getExterior();
                case 2 -> tardis.getHandlers();
                default -> tardis.handler(this);
            };
        }

        @Override
        public TardisComponent create() {
            return this.creator.get();
        }

        @Override
        public boolean creatable() {
            return this.creator != null;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void index(int i) {
            this.index = i;
        }

        public static IdLike[] ids() {
            return Id.values();
        }
    }
}

