/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.api.tardis;

import dev.amble.ait.core.engine.DurableSubSystem;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.engine.impl.EngineSystem;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.handler.DoorHandler;
import dev.amble.ait.data.landing.LandingPadSpot;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.data.DirectedBlockPos;
import java.util.Optional;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public final class TardisEvents {
    public static final Event<Demat> DEMAT = EventFactory.createArrayBacked(Demat.class, callbacks -> tardis -> {
        for (Demat callback : callbacks) {
            Interaction value = callback.onDemat(tardis);
            if (value == Interaction.PASS) continue;
            return value;
        }
        return Interaction.SUCCESS;
    });
    public static final Event<EnterFlight> ENTER_FLIGHT = EventFactory.createArrayBacked(EnterFlight.class, callbacks -> tardis -> {
        for (EnterFlight callback : callbacks) {
            callback.onFlight(tardis);
        }
    });
    public static final Event<FinishFlight> FINISH_FLIGHT = EventFactory.createArrayBacked(FinishFlight.class, callbacks -> tardis -> {
        for (FinishFlight callback : callbacks) {
            Interaction value = callback.onFinish(tardis);
            if (value == Interaction.PASS) continue;
            return value;
        }
        return Interaction.PASS;
    });
    public static final Event<Mat> MAT = EventFactory.createArrayBacked(Mat.class, callbacks -> tardis -> {
        for (Mat callback : callbacks) {
            Interaction value = callback.onMat(tardis);
            if (value == Interaction.PASS) continue;
            return value;
        }
        return Interaction.SUCCESS;
    });
    public static final Event<StartFalling> START_FALLING = EventFactory.createArrayBacked(StartFalling.class, callbacks -> tardis -> {
        for (StartFalling callback : callbacks) {
            callback.onStartFall(tardis);
        }
    });
    public static final Event<BeforeLand> BEFORE_LAND = EventFactory.createArrayBacked(BeforeLand.class, callbacks -> (tardis, pos) -> {
        for (BeforeLand callback : callbacks) {
            Result<CachedDirectedGlobalPos> result = callback.onLanded(tardis, pos);
            if (result.type() != Interaction.PASS) {
                return result;
            }
            if (!result.value().isPresent()) continue;
            pos = result.value().get();
        }
        return new Result<CachedDirectedGlobalPos>(Interaction.SUCCESS, pos);
    });
    public static final Event<Landed> LANDED = EventFactory.createArrayBacked(Landed.class, callbacks -> tardis -> {
        for (Landed callback : callbacks) {
            callback.onLanded(tardis);
        }
    });
    public static final Event<Crash> CRASH = EventFactory.createArrayBacked(Crash.class, callbacks -> tardis -> {
        for (Crash callback : callbacks) {
            callback.onCrash(tardis);
        }
    });
    public static final Event<LandingPadAdjust> LANDING_PAD_ADJUST = EventFactory.createArrayBacked(LandingPadAdjust.class, callbacks -> (tardis, spot) -> {
        for (LandingPadAdjust callback : callbacks) {
            callback.onLandingPadAdjust(tardis, spot);
        }
    });
    public static final Event<NoFuel> OUT_OF_FUEL = EventFactory.createArrayBacked(NoFuel.class, callbacks -> tardis -> {
        for (NoFuel callback : callbacks) {
            callback.onNoFuel(tardis);
        }
    });
    public static final Event<LosePower> LOSE_POWER = EventFactory.createArrayBacked(LosePower.class, callbacks -> tardis -> {
        for (LosePower callback : callbacks) {
            callback.onLosePower(tardis);
        }
    });
    public static final Event<RegainPower> REGAIN_POWER = EventFactory.createArrayBacked(RegainPower.class, callbacks -> tardis -> {
        for (RegainPower callback : callbacks) {
            callback.onRegainPower(tardis);
        }
    });
    public static final Event<UseBackupPower> USE_BACKUP_POWER = EventFactory.createArrayBacked(UseBackupPower.class, callbacks -> (tardis, power) -> {
        for (UseBackupPower callback : callbacks) {
            callback.onUse(tardis, power);
        }
    });
    public static final Event<OpenDoor> DOOR_OPEN = EventFactory.createArrayBacked(OpenDoor.class, callbacks -> tardis -> {
        for (OpenDoor callback : callbacks) {
            callback.onOpen(tardis);
        }
    });
    public static final Event<CloseDoor> DOOR_CLOSE = EventFactory.createArrayBacked(CloseDoor.class, callbacks -> tardis -> {
        for (CloseDoor callback : callbacks) {
            callback.onClose(tardis);
        }
    });
    public static final Event<CloseDoor> REAL_DOOR_CLOSE = EventFactory.createArrayBacked(CloseDoor.class, callbacks -> tardis -> {
        for (CloseDoor callback : callbacks) {
            callback.onClose(tardis);
        }
    });
    public static final Event<MoveDoor> DOOR_MOVE = EventFactory.createArrayBacked(MoveDoor.class, callbacks -> (tardis, newPos, oldPos) -> {
        for (MoveDoor callback : callbacks) {
            callback.onMove(tardis, newPos, oldPos);
        }
    });
    public static final Event<MoveEngine> ENGINE_MOVE = EventFactory.createArrayBacked(MoveEngine.class, callbacks -> (tardis, newPos, oldPos) -> {
        for (MoveEngine callback : callbacks) {
            callback.onMove(tardis, newPos, oldPos);
        }
    });
    public static final Event<UseDoor> USE_DOOR = EventFactory.createArrayBacked(UseDoor.class, callbacks -> (tardis, interior, world, player, pos) -> {
        for (UseDoor callback : callbacks) {
            DoorHandler.InteractionResult result = callback.onUseDoor(tardis, interior, world, player, pos);
            if (result == DoorHandler.InteractionResult.CONTINUE) continue;
            return result;
        }
        return DoorHandler.InteractionResult.CONTINUE;
    });
    public static final Event<DoorUsed> DOOR_USED = EventFactory.createArrayBacked(DoorUsed.class, callbacks -> (tardis, player) -> {
        for (DoorUsed callback : callbacks) {
            DoorHandler.InteractionResult result = callback.onDoorUsed(tardis, player);
            if (result == DoorHandler.InteractionResult.CONTINUE) continue;
            return result;
        }
        return DoorHandler.InteractionResult.CONTINUE;
    });
    public static final Event<EnterTardis> ENTER_TARDIS = EventFactory.createArrayBacked(EnterTardis.class, callbacks -> (tardis, entity) -> {
        for (EnterTardis callback : callbacks) {
            callback.onEnter(tardis, entity);
        }
    });
    public static final Event<LeaveTardis> LEAVE_TARDIS = EventFactory.createArrayBacked(LeaveTardis.class, callbacks -> (tardis, entity) -> {
        for (LeaveTardis callback : callbacks) {
            callback.onLeave(tardis, entity);
        }
    });
    public static final Event<BreakDoor> BREAK_DOOR = EventFactory.createArrayBacked(BreakDoor.class, callbacks -> (tardis, pos) -> {
        for (BreakDoor callback : callbacks) {
            callback.onBreak(tardis, pos);
        }
    });
    public static final Event<Shields> TOGGLE_SHIELDS = EventFactory.createArrayBacked(Shields.class, callbacks -> (tardis, active, visual) -> {
        for (Shields callback : callbacks) {
            callback.onShields(tardis, active, visual);
        }
    });
    public static final Event<Siege> TOGGLE_SIEGE = EventFactory.createArrayBacked(Siege.class, callbacks -> (tardis, active) -> {
        for (Siege callback : callbacks) {
            callback.onSiege(tardis, active);
        }
    });
    public static final Event<SyncTardis> SYNC_TARDIS = EventFactory.createArrayBacked(SyncTardis.class, callbacks -> (player, chunk) -> {
        for (SyncTardis callback : callbacks) {
            callback.sync(player, chunk);
        }
    });
    public static final Event<SendTardis> SEND_TARDIS = EventFactory.createArrayBacked(SendTardis.class, callbacks -> (tardis, player) -> {
        for (SendTardis callback : callbacks) {
            callback.send(tardis, player);
        }
    });
    public static final Event<UnloadTardis> UNLOAD_TARDIS = EventFactory.createArrayBacked(UnloadTardis.class, callbacks -> (tardis, chunk) -> {
        for (UnloadTardis callback : callbacks) {
            callback.unload(tardis, chunk);
        }
    });
    public static final Event<ReconfigureDesktop> RECONFIGURE_DESKTOP = EventFactory.createArrayBacked(ReconfigureDesktop.class, callbacks -> tardis -> {
        for (ReconfigureDesktop callback : callbacks) {
            callback.reconfigure(tardis);
        }
    });
    public static final Event<OnExteriorChange> EXTERIOR_CHANGE = EventFactory.createArrayBacked(OnExteriorChange.class, callbacks -> tardis -> {
        for (OnExteriorChange callback : callbacks) {
            callback.onChange(tardis);
        }
    });
    public static final Event<OnForcedEntry> FORCED_ENTRY = EventFactory.createArrayBacked(OnForcedEntry.class, callbacks -> (tardis, player) -> {
        for (OnForcedEntry callback : callbacks) {
            callback.onForcedEntry(tardis, player);
        }
    });
    public static final Event<OnSubSystemBreak> SUBSYSTEM_BREAK = EventFactory.createArrayBacked(OnSubSystemBreak.class, callbacks -> system -> {
        for (OnSubSystemBreak callback : callbacks) {
            callback.onBreak(system);
        }
    });
    public static final Event<OnSubSystemRepair> SUBSYSTEM_REPAIR = EventFactory.createArrayBacked(OnSubSystemRepair.class, callbacks -> system -> {
        for (OnSubSystemRepair callback : callbacks) {
            callback.onRepair(system);
        }
    });
    public static final Event<OnSubSystemEnable> SUBSYSTEM_ENABLE = EventFactory.createArrayBacked(OnSubSystemEnable.class, callbacks -> system -> {
        for (OnSubSystemEnable callback : callbacks) {
            callback.onEnable(system);
        }
    });
    public static final Event<OnSubSystemDisable> SUBSYSTEM_DISABLE = EventFactory.createArrayBacked(OnSubSystemDisable.class, callbacks -> system -> {
        for (OnSubSystemDisable callback : callbacks) {
            callback.onDisable(system);
        }
    });
    public static final Event<OnEnginesPhase> ENGINES_PHASE = EventFactory.createArrayBacked(OnEnginesPhase.class, callbacks -> system -> {
        for (OnEnginesPhase callback : callbacks) {
            callback.onPhase(system);
        }
    });
    public static final Event<UseControl> USE_CONTROL = EventFactory.createArrayBacked(UseControl.class, callbacks -> (control, tardis, player, world, console, leftClick) -> {
        for (UseControl callback : callbacks) {
            callback.onUse(control, tardis, player, world, console, leftClick);
        }
    });

    @FunctionalInterface
    public static interface UseControl {
        public void onUse(Control var1, Tardis var2, class_3222 var3, class_3218 var4, class_2338 var5, boolean var6);
    }

    @FunctionalInterface
    public static interface OnEnginesPhase {
        public void onPhase(EngineSystem var1);
    }

    @FunctionalInterface
    public static interface OnSubSystemDisable {
        public void onDisable(SubSystem var1);
    }

    @FunctionalInterface
    public static interface OnSubSystemEnable {
        public void onEnable(SubSystem var1);
    }

    @FunctionalInterface
    public static interface OnSubSystemRepair {
        public void onRepair(DurableSubSystem var1);
    }

    @FunctionalInterface
    public static interface OnSubSystemBreak {
        public void onBreak(DurableSubSystem var1);
    }

    @FunctionalInterface
    public static interface OnForcedEntry {
        public void onForcedEntry(Tardis var1, class_1297 var2);
    }

    @FunctionalInterface
    public static interface OnExteriorChange {
        public void onChange(Tardis var1);
    }

    @FunctionalInterface
    public static interface ReconfigureDesktop {
        public void reconfigure(Tardis var1);
    }

    @FunctionalInterface
    public static interface UnloadTardis {
        public void unload(class_3222 var1, class_1923 var2);
    }

    @FunctionalInterface
    public static interface SendTardis {
        public void send(Tardis var1, class_3222 var2);
    }

    @FunctionalInterface
    public static interface SyncTardis {
        public void sync(class_3222 var1, class_1923 var2);
    }

    @FunctionalInterface
    public static interface Siege {
        public void onSiege(Tardis var1, boolean var2);
    }

    @FunctionalInterface
    public static interface Shields {
        public void onShields(Tardis var1, boolean var2, boolean var3);
    }

    @FunctionalInterface
    public static interface BreakDoor {
        public void onBreak(Tardis var1, DirectedBlockPos var2);
    }

    @FunctionalInterface
    public static interface LeaveTardis {
        public void onLeave(Tardis var1, class_1297 var2);
    }

    @FunctionalInterface
    public static interface EnterTardis {
        public void onEnter(Tardis var1, class_1297 var2);
    }

    @FunctionalInterface
    public static interface DoorUsed {
        public DoorHandler.InteractionResult onDoorUsed(Tardis var1, class_3222 var2);
    }

    @FunctionalInterface
    public static interface UseDoor {
        public DoorHandler.InteractionResult onUseDoor(Tardis var1, class_3218 var2, class_3218 var3, @Nullable class_3222 var4, @Nullable class_2338 var5);
    }

    @FunctionalInterface
    public static interface MoveEngine {
        public void onMove(ServerTardis var1, @Nullable class_2338 var2, @Nullable class_2338 var3);
    }

    @FunctionalInterface
    public static interface MoveDoor {
        public void onMove(ServerTardis var1, @Nullable DirectedBlockPos var2, @Nullable DirectedBlockPos var3);
    }

    @FunctionalInterface
    public static interface CloseDoor {
        public void onClose(Tardis var1);
    }

    @FunctionalInterface
    public static interface OpenDoor {
        public void onOpen(Tardis var1);
    }

    @FunctionalInterface
    public static interface UseBackupPower {
        public void onUse(Tardis var1, double var2);
    }

    @FunctionalInterface
    public static interface RegainPower {
        public void onRegainPower(Tardis var1);
    }

    @FunctionalInterface
    public static interface LosePower {
        public void onLosePower(Tardis var1);
    }

    @FunctionalInterface
    public static interface NoFuel {
        public void onNoFuel(Tardis var1);
    }

    @FunctionalInterface
    public static interface LandingPadAdjust {
        public void onLandingPadAdjust(Tardis var1, LandingPadSpot var2);
    }

    @FunctionalInterface
    public static interface Crash {
        public void onCrash(Tardis var1);
    }

    @FunctionalInterface
    public static interface Landed {
        public void onLanded(Tardis var1);
    }

    @FunctionalInterface
    public static interface BeforeLand {
        public Result<CachedDirectedGlobalPos> onLanded(Tardis var1, CachedDirectedGlobalPos var2);
    }

    public record Result<T>(Interaction type, Optional<T> t) {
        public Result(Interaction inter) {
            this(inter, Optional.empty());
        }

        public Result(T t) {
            this(Interaction.PASS, t);
        }

        public Result(Interaction inter, T t) {
            this(inter, Optional.ofNullable(t));
        }

        public static <T> Result<T> success() {
            return new Result<T>(Interaction.SUCCESS);
        }

        public static <T> Result<T> fail() {
            return new Result<T>(Interaction.FAIL);
        }

        public static <T> Result<T> pass() {
            return new Result<T>(Interaction.PASS);
        }

        public Optional<T> value() {
            return this.t;
        }
    }

    public static enum Interaction {
        SUCCESS,
        FAIL,
        PASS;

    }

    @FunctionalInterface
    public static interface StartFalling {
        public void onStartFall(Tardis var1);
    }

    @FunctionalInterface
    public static interface Mat {
        public Interaction onMat(ServerTardis var1);
    }

    @FunctionalInterface
    public static interface FinishFlight {
        public Interaction onFinish(ServerTardis var1);
    }

    @FunctionalInterface
    public static interface EnterFlight {
        public void onFlight(Tardis var1);
    }

    @FunctionalInterface
    public static interface Demat {
        public Interaction onDemat(Tardis var1);
    }
}

