/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.api.tardis.link;

import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.tardis.manager.ClientTardisManager;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisManager;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public abstract class LinkableItem
extends class_1792 {
    private final boolean showTooltip;
    private final String path;

    public LinkableItem(class_1792.class_1793 settings, boolean showTooltip) {
        this(settings, "tardis", showTooltip);
    }

    public LinkableItem(class_1792.class_1793 settings, String path, boolean showTooltip) {
        super(settings);
        this.path = path;
        this.showTooltip = showTooltip;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        this.handleTooltip(stack, tooltip);
        super.method_7851(stack, world, tooltip, context);
    }

    private void handleTooltip(class_1799 stack, List<class_2561> tooltip) {
        if (!this.showTooltip) {
            return;
        }
        UUID id = this.getTardisId(stack);
        if (id == null) {
            return;
        }
        if (!class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.ait.remoteitem.holdformoreinfo").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
            return;
        }
        ClientTardisManager.getInstance().getTardis(id, (ClientTardis tardis) -> {
            if (tardis != null) {
                tooltip.add((class_2561)class_2561.method_43470((String)"TARDIS: ").method_27692(class_124.field_1078));
                tooltip.add((class_2561)class_2561.method_43470((String)("> " + tardis.stats().getName())));
                tooltip.add((class_2561)class_2561.method_43470((String)("> " + tardis.getUuid().toString().substring(0, 8))).method_27692(class_124.field_1063));
            }
        });
    }

    public void link(class_1799 stack, Tardis tardis) {
        this.link(stack, tardis.getUuid());
    }

    public void link(class_1799 stack, UUID uuid) {
        stack.method_7948().method_25927(this.path, uuid);
    }

    public void unlink(class_1799 stack) {
        stack.method_7948().method_10551(this.path);
    }

    public boolean isLinked(class_1799 stack) {
        return stack.method_7948().method_10545(this.path);
    }

    public boolean isOf(class_1799 stack, Tardis tardis) {
        if (tardis == null) {
            return false;
        }
        return tardis.getUuid().equals(this.getTardisId(stack));
    }

    public UUID getTardisId(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        class_2520 element = nbt.method_10580(this.path);
        if (element == null) {
            return null;
        }
        if (element.method_10711() == 8) {
            UUID converted = UUID.fromString(element.method_10714());
            nbt.method_25927(this.path, converted);
            return converted;
        }
        return class_2512.method_25930((class_2520)element);
    }

    public Tardis getTardis(class_1937 world, class_1799 stack) {
        if (world == null) {
            return null;
        }
        UUID tardisId = this.getTardisId(stack);
        if (tardisId == null) {
            return null;
        }
        return TardisManager.with(world, (o, manager) -> manager.demandTardis(o, tardisId));
    }

    public static <T> T apply(class_1799 stack, BiFunction<LinkableItem, class_1799, T> f) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof LinkableItem)) {
            throw new IllegalArgumentException("Not a linkable!");
        }
        LinkableItem linkable = (LinkableItem)class_17922;
        return f.apply(linkable, stack);
    }

    public static void accept(class_1799 stack, BiConsumer<LinkableItem, class_1799> c) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof LinkableItem)) {
            throw new IllegalArgumentException("Not a linkable!");
        }
        LinkableItem linkable = (LinkableItem)class_17922;
        c.accept(linkable, stack);
    }

    public static void linkStatic(class_1799 stack, Tardis tardis) {
        LinkableItem.accept(stack, (i, s) -> i.link((class_1799)s, tardis));
    }

    public static void linkStatic(class_1799 stack, UUID id) {
        LinkableItem.accept(stack, (i, s) -> i.link((class_1799)s, id));
    }

    public static boolean isLinkedStatic(class_1799 stack) {
        return LinkableItem.apply(stack, LinkableItem::isLinked);
    }

    public static boolean isOfStatic(class_1799 stack, Tardis tardis) {
        return LinkableItem.apply(stack, (i, s) -> i.isOf((class_1799)s, tardis));
    }

    public static UUID getTardisIdStatic(class_1799 stack) {
        return LinkableItem.apply(stack, LinkableItem::getTardisId);
    }

    public static Tardis getTardisStatic(class_1937 world, class_1799 stack) {
        return LinkableItem.apply(stack, (i, s) -> i.getTardis(world, (class_1799)s));
    }
}

