/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.api.tardis.link;

import dev.amble.ait.api.tardis.link.v2.Linkable;
import dev.amble.ait.api.tardis.link.v2.TardisRef;
import dev.amble.ait.core.tardis.Tardis;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;

public abstract class LinkableLivingEntity
extends class_1309
implements Linkable {
    public static final class_2940<Optional<UUID>> TARDIS_ID = class_2945.method_12791(LinkableLivingEntity.class, (class_2941)class_2943.field_13313);
    private TardisRef cache;

    protected LinkableLivingEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        UUID id = nbt.method_25926("Tardis");
        if (id != null) {
            this.link(id);
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.tardisId().ifPresent(id -> nbt.method_25927("Tardis", id));
    }

    @Override
    public void link(Tardis tardis) {
        this.link(tardis.getUuid());
    }

    @Override
    public void link(UUID id) {
        this.field_6011.method_12778(TARDIS_ID, Optional.of(id));
        this.createCache(id);
    }

    private void reloadCache() {
        UUID id = this.tardisId().orElse(null);
        if (id == null) {
            return;
        }
        this.createCache(id);
    }

    private void createCache(UUID id) {
        this.cache = TardisRef.createAs((class_1297)this, id);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TARDIS_ID, Optional.empty());
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        if (TARDIS_ID.equals(data)) {
            this.reloadCache();
        }
    }

    @Override
    public TardisRef tardis() {
        if (this.cache != null) {
            return this.cache;
        }
        this.reloadCache();
        return this.cache;
    }

    private Optional<UUID> tardisId() {
        return (Optional)this.field_6011.method_12789(TARDIS_ID);
    }
}

