/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.api.tardis.link.v2;

import dev.amble.ait.api.tardis.Disposable;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisManager;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2586;

public class TardisRef
implements Disposable {
    private final LoadFunc load;
    private UUID id;
    private Tardis cached;

    public TardisRef(UUID id, LoadFunc load) {
        this.id = id;
        this.load = load;
    }

    public TardisRef(Tardis tardis, LoadFunc load) {
        if (tardis != null) {
            this.id = tardis.getUuid();
        }
        this.load = load;
        this.cached = tardis;
    }

    public static TardisRef createAs(class_1297 entity, Tardis tardis) {
        return new TardisRef(tardis, real -> TardisManager.with(entity, (o, manager) -> manager.demandTardis(o, (UUID)real)));
    }

    public static TardisRef createAs(class_1297 entity, UUID uuid) {
        return new TardisRef(uuid, real -> TardisManager.with(entity, (o, manager) -> manager.demandTardis(o, (UUID)real)));
    }

    public static TardisRef createAs(class_2586 blockEntity, Tardis tardis) {
        return new TardisRef(tardis, real -> TardisManager.with(blockEntity, (o, manager) -> manager.demandTardis(o, (UUID)real)));
    }

    public static TardisRef createAs(class_2586 blockEntity, UUID uuid) {
        return new TardisRef(uuid, real -> TardisManager.with(blockEntity, (o, manager) -> manager.demandTardis(o, (UUID)real)));
    }

    public static TardisRef createAs(class_1937 world, Tardis tardis) {
        return new TardisRef(tardis, real -> TardisManager.with(world, (o, manager) -> manager.demandTardis(o, (UUID)real)));
    }

    public static TardisRef createAs(class_1937 world, UUID uuid) {
        return new TardisRef(uuid, real -> TardisManager.with(world, (o, manager) -> manager.demandTardis(o, (UUID)real)));
    }

    public Tardis get() {
        if (this.cached != null && !this.shouldInvalidate()) {
            return this.cached;
        }
        if (this.id == null) {
            return null;
        }
        this.cached = (Tardis)this.load.apply(this.id);
        return this.cached;
    }

    private boolean shouldInvalidate() {
        Disposable disposable;
        Tardis tardis = this.cached;
        return tardis instanceof Disposable && (disposable = (Disposable)((Object)tardis)).isAged();
    }

    public UUID getId() {
        return this.id;
    }

    public boolean isPresent() {
        return this.get() != null;
    }

    public boolean isEmpty() {
        return this.get() == null;
    }

    public <T> Optional<T> apply(Function<Tardis, T> consumer) {
        if (this.isPresent()) {
            return Optional.of(consumer.apply(this.cached));
        }
        return Optional.empty();
    }

    public void ifPresent(Consumer<Tardis> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.get());
        }
    }

    @Override
    public void dispose() {
        this.cached = null;
    }

    public boolean contains(Tardis tardis) {
        return this.get() == tardis;
    }

    public static interface LoadFunc
    extends Function<UUID, Tardis> {
    }
}

