/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client;

import com.mojang.brigadier.CommandDispatcher;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.boti.BOTI;
import dev.amble.ait.client.boti.PaintingBOTI;
import dev.amble.ait.client.boti.RiftBOTI;
import dev.amble.ait.client.boti.TardisDoorBOTI;
import dev.amble.ait.client.boti.TardisExteriorBOTI;
import dev.amble.ait.client.commands.ConfigCommand;
import dev.amble.ait.client.commands.DebugCommand;
import dev.amble.ait.client.config.AITClientConfig;
import dev.amble.ait.client.data.ClientLandingManager;
import dev.amble.ait.client.models.AnimatedModel;
import dev.amble.ait.client.models.boti.BotiPortalModel;
import dev.amble.ait.client.models.decoration.GallifreyFallsModel;
import dev.amble.ait.client.models.decoration.PaintingFrameModel;
import dev.amble.ait.client.models.decoration.RiftModel;
import dev.amble.ait.client.models.decoration.TrenzalorePaintingModel;
import dev.amble.ait.client.models.exteriors.ExteriorModel;
import dev.amble.ait.client.overlays.ExteriorAxeOverlay;
import dev.amble.ait.client.overlays.FabricatorOverlay;
import dev.amble.ait.client.overlays.RWFOverlay;
import dev.amble.ait.client.overlays.SonicOverlay;
import dev.amble.ait.client.renderers.SonicRendering;
import dev.amble.ait.client.renderers.TardisStar;
import dev.amble.ait.client.renderers.consoles.ConsoleGeneratorRenderer;
import dev.amble.ait.client.renderers.consoles.ConsoleRenderer;
import dev.amble.ait.client.renderers.coral.CoralRenderer;
import dev.amble.ait.client.renderers.decoration.FlagBlockEntityRenderer;
import dev.amble.ait.client.renderers.decoration.PlaqueRenderer;
import dev.amble.ait.client.renderers.decoration.SnowGlobeRenderer;
import dev.amble.ait.client.renderers.doors.DoorRenderer;
import dev.amble.ait.client.renderers.entities.ControlEntityRenderer;
import dev.amble.ait.client.renderers.entities.FallingTardisRenderer;
import dev.amble.ait.client.renderers.entities.FlightTardisRenderer;
import dev.amble.ait.client.renderers.entities.GallifreyanPaintingEntityRenderer;
import dev.amble.ait.client.renderers.entities.RiftEntityRenderer;
import dev.amble.ait.client.renderers.entities.TrenzalorePaintingEntityRenderer;
import dev.amble.ait.client.renderers.exteriors.ExteriorRenderer;
import dev.amble.ait.client.renderers.machines.ArtronCollectorRenderer;
import dev.amble.ait.client.renderers.machines.AstralMapRenderer;
import dev.amble.ait.client.renderers.machines.EngineRenderer;
import dev.amble.ait.client.renderers.machines.FabricatorRenderer;
import dev.amble.ait.client.renderers.machines.FoodMachineRenderer;
import dev.amble.ait.client.renderers.machines.GenericSubSystemRenderer;
import dev.amble.ait.client.renderers.machines.PowerConverterRenderer;
import dev.amble.ait.client.renderers.machines.WaypointBankBlockEntityRenderer;
import dev.amble.ait.client.renderers.monitors.MonitorRenderer;
import dev.amble.ait.client.renderers.monitors.WallMonitorRenderer;
import dev.amble.ait.client.renderers.sky.MarsSkyProperties;
import dev.amble.ait.client.screens.AstralMapScreen;
import dev.amble.ait.client.screens.BlueprintFabricatorScreen;
import dev.amble.ait.client.screens.MonitorScreen;
import dev.amble.ait.client.sonic.SonicModelLoader;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.tardis.manager.ClientTardisManager;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.compat.DependencyChecker;
import dev.amble.ait.core.AITBlockEntityTypes;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITDimensions;
import dev.amble.ait.core.AITEntityTypes;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITKeyBinds;
import dev.amble.ait.core.blockentities.ConsoleGeneratorBlockEntity;
import dev.amble.ait.core.blockentities.DoorBlockEntity;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;
import dev.amble.ait.core.blocks.AstralMapBlock;
import dev.amble.ait.core.blocks.ExteriorBlock;
import dev.amble.ait.core.drinks.DrinkRegistry;
import dev.amble.ait.core.drinks.DrinkUtil;
import dev.amble.ait.core.entities.BOTIPaintingEntity;
import dev.amble.ait.core.entities.RiftEntity;
import dev.amble.ait.core.item.ChargedZeitonCrystalItem;
import dev.amble.ait.core.item.HammerItem;
import dev.amble.ait.core.item.HypercubeItem;
import dev.amble.ait.core.item.InteriorTeleporterItem;
import dev.amble.ait.core.item.KeyItem;
import dev.amble.ait.core.item.PersonalityMatrixItem;
import dev.amble.ait.core.item.WaypointItem;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.schema.console.ConsoleTypeSchema;
import dev.amble.ait.data.schema.exterior.ClientExteriorVariantSchema;
import dev.amble.ait.module.ModuleRegistry;
import dev.amble.ait.module.gun.core.item.BaseGunItem;
import dev.amble.ait.registry.impl.SonicRegistry;
import dev.amble.ait.registry.impl.console.ConsoleRegistry;
import dev.amble.ait.registry.impl.console.variant.ClientConsoleVariantRegistry;
import dev.amble.ait.registry.impl.door.ClientDoorRegistry;
import dev.amble.ait.registry.impl.exterior.ClientExteriorVariantRegistry;
import dev.amble.lib.register.AmbleRegistries;
import dev.amble.lib.register.Registry;
import java.util.ArrayList;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.client.player.ClientPreAttackCallback;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1944;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5272;
import net.minecraft.class_5294;
import net.minecraft.class_5616;
import net.minecraft.class_638;
import net.minecraft.class_675;
import net.minecraft.class_765;
import net.minecraft.class_7718;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class AITModClient
implements ClientModInitializer {
    public static AITClientConfig CONFIG;

    public void onInitializeClient() {
        AITModClient.resourcepackRegister();
        AITClientConfig.INSTANCE.load();
        CONFIG = (AITClientConfig)AITClientConfig.INSTANCE.instance();
        AmbleRegistries.getInstance().registerAll(new Registry[]{SonicRegistry.getInstance(), DrinkRegistry.getInstance(), ClientExteriorVariantRegistry.getInstance(), ClientConsoleVariantRegistry.getInstance(), ClientDoorRegistry.getInstance()});
        ClientTardisManager.init();
        ModuleRegistry.instance().onClientInit();
        AITModClient.setupBlockRendering();
        AITModClient.blockEntityRendererRegister();
        AITModClient.entityRenderRegister();
        this.chargedZeitonCrystalPredicate();
        AITModClient.waypointPredicate();
        AITModClient.hammerPredicate();
        AITModClient.siegeItemPredicate();
        AITModClient.adventItemPredicates();
        this.registerItemColors();
        this.registerParticles();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            ConfigCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher);
            DebugCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher);
        });
        AITKeyBinds.init();
        ClientLandingManager.init();
        HudRenderCallback.EVENT.register((Object)new SonicOverlay());
        HudRenderCallback.EVENT.register((Object)new RWFOverlay());
        HudRenderCallback.EVENT.register((Object)new FabricatorOverlay());
        HudRenderCallback.EVENT.register((Object)new ExteriorAxeOverlay());
        ClientPreAttackCallback.EVENT.register((client, player, clickCount) -> player.method_6047().method_7909() instanceof BaseGunItem);
        if (DependencyChecker.hasIris()) {
            WorldRenderEvents.END.register(this::exteriorBOTI);
            WorldRenderEvents.END.register(this::doorBOTI);
            WorldRenderEvents.END.register(this::gallifreyanBOTI);
            WorldRenderEvents.END.register(this::trenzaloreBOTI);
            WorldRenderEvents.END.register(this::riftBOTI);
        } else {
            WorldRenderEvents.AFTER_ENTITIES.register(this::exteriorBOTI);
            WorldRenderEvents.AFTER_ENTITIES.register(this::doorBOTI);
            WorldRenderEvents.AFTER_ENTITIES.register(this::gallifreyanBOTI);
            WorldRenderEvents.AFTER_ENTITIES.register(this::trenzaloreBOTI);
            WorldRenderEvents.AFTER_ENTITIES.register(this::riftBOTI);
        }
        DimensionRenderingRegistry.registerDimensionEffects((class_2960)AITDimensions.MARS.method_29177(), (class_5294)new MarsSkyProperties());
        WorldRenderEvents.BEFORE_ENTITIES.register(context -> {
            ClientTardis tardis = ClientTardisUtil.getCurrentTardis();
            if (tardis == null) {
                return;
            }
            TardisStar.render(context, tardis);
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)AITMod.OPEN_SCREEN, (client, handler, buf, responseSender) -> {
            int id = buf.readInt();
            class_437 screen = AITModClient.screenFromId(id);
            if (screen == null) {
                return;
            }
            client.execute(() -> client.method_29970(screen));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)AITMod.OPEN_SCREEN_TARDIS, (client, handler, buf, responseSender) -> {
            int id = buf.readInt();
            UUID uuid = buf.method_10790();
            ClientTardisManager.getInstance().getTardis(uuid, tardis -> {
                class_437 screen = AITModClient.screenFromId(id, tardis);
                if (screen == null) {
                    return;
                }
                client.execute(() -> client.method_29970(screen));
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)AITMod.OPEN_SCREEN_CONSOLE, (client, handler, buf, responseSender) -> {
            int id = buf.readInt();
            UUID uuid = buf.method_10790();
            class_2338 console = buf.method_10811();
            ClientTardisManager.getInstance().getTardis(uuid, tardis -> {
                class_437 screen = AITModClient.screenFromId(id, tardis, console);
                if (screen == null) {
                    return;
                }
                client.execute(() -> client.method_29970(screen));
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ConsoleGeneratorBlockEntity.SYNC_TYPE, (client, handler, buf, responseSender) -> {
            if (client.field_1687 == null) {
                return;
            }
            String id = buf.method_19772();
            ConsoleTypeSchema type = (ConsoleTypeSchema)ConsoleRegistry.getInstance().get(class_2960.method_12829((String)id));
            class_2338 consolePos = buf.method_10811();
            class_2586 patt0$temp = client.field_1687.method_8321(consolePos);
            if (patt0$temp instanceof ConsoleGeneratorBlockEntity) {
                ConsoleGeneratorBlockEntity console = (ConsoleGeneratorBlockEntity)patt0$temp;
                console.setConsoleSchema(type.id());
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ConsoleGeneratorBlockEntity.SYNC_VARIANT, (client, handler, buf, responseSender) -> {
            if (client.field_1687 == null) {
                return;
            }
            class_2960 id = class_2960.method_12829((String)buf.method_19772());
            class_2338 consolePos = buf.method_10811();
            class_2586 patt0$temp = client.field_1687.method_8321(consolePos);
            if (patt0$temp instanceof ConsoleGeneratorBlockEntity) {
                ConsoleGeneratorBlockEntity console = (ConsoleGeneratorBlockEntity)patt0$temp;
                console.setVariant(id);
            }
        });
        WorldRenderEvents.END.register(context -> SonicRendering.getInstance().renderWorld(context));
        HudRenderCallback.EVENT.register((context, delta) -> SonicRendering.getInstance().renderGui(context, delta));
        SonicModelLoader.init();
        AstralMapBlock.registerSyncListener();
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> BOTI.tryWarn(client));
    }

    public static class_437 screenFromId(int id) {
        return AITModClient.screenFromId(id, null, null);
    }

    public static class_437 screenFromId(int id, @Nullable ClientTardis tardis) {
        return AITModClient.screenFromId(id, tardis, null);
    }

    public static class_437 screenFromId(int id, @Nullable ClientTardis tardis, @Nullable class_2338 console) {
        return switch (id) {
            case 0 -> new MonitorScreen(tardis, console);
            case 1 -> new BlueprintFabricatorScreen();
            case 2 -> new AstralMapScreen();
            default -> null;
        };
    }

    public void chargedZeitonCrystalPredicate() {
        class_5272.method_27879((class_1792)AITItems.CHARGED_ZEITON_CRYSTAL, (class_2960)new class_2960("fuel"), (itemStack, clientWorld, livingEntity, integer) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            class_1792 patt0$temp = itemStack.method_7909();
            if (patt0$temp instanceof ChargedZeitonCrystalItem) {
                ChargedZeitonCrystalItem item = (ChargedZeitonCrystalItem)patt0$temp;
                float value = (float)(item.getCurrentFuel(itemStack) / item.getMaxFuel(itemStack));
                if (value > 0.0f && value < 0.5f) {
                    return 0.5f;
                }
                if (value > 0.5f && value < 1.0f) {
                    return 1.0f;
                }
                return 0.0f;
            }
            return 0.0f;
        });
    }

    public static void waypointPredicate() {
        class_5272.method_27879((class_1792)AITItems.WAYPOINT_CARTRIDGE, (class_2960)new class_2960("type"), (stack, clientWorld, livingEntity, integer) -> stack.method_7948().method_10545("pos") ? 1.0f : 0.0f);
    }

    public static void hammerPredicate() {
        class_5272.method_27879((class_1792)AITItems.HAMMER, (class_2960)new class_2960("toymakered"), (itemStack, clientWorld, livingEntity, integer) -> {
            if (itemStack.method_7909() instanceof HammerItem) {
                if (itemStack.method_7964().getString().equalsIgnoreCase("Toymaker Hammer")) {
                    return 1.0f;
                }
                return 0.0f;
            }
            return 0.0f;
        });
    }

    public static void siegeItemPredicate() {
        class_5272.method_27879((class_1792)AITItems.HAMMER, (class_2960)new class_2960("bricked"), (itemStack, clientWorld, livingEntity, integer) -> {
            if (itemStack.method_7948().method_10545("siege_current_texture")) {
                return itemStack.method_7948().method_10550("siege_current_texture");
            }
            return 0.0f;
        });
    }

    public static void adventItemPredicates() {
        class_5272.method_27879((class_1792)AITItems.HYPERCUBE, (class_2960)new class_2960("advent"), (itemStack, clientWorld, livingEntity, integer) -> {
            if (itemStack.method_7909() instanceof HypercubeItem) {
                return AITItems.isUnlockedOnThisDay(0, 1) ? 1.0f : 0.0f;
            }
            return 0.0f;
        });
        class_5272.method_27879((class_1792)AITItems.HAZANDRA, (class_2960)new class_2960("advent"), (itemStack, clientWorld, livingEntity, integer) -> {
            if (itemStack.method_7909() instanceof InteriorTeleporterItem) {
                return AITItems.isUnlockedOnThisDay(11, 28) ? 1.0f : 0.0f;
            }
            return 0.0f;
        });
        class_5272.method_27879((class_1792)AITItems.IRON_KEY, (class_2960)new class_2960("advent"), (itemStack, clientWorld, livingEntity, integer) -> {
            if (itemStack.method_7909() instanceof KeyItem) {
                return AITItems.isUnlockedOnThisDay(11, 26) ? 1.0f : 0.0f;
            }
            return 0.0f;
        });
        class_5272.method_27879((class_1792)AITItems.GOLD_KEY, (class_2960)new class_2960("advent"), (itemStack, clientWorld, livingEntity, integer) -> {
            if (itemStack.method_7909() instanceof KeyItem) {
                return AITItems.isUnlockedOnThisDay(11, 26) ? 1.0f : 0.0f;
            }
            return 0.0f;
        });
        class_5272.method_27879((class_1792)AITItems.NETHERITE_KEY, (class_2960)new class_2960("advent"), (itemStack, clientWorld, livingEntity, integer) -> {
            if (itemStack.method_7909() instanceof KeyItem) {
                return AITItems.isUnlockedOnThisDay(11, 26) ? 1.0f : 0.0f;
            }
            return 0.0f;
        });
        class_5272.method_27879((class_1792)AITItems.CLASSIC_KEY, (class_2960)new class_2960("advent"), (itemStack, clientWorld, livingEntity, integer) -> {
            if (itemStack.method_7909() instanceof KeyItem) {
                return AITItems.isUnlockedOnThisDay(11, 26) ? 1.0f : 0.0f;
            }
            return 0.0f;
        });
    }

    public static void blockEntityRendererRegister() {
        class_5616.method_32144(AITBlockEntityTypes.CONSOLE_BLOCK_ENTITY_TYPE, ConsoleRenderer::new);
        class_5616.method_32144(AITBlockEntityTypes.CONSOLE_GENERATOR_ENTITY_TYPE, ConsoleGeneratorRenderer::new);
        class_5616.method_32144(AITBlockEntityTypes.EXTERIOR_BLOCK_ENTITY_TYPE, ExteriorRenderer::new);
        class_5616.method_32144(AITBlockEntityTypes.DOOR_BLOCK_ENTITY_TYPE, DoorRenderer::new);
        class_5616.method_32144(AITBlockEntityTypes.CORAL_BLOCK_ENTITY_TYPE, CoralRenderer::new);
        class_5616.method_32144(AITBlockEntityTypes.MONITOR_BLOCK_ENTITY_TYPE, MonitorRenderer::new);
        class_5616.method_32144(AITBlockEntityTypes.ARTRON_COLLECTOR_BLOCK_ENTITY_TYPE, ArtronCollectorRenderer::new);
        class_5616.method_32144(AITBlockEntityTypes.PLAQUE_BLOCK_ENTITY_TYPE, PlaqueRenderer::new);
        class_5616.method_32144(AITBlockEntityTypes.WALL_MONITOR_BLOCK_ENTITY_TYPE, WallMonitorRenderer::new);
        class_5616.method_32144(AITBlockEntityTypes.ENGINE_BLOCK_ENTITY_TYPE, EngineRenderer::new);
        class_5616.method_32144(AITBlockEntityTypes.FABRICATOR_BLOCK_ENTITY_TYPE, FabricatorRenderer::new);
        class_5616.method_32144(AITBlockEntityTypes.WAYPOINT_BANK_BLOCK_ENTITY_TYPE, WaypointBankBlockEntityRenderer::new);
        class_5616.method_32144(AITBlockEntityTypes.FLAG_BLOCK_ENTITY_TYPE, FlagBlockEntityRenderer::new);
        class_5616.method_32144(AITBlockEntityTypes.GENERIC_SUBSYSTEM_BLOCK_TYPE, GenericSubSystemRenderer::new);
        class_5616.method_32144(AITBlockEntityTypes.POWER_CONVERTER_BLOCK_TYPE, PowerConverterRenderer::new);
        class_5616.method_32144(AITBlockEntityTypes.FOOD_MACHINE_BLOCK_ENTITY_TYPE, FoodMachineRenderer::new);
        class_5616.method_32144(AITBlockEntityTypes.ASTRAL_MAP, AstralMapRenderer::new);
        if (AITItems.isUnlockedOnThisDay(11, 30)) {
            class_5616.method_32144(AITBlockEntityTypes.SNOW_GLOBE_BLOCK_ENTITY_TYPE, SnowGlobeRenderer::new);
        }
    }

    public static void entityRenderRegister() {
        EntityRendererRegistry.register(AITEntityTypes.CONTROL_ENTITY_TYPE, ControlEntityRenderer::new);
        EntityRendererRegistry.register(AITEntityTypes.FALLING_TARDIS_TYPE, FallingTardisRenderer::new);
        EntityRendererRegistry.register(AITEntityTypes.FLIGHT_TARDIS_TYPE, FlightTardisRenderer::new);
        EntityRendererRegistry.register(AITEntityTypes.GALLIFREY_FALLS_PAINTING_ENTITY_TYPE, GallifreyanPaintingEntityRenderer::new);
        EntityRendererRegistry.register(AITEntityTypes.TRENZALORE_PAINTING_ENTITY_TYPE, TrenzalorePaintingEntityRenderer::new);
        EntityRendererRegistry.register(AITEntityTypes.RIFT_ENTITY, RiftEntityRenderer::new);
    }

    public static void setupBlockRendering() {
        BlockRenderLayerMap map = BlockRenderLayerMap.INSTANCE;
        map.putBlock(AITBlocks.ZEITON_BLOCK, class_1921.method_23581());
        map.putBlock(AITBlocks.BUDDING_ZEITON, class_1921.method_23581());
        map.putBlock(AITBlocks.ENGINE_BLOCK, class_1921.method_23581());
        map.putBlock(AITBlocks.ZEITON_CLUSTER, class_1921.method_23581());
        map.putBlock(AITBlocks.LARGE_ZEITON_BUD, class_1921.method_23581());
        map.putBlock(AITBlocks.MEDIUM_ZEITON_BUD, class_1921.method_23581());
        map.putBlock(AITBlocks.SMALL_ZEITON_BUD, class_1921.method_23581());
        map.putBlock(AITBlocks.MACHINE_CASING, class_1921.method_23581());
        map.putBlock(AITBlocks.FABRICATOR, class_1921.method_23583());
        map.putBlock(AITBlocks.ENVIRONMENT_PROJECTOR, class_1921.method_23583());
        map.putBlock(AITBlocks.WAYPOINT_BANK, class_1921.method_23581());
        if (AITItems.isUnlockedOnThisDay(11, 30)) {
            map.putBlock(AITBlocks.SNOW_GLOBE, class_1921.method_23581());
        }
        map.putBlock(AITBlocks.TARDIS_CORAL_BLOCK, class_1921.method_23581());
        map.putBlock(AITBlocks.TARDIS_CORAL_FAN, class_1921.method_23581());
        map.putBlock(AITBlocks.TARDIS_CORAL_WALL_FAN, class_1921.method_23581());
        map.putBlock(AITBlocks.MATRIX_ENERGIZER, class_1921.method_23581());
    }

    public void registerItemColors() {
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if (tintIndex != 0) {
                return -1;
            }
            PersonalityMatrixItem personalityMatrixItem = (PersonalityMatrixItem)stack.method_7909();
            int[] integers = personalityMatrixItem.getColor(stack);
            return PersonalityMatrixItem.colorToInt(integers[0], integers[1], integers[2]);
        }, (Object[])new class_1935[]{AITItems.PERSONALITY_MATRIX});
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> tintIndex > 0 ? -1 : DrinkUtil.getColor(stack), (Object[])new class_1935[]{AITItems.MUG});
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if (tintIndex != 0) {
                return -1;
            }
            WaypointItem waypoint = (WaypointItem)stack.method_7909();
            return waypoint.method_7800(stack);
        }, (Object[])new class_1935[]{AITItems.WAYPOINT_CARTRIDGE});
    }

    public void registerParticles() {
        ParticleFactoryRegistry.getInstance().register((class_2396)AITMod.CORAL_PARTICLE, class_675.class_676::new);
    }

    private boolean skipBuiltInBOTI() {
        return DependencyChecker.hasPortals() && AITModClient.CONFIG.allowPortalsBoti || !AITModClient.CONFIG.enableTardisBOTI;
    }

    private boolean skipPaintingBOTI() {
        return DependencyChecker.hasPortals() || !AITModClient.CONFIG.enableTardisBOTI;
    }

    public void exteriorBOTI(WorldRenderContext context) {
        if (this.skipBuiltInBOTI()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_638 world = client.field_1687;
        class_4587 stack = context.matrixStack();
        ArrayList<ExteriorBlockEntity> exteriorQueue = new ArrayList<ExteriorBlockEntity>(BOTI.EXTERIOR_RENDER_QUEUE);
        for (ExteriorBlockEntity exterior : exteriorQueue) {
            if (exterior == null || !exterior.isLinked() || exterior.tardis().isEmpty()) continue;
            Tardis tardis = exterior.tardis().get();
            if (tardis == null || tardis.getExterior() == null) {
                return;
            }
            ClientExteriorVariantSchema variant = tardis.getExterior().getVariant().getClient();
            ExteriorModel model = variant.model();
            class_2338 pos = exterior.method_11016();
            stack.method_22903();
            stack.method_22904(0.5, 0.0, 0.5);
            stack.method_22904((double)pos.method_10263() - context.camera().method_19326().method_10216(), (double)pos.method_10264() - context.camera().method_19326().method_10214(), (double)pos.method_10260() - context.camera().method_19326().method_10215());
            stack.method_22905(1.0f, -1.0f, -1.0f);
            stack.method_22907(class_7833.field_40716.rotationDegrees(class_7718.method_45482((int)((Integer)exterior.method_11010().method_11654((class_2769)ExteriorBlock.ROTATION)))));
            int light = world.method_22339(pos);
            if ((tardis.door().getLeftRot() > 0.0f || variant.hasTransparentDoors()) && !tardis.isGrowth()) {
                light = class_765.method_23687((int)world.method_8314(class_1944.field_9282, pos), (int)world.method_8314(class_1944.field_9284, pos));
                TardisExteriorBOTI boti = new TardisExteriorBOTI();
                boti.renderExteriorBoti(exterior, variant, stack, AITMod.id("textures/environment/tardis_sky.png"), model, BotiPortalModel.getTexturedModelData().method_32109(), light);
            }
            stack.method_22909();
        }
        BOTI.EXTERIOR_RENDER_QUEUE.clear();
    }

    public void doorBOTI(WorldRenderContext context) {
        if (this.skipBuiltInBOTI()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_638 world = client.field_1687;
        class_4587 stack = context.matrixStack();
        boolean bl = TardisServerWorld.isTardisDimension(world);
        if (bl) {
            ClientTardis tardis = ClientTardisUtil.getCurrentTardis();
            if (tardis == null || tardis.getDesktop() == null) {
                return;
            }
            ClientExteriorVariantSchema variant = tardis.getExterior().getVariant().getClient();
            AnimatedModel model = variant.getDoor().model();
            for (DoorBlockEntity door : BOTI.DOOR_RENDER_QUEUE) {
                if (door == null) continue;
                class_2338 pos = door.method_11016();
                stack.method_22903();
                stack.method_22904(0.5, 0.0, 0.5);
                stack.method_22904((double)pos.method_10263() - context.camera().method_19326().method_10216(), (double)pos.method_10264() - context.camera().method_19326().method_10214(), (double)pos.method_10260() - context.camera().method_19326().method_10215());
                stack.method_22905(1.0f, -1.0f, -1.0f);
                stack.method_22907(class_7833.field_40716.rotationDegrees(((class_2350)door.method_11010().method_11654((class_2769)class_2323.field_10938)).method_10144()));
                int light = world.method_22339(pos.method_10084());
                if ((tardis.door().getLeftRot() > 0.0f || variant.hasTransparentDoors()) && !tardis.isGrowth()) {
                    light = class_765.method_23687((int)world.method_8314(class_1944.field_9282, pos), (int)world.method_8314(class_1944.field_9284, pos));
                    TardisDoorBOTI.renderInteriorDoorBoti(tardis, door, variant, stack, AITMod.id("textures/environment/tardis_sky.png"), model, BotiPortalModel.getTexturedModelData().method_32109(), light, context.tickDelta());
                }
                stack.method_22909();
            }
            BOTI.DOOR_RENDER_QUEUE.clear();
        }
    }

    public void gallifreyanBOTI(WorldRenderContext context) {
        if (this.skipPaintingBOTI()) {
            return;
        }
        class_310 client = class_310.method_1551();
        GallifreyFallsModel contents = new GallifreyFallsModel(GallifreyFallsModel.getTexturedModelData().method_32109());
        class_2960 frameTex = GallifreyanPaintingEntityRenderer.GALLIFREY_FRAME_TEXTURE;
        class_2960 contentsTex = GallifreyanPaintingEntityRenderer.GALLIFREY_PAINTING_TEXTURE;
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_638 world = client.field_1687;
        class_4587 stack = context.matrixStack();
        for (BOTIPaintingEntity painting : BOTI.GALLIFREYAN_RENDER_QUEUE) {
            if (painting == null) continue;
            class_243 pos = painting.method_19538();
            stack.method_22903();
            stack.method_22904(pos.method_10216() - context.camera().method_19326().method_10216(), pos.method_10214() - context.camera().method_19326().method_10214(), pos.method_10215() - context.camera().method_19326().method_10215());
            stack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
            stack.method_22907(class_7833.field_40716.rotationDegrees(painting.method_43078()));
            stack.method_22904(0.0, -0.5, 0.5);
            PaintingFrameModel frame = new PaintingFrameModel(PaintingFrameModel.getTexturedModelData().method_32109());
            class_2338 blockPos = class_2338.method_49638((class_2374)painting.method_31166(client.method_1488()));
            PaintingBOTI.renderBOTIPainting(stack, frame, class_765.method_23687((int)world.method_8314(class_1944.field_9282, blockPos), (int)world.method_8314(class_1944.field_9284, blockPos)), contents, frameTex, contentsTex);
            stack.method_22909();
        }
        BOTI.GALLIFREYAN_RENDER_QUEUE.clear();
    }

    public void trenzaloreBOTI(WorldRenderContext context) {
        if (this.skipPaintingBOTI()) {
            return;
        }
        class_310 client = class_310.method_1551();
        TrenzalorePaintingModel contents = new TrenzalorePaintingModel(TrenzalorePaintingModel.getTexturedModelData().method_32109());
        class_2960 frameTex = TrenzalorePaintingEntityRenderer.TRENZALORE_FRAME_TEXTURE;
        class_2960 contentsTex = TrenzalorePaintingEntityRenderer.TRENZALORE_PAINTING_TEXTURE;
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_638 world = client.field_1687;
        class_4587 stack = context.matrixStack();
        for (BOTIPaintingEntity painting : BOTI.TRENZALORE_PAINTING_QUEUE) {
            if (painting == null) continue;
            class_243 pos = painting.method_19538();
            stack.method_22903();
            stack.method_22904(pos.method_10216() - context.camera().method_19326().method_10216(), pos.method_10214() - context.camera().method_19326().method_10214(), pos.method_10215() - context.camera().method_19326().method_10215());
            stack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
            stack.method_22907(class_7833.field_40716.rotationDegrees(painting.method_43078()));
            stack.method_22904(0.0, -0.5, 0.5);
            PaintingFrameModel frame = new PaintingFrameModel(PaintingFrameModel.getTexturedModelData().method_32109());
            class_2338 blockPos = class_2338.method_49638((class_2374)painting.method_31166(client.method_1488()));
            PaintingBOTI.renderBOTIPainting(stack, frame, class_765.method_23687((int)world.method_8314(class_1944.field_9282, blockPos), (int)world.method_8314(class_1944.field_9284, blockPos)), contents, frameTex, contentsTex);
            stack.method_22909();
        }
        BOTI.TRENZALORE_PAINTING_QUEUE.clear();
    }

    public void riftBOTI(WorldRenderContext context) {
        if (this.skipPaintingBOTI()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_638 world = client.field_1687;
        class_4587 stack = context.matrixStack();
        for (RiftEntity rift : BOTI.RIFT_RENDERING_QUEUE) {
            if (rift == null) continue;
            class_243 pos = rift.method_19538();
            stack.method_22903();
            stack.method_22904(pos.method_10216() - context.camera().method_19326().method_10216(), pos.method_10214() - context.camera().method_19326().method_10214(), pos.method_10215() - context.camera().method_19326().method_10215());
            stack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            stack.method_22907(class_7833.field_40716.rotationDegrees(rift.method_43078()));
            stack.method_46416(0.0f, 1.0f, 0.0f);
            RiftModel riftModel = new RiftModel(RiftModel.getTexturedModelData().method_32109());
            class_2338 blockPos = class_2338.method_49638((class_2374)rift.method_31166(client.method_1488()));
            RiftBOTI.renderRiftBoti(stack, riftModel, class_765.method_23687((int)world.method_8314(class_1944.field_9282, blockPos), (int)world.method_8314(class_1944.field_9284, blockPos)));
            stack.method_22909();
        }
        BOTI.RIFT_RENDERING_QUEUE.clear();
    }

    public static void resourcepackRegister() {
        FabricLoader.getInstance().getModContainer("ait").ifPresent(modContainer -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)AITMod.id("aitmenu"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED));
    }
}

