/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.data;

import dev.amble.ait.core.tardis.util.NetworkUtil;
import dev.amble.ait.core.world.LandingPadManager;
import dev.amble.ait.data.landing.LandingPadRegion;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class ClientLandingManager {
    private static ClientLandingManager instance;
    private final Map<class_1923, LandingPadRegion> regions = new HashMap<class_1923, LandingPadRegion>();

    public static void init() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> ClientLandingManager.getInstance().invalidate());
        ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> ClientLandingManager.getInstance().request(world, chunk));
        ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> ClientLandingManager.getInstance().remove(chunk.method_12004()));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)LandingPadManager.Network.SYNC, (client, handler, buf, responseSender) -> ClientLandingManager.getInstance().receive(buf));
        instance = new ClientLandingManager();
    }

    public static ClientLandingManager getInstance() {
        return instance;
    }

    @Nullable
    public LandingPadRegion getRegion(class_1923 pos) {
        return this.regions.get(pos);
    }

    public void receive(class_2540 buf) {
        LandingPadManager.Network.Action action = (LandingPadManager.Network.Action)buf.method_10818(LandingPadManager.Network.Action.class);
        if (action == LandingPadManager.Network.Action.CLEAR) {
            this.invalidate();
            return;
        }
        class_1923 chunkPos = buf.method_36133();
        if (action == LandingPadManager.Network.Action.ADD) {
            this.regions.put(chunkPos, NetworkUtil.receive(LandingPadRegion.CODEC, buf));
            return;
        }
        this.regions.remove(chunkPos);
    }

    private void invalidate() {
        this.regions.clear();
    }

    private void remove(class_1923 pos) {
        this.regions.remove(pos);
    }

    private void request(class_5321<class_1937> world, long chunk) {
        class_2487 data = new class_2487();
        data.method_10582("World", world.method_29177().toString());
        data.method_10544("Chunk", chunk);
        class_2540 buf = PacketByteBufs.create();
        buf.method_10794(data);
        ClientPlayNetworking.send((class_2960)LandingPadManager.Network.REQUEST, (class_2540)buf);
    }

    private void request(class_638 world, class_2818 chunk) {
        if (!NetworkUtil.canClientSendPackets()) {
            return;
        }
        this.request((class_5321<class_1937>)world.method_27983(), chunk.method_12004().method_8324());
    }
}

