/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.models.exteriors;

import dev.amble.ait.AITMod;
import dev.amble.ait.client.models.exteriors.ExteriorModel;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.data.datapack.TravelAnimationMap;
import dev.amble.ait.data.schema.door.AnimatedDoor;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.lib.api.Identifiable;
import dev.amble.lib.client.bedrock.BedrockAnimation;
import dev.amble.lib.client.bedrock.BedrockModel;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;

public class BedrockExteriorModel
implements ExteriorModel,
Identifiable {
    private final BedrockModel model;
    private final class_630 root;

    public BedrockExteriorModel(BedrockModel model) {
        this.model = model;
        if (this.model == null) {
            throw new IllegalStateException("Bedrock Model is null. Ensure the resource pack is loaded correctly.");
        }
        this.root = this.model.create().method_32109();
    }

    public class_2960 id() {
        return this.model.id();
    }

    @Override
    public void renderWithAnimations(ClientTardis tardis, ExteriorBlockEntity exterior, class_630 root, class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha, float tickDelta) {
        matrices.method_22903();
        ExteriorVariantSchema schema = tardis.getExterior().getVariant();
        if (schema instanceof AnimatedDoor) {
            AnimatedDoor animDoor = (AnimatedDoor)((Object)schema);
            this.method_32008().method_32088().forEach(class_630::method_41923);
            animDoor.runAnimations(root, matrices, tickDelta, tardis);
        }
        if (schema instanceof TravelAnimationMap.Holder) {
            TravelAnimationMap.Holder holder = (TravelAnimationMap.Holder)((Object)schema);
            this.runTravelAnimations(holder, tardis, tickDelta);
        }
        this.method_2828(matrices, vertices, light, overlay, red, green, blue, alpha);
        matrices.method_22909();
    }

    private void runTravelAnimations(TravelAnimationMap.Holder holder, ClientTardis tardis, float tickDelta) {
        TravelAnimationMap map = holder.getAnimations();
        if (map == null) {
            return;
        }
        TravelHandlerBase.State state = tardis.travel().getState();
        BedrockAnimation anim = map.getAnimation(state);
        if (anim == null) {
            return;
        }
        if (!anim.shouldLoop) {
            if (class_310.method_1551().field_1724.field_6012 % 40 == 0) {
                AITMod.LOGGER.error("Non-looping animations are not supported in BedrockExteriorModel. Animation: {}", (Object)anim.name);
            }
            return;
        }
        float ticks = class_310.method_1551().field_1724.field_6012;
        anim.apply(this.root, (int)ticks, tickDelta);
    }

    @Override
    public <T extends class_1297> void renderEntity(T falling, class_630 root, class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        this.method_2828(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
    }

    @Override
    public void renderDoors(ClientTardis tardis, ExteriorBlockEntity exterior, class_630 root, class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float pAlpha, boolean isBOTI) {
    }

    @Override
    public class_630 method_32008() {
        return this.root;
    }
}

