/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.amble.ait.core.entities.FlightTardisEntity;
import dev.amble.ait.core.tardis.Tardis;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import net.minecraft.class_742;

public class RWFOverlay
implements HudRenderCallback {
    private static final int ALPHA_GRAY = class_5253.class_5254.method_27764((int)125, (int)255, (int)255, (int)255);

    public void onHudRender(class_332 drawContext, float tickDelta) {
        class_1297 class_12972;
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return;
        }
        if (mc.field_1724.method_5765() && (class_12972 = mc.field_1724.method_5854()) instanceof FlightTardisEntity) {
            FlightTardisEntity entity = (FlightTardisEntity)class_12972;
            if (!entity.isLinked()) {
                return;
            }
            Tardis tardis = entity.tardis().get();
            Yaw.render(drawContext, (class_742)mc.field_1724);
            Position.render(drawContext, (class_742)mc.field_1724, mc);
            Position.Y.render(drawContext, (class_742)mc.field_1724, mc);
            Speed.render(drawContext, (class_742)mc.field_1724, mc);
        }
    }

    private void renderOverlay(class_332 context, class_2960 texture) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        context.method_25291(texture, context.method_51421() / 2 - 8, context.method_51443() / 2 - 8, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static int width() {
        return class_310.method_1551().method_22683().method_4486();
    }

    private static int height() {
        return class_310.method_1551().method_22683().method_4502() - 8;
    }

    private static void renderIncrementedLine(class_332 context, int x, int gap) {
        context.method_25301(x, 0, RWFOverlay.height(), ALPHA_GRAY);
    }

    private static class Yaw {
        private Yaw() {
        }

        private static void render(class_332 context, class_742 player) {
            context.method_25292(60, RWFOverlay.width() - 60, 20, ALPHA_GRAY);
            context.method_25301(60, 16, 24, -1);
            context.method_25301(RWFOverlay.width() - 60, 16, 24, -1);
            float current = player.method_36454();
            Yaw.line(context, -180.0f, current, false);
            Yaw.line(context, -90.0f, current, false);
            Yaw.line(context, 0.0f, current, false);
            Yaw.line(context, 90.0f, current, false);
            Yaw.line(context, 180.0f, current, false);
            Yaw.line(context, player.method_36454(), 0.0f, true);
        }

        private static void line(class_332 context, float yaw, float current, boolean isPrimary) {
            int x = isPrimary ? RWFOverlay.width() / 2 : Yaw.position(yaw, current);
            int middle = RWFOverlay.width() / 2;
            if (!isPrimary && middle - 10 <= x && x <= middle + 10) {
                return;
            }
            int color = isPrimary ? -1 : ALPHA_GRAY;
            context.method_25301(x, 16, 24, color);
            context.method_25300(class_310.method_1551().field_1772, "" + Math.round(class_3532.method_15393((float)yaw)), x, 26, color);
            class_2350 dir = class_2350.method_10150((double)yaw);
            context.method_25300(class_310.method_1551().field_1772, "" + dir.method_15434().toUpperCase().charAt(0), x, 35, color);
        }

        private static int position(float yaw, float current) {
            return (int)((float)(RWFOverlay.width() - 120) * ((class_3532.method_15393((float)(yaw - current)) + 180.0f) / 360.0f)) + 60;
        }
    }

    private static class Position {
        private Position() {
        }

        private static void render(class_332 context, class_742 player, class_310 client) {
            String i = Math.round(player.method_23317()) + ", " + Math.round(player.method_23321());
            context.method_25294(RWFOverlay.width() - 62 - client.field_1772.method_1727(i), 48, RWFOverlay.width() - 58, 61, ALPHA_GRAY);
            context.method_25303(client.field_1772, i, RWFOverlay.width() - 60 - client.field_1772.method_1727(i), 50, 0xFFFFFF);
        }

        private static class Y {
            private Y() {
            }

            private static void render(class_332 context, class_742 player, class_310 client) {
                int bottom = Math.abs(player.method_37908().method_31607());
                int range = player.method_37908().method_31600() + Math.min(bottom, 0);
                RWFOverlay.renderIncrementedLine(context, RWFOverlay.width() - 10, 8);
                Y.line(context, (double)range / 2.0, bottom, range, false);
                Y.line(context, (double)range / 4.0, bottom, range, false);
                Y.line(context, 0.0, 128, range, false);
                Y.line(context, player.method_23318(), bottom, range, true);
            }

            private static void line(class_332 context, double y, int bottom, int range, boolean isPrimary) {
                int yPosition = Y.position(y, bottom, range);
                int color = isPrimary ? -1 : ALPHA_GRAY;
                context.method_25292(RWFOverlay.width() - 15, RWFOverlay.width() - 10, yPosition + 3, color);
                class_327 renderer = class_310.method_1551().field_1772;
                String text = "" + Math.round(y);
                context.method_25303(renderer, text, RWFOverlay.width() - renderer.method_1727(text) - 17, yPosition, color);
            }

            private static int position(double y, int bottom, int range) {
                return (int)((float)RWFOverlay.height() * (1.0f - (float)(y + (double)bottom) / (float)range));
            }
        }
    }

    private static class Speed {
        private Speed() {
        }

        private static void render(class_332 context, class_742 player, class_310 client) {
            double deltaX = player.method_23317() - player.field_6014;
            double deltaZ = player.method_23321() - player.field_5969;
            double deltaY = player.method_23318() - player.field_6036;
            double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
            String s = Math.round(distance * 20.0) + " m/s";
            context.method_25294(58, 49, 62 + client.field_1772.method_1727(s), 60, ALPHA_GRAY);
            context.method_25303(client.field_1772, s, 60, 50, 0xFFFFFF);
        }
    }

    private static class Pitch {
        private Pitch() {
        }

        private static void render(class_332 context, class_742 player) {
            RWFOverlay.renderIncrementedLine(context, 10, 5);
            Pitch.line(context, 0.0f, false);
            Pitch.line(context, 45.0f, false);
            Pitch.line(context, -45.0f, false);
            Pitch.line(context, player.method_36455(), true);
        }

        private static void line(class_332 context, float pitch, boolean isPrimary) {
            int y = Pitch.position(pitch);
            int color = isPrimary ? -1 : ALPHA_GRAY;
            context.method_25292(10, 15, y + 3, color);
            context.method_25300(class_310.method_1551().field_1772, "" + Math.round(pitch), 27, y, color);
        }

        private static int position(float pitch) {
            return (int)((float)RWFOverlay.height() * ((pitch + 90.0f) / 180.0f));
        }
    }
}

