/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.engine.DurableSubSystem;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.engine.block.SubSystemBlockEntity;
import dev.amble.ait.core.engine.impl.EngineSystem;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.core.item.sonic.SonicMode;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.world.TardisServerWorld;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class SonicRendering {
    private static final class_2960 SELECTED = AITMod.id("textures/marker/landing.png");
    public static final class_2960 SELECTED_RED = AITMod.id("textures/marker/landing_red.png");
    private final class_310 client;
    private final class_3695 profiler;
    private static SonicRendering INSTANCE;

    public SonicRendering(class_310 client) {
        this.client = client;
        this.profiler = client.method_16011();
    }

    public SonicRendering() {
        this(class_310.method_1551());
    }

    public static void renderFloorTexture(class_2338 pos, class_2960 texture, @Nullable class_2960 previous, boolean spinning) {
        SonicRendering.renderFloorTexture(new class_243((double)(pos.method_10263() + 1), (double)(pos.method_10264() + 1), (double)(pos.method_10260() + 1)), texture, previous, spinning);
    }

    public static void renderFloorTexture(class_243 target, class_2960 texture, @Nullable class_2960 previous, boolean spinning) {
        boolean shouldRender;
        class_3695 profiler = class_310.method_1551().field_1687.method_16107();
        profiler.method_15396("get");
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        class_4587 matrices = new class_4587();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        profiler.method_15405("transform");
        class_243 transform = target.method_1020(camera.method_19326());
        matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
        matrices.method_22904(transform.field_1352 - 0.5, transform.field_1351 + (double)0.05f, transform.field_1350 - 0.5);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        if (spinning) {
            matrices.method_22907(class_7833.field_40718.rotationDegrees((float)client.field_1724.field_6012 / 200.0f * 360.0f));
        }
        matrices.method_46416(-0.5f, 0.5f, 0.0f);
        profiler.method_15405("vertexes");
        if (!buffer.method_22893()) {
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        }
        buffer.method_22918(positionMatrix, 0.0f, 0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 0.0f).method_1344();
        buffer.method_22918(positionMatrix, 0.0f, -1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 1.0f).method_1344();
        buffer.method_22918(positionMatrix, 1.0f, -1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(1.0f, 1.0f).method_1344();
        buffer.method_22918(positionMatrix, 1.0f, 0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(1.0f, 0.0f).method_1344();
        boolean bl = shouldRender = !texture.equals((Object)previous);
        if (shouldRender) {
            profiler.method_15405("draw");
            RenderSystem.setShader(class_757::method_34541);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)texture);
            RenderSystem.disableCull();
            RenderSystem.depthFunc((int)519);
            class_289.method_1348().method_1350();
            RenderSystem.depthFunc((int)515);
            RenderSystem.enableCull();
        }
        profiler.method_15407();
    }

    public void renderWorld(WorldRenderContext context) {
        class_3695 worldProfiler = context.profiler();
        worldProfiler.method_15396("sonic");
        worldProfiler.method_15396("world");
        if (this.client.field_1724 == null) {
            return;
        }
        if (SonicRendering.isPlayerHoldingSonicOf(SonicMode.Modes.TARDIS) && !TardisServerWorld.isTardisDimension(this.client.field_1724.method_37908())) {
            this.renderSelectedBlock(context);
        }
        worldProfiler.method_15407();
        worldProfiler.method_15407();
    }

    private void renderSelectedBlock(WorldRenderContext context) {
        boolean hasEnoughFuel;
        class_3695 worldProfiler = context.profiler();
        worldProfiler.method_15396("target");
        class_239 class_2392 = this.client.field_1765;
        if (!(class_2392 instanceof class_3965)) {
            this.profiler.method_15407();
            this.profiler.method_15407();
            return;
        }
        class_3965 crosshair = (class_3965)class_2392;
        if (this.client.field_1724 == null || this.client.field_1687 == null) {
            this.profiler.method_15407();
            return;
        }
        class_2338 targetPos = crosshair.method_17777();
        class_2680 state = this.client.field_1687.method_8320(targetPos.method_10074());
        if (state.method_26215()) {
            this.profiler.method_15407();
            return;
        }
        Tardis tardis = SonicItem.getTardisStatic((class_1937)this.client.field_1687, SonicRendering.getSonicStack((class_1657)this.client.field_1724));
        if (tardis == null) {
            this.profiler.method_15407();
            return;
        }
        double distance = TardisUtil.distanceFromTardis((class_1657)this.client.field_1724, tardis);
        boolean bl = hasEnoughFuel = tardis.fuel().getCurrentFuel() > TardisUtil.estimatedFuelCost((class_1657)this.client.field_1724, tardis, distance);
        if (!hasEnoughFuel) {
            SonicRendering.renderFloorTexture(targetPos, SELECTED_RED, null, false);
            return;
        }
        SonicRendering.renderFloorTexture(targetPos, SELECTED, null, false);
        worldProfiler.method_15407();
        worldProfiler.method_15407();
    }

    public void renderGui(class_332 context, float delta) {
        if (this.client.field_1687 == null) {
            return;
        }
        if (!SonicRendering.isPlayerHoldingScanningSonic()) {
            return;
        }
        this.profiler.method_15405("sonic");
        this.profiler.method_15396("gui");
        this.profiler.method_15396("target");
        class_239 class_2392 = this.client.field_1765;
        if (!(class_2392 instanceof class_3965)) {
            this.profiler.method_15407();
            this.profiler.method_15407();
            return;
        }
        class_3965 crosshair = (class_3965)class_2392;
        class_2338 targetPos = crosshair.method_17777();
        class_2680 state = this.client.field_1687.method_8320(targetPos);
        this.profiler.method_15405("redstone");
        this.renderRedstone(context, state, targetPos);
        this.profiler.method_15405("subsystem_info");
        this.renderSubSystemInfo(context, targetPos);
        this.profiler.method_15407();
        this.profiler.method_15407();
    }

    private void renderRedstone(class_332 context, class_2680 state, class_2338 pos) {
        this.profiler.method_15396("power");
        this.renderPower(context, pos);
        this.profiler.method_15407();
    }

    private void renderPower(class_332 context, class_2338 pos) {
        int power = this.client.field_1687.method_49804(pos);
        if (power == 0) {
            return;
        }
        context.method_25300(this.client.field_1772, "" + power, this.getCentreX(), (int)((double)this.getMaxY() * 0.4), -1);
    }

    private void renderSubSystemInfo(class_332 context, class_2338 pos) {
        class_2586 class_25862 = this.client.field_1687.method_8321(pos);
        if (!(class_25862 instanceof SubSystemBlockEntity)) {
            return;
        }
        SubSystemBlockEntity be = (SubSystemBlockEntity)class_25862;
        SubSystem system = be.system();
        if (system == null) {
            return;
        }
        class_5250 text = class_2561.method_43473();
        if (system instanceof DurableSubSystem) {
            text = class_2561.method_43470((String)(Math.round(((DurableSubSystem)be.system()).durability()) + " / 1250"));
        }
        if (!system.isEnabled() && !(system instanceof EngineSystem)) {
            text = class_2561.method_43471((String)"tardis.message.subsystem.requires_link");
        }
        context.method_27534(this.client.field_1772, (class_2561)text, this.getCentreX(), (int)((double)this.getMaxY() * 0.42), -1);
        text = system.name();
        context.method_27534(this.client.field_1772, (class_2561)text, this.getCentreX(), (int)((double)this.getMaxY() * 0.46), -1);
    }

    private int getMaxX() {
        return this.client.method_22683().method_4486();
    }

    private int getMaxY() {
        return this.client.method_22683().method_4502();
    }

    private int getCentreX() {
        return this.getMaxX() / 2;
    }

    private int getCentreY() {
        return this.getMaxY() / 2;
    }

    private int getTextWidth(String text) {
        return this.client.field_1772.method_1727(text);
    }

    public static SonicRendering getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SonicRendering();
        }
        return INSTANCE;
    }

    public static boolean isScanningSonic(class_1799 sonic) {
        return SonicRendering.isSonicOf(SonicMode.Modes.SCANNING, sonic);
    }

    public static boolean isSonicOf(SonicMode mode, class_1799 sonic) {
        if (sonic.method_7909() instanceof SonicItem) {
            return SonicItem.mode(sonic) == mode;
        }
        return false;
    }

    public static boolean isPlayerHoldingScanningSonic() {
        return SonicRendering.isPlayerHoldingSonicOf(SonicMode.Modes.SCANNING);
    }

    public static boolean isPlayerHoldingSonicOf(SonicMode mode) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        class_1799 sonic = SonicRendering.getSonicStack((class_1657)player);
        if (sonic == null) {
            return false;
        }
        return SonicRendering.isSonicOf(mode, sonic);
    }

    public static class_1799 getSonicStack(class_1657 player) {
        if (player.method_6047().method_7909() instanceof SonicItem) {
            return player.method_6047();
        }
        if (player.method_6079().method_7909() instanceof SonicItem) {
            return player.method_6079();
        }
        return null;
    }
}

