/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.tardis.vortex.reference.VortexReference;
import dev.amble.ait.core.tardis.vortex.reference.VortexReferenceRegistry;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_757;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class VortexRender {
    private static VortexRender INSTANCE;
    public class_2960 texture;
    public class_2960 secondLayer;
    public class_2960 thirdLayer;
    private final float distortionSpeed;
    private final float distortionSeparationFactor;
    private final float distortionFactor;
    private final float scale;
    private final float speed;
    private float time = 0.0f;

    public VortexRender(class_2960 texture) {
        this.replaceWith(texture);
        this.distortionSpeed = 0.5f;
        this.distortionSeparationFactor = 32.0f;
        this.distortionFactor = 2.0f;
        this.scale = 32.0f;
        this.speed = 4.0f;
    }

    @ApiStatus.Internal
    public VortexRender(String name) {
        this(AITMod.id("textures/vortex/" + name + ".png"));
    }

    public static VortexRender getInstance(VortexReference ref) {
        if (INSTANCE == null) {
            INSTANCE = new VortexRender(ref.texture());
        } else if (!INSTANCE.isFor(ref.texture())) {
            INSTANCE.replaceWith(ref.texture());
        }
        return INSTANCE;
    }

    public static VortexRender getCurrentInstance() {
        if (INSTANCE == null) {
            INSTANCE = new VortexRender(((VortexReference)VortexReferenceRegistry.getInstance().getRandom()).texture());
        }
        return INSTANCE;
    }

    public boolean isFor(class_2960 texture) {
        return this.texture.equals((Object)texture);
    }

    public void replaceWith(class_2960 texture) {
        this.texture = texture;
        this.secondLayer = new class_2960(texture.method_12836(), texture.method_12832().substring(0, texture.method_12832().length() - 4) + "_second.png");
        this.thirdLayer = new class_2960(texture.method_12836(), texture.method_12832().substring(0, texture.method_12832().length() - 4) + "_third.png");
    }

    public void render(class_4587 matrixStack) {
        this.time += class_310.method_1551().method_1488() / 360.0f;
        this.renderLayer(matrixStack, 1.0f, this.texture);
        this.renderLayer(matrixStack, 1.5f);
        this.renderLayer(matrixStack, 2.5f);
    }

    public void renderLayer(class_4587 matrixStack, float scaleFactor) {
        class_2960 currentTexture;
        class_2960 class_29602 = currentTexture = scaleFactor == 1.5f ? this.secondLayer : this.thirdLayer;
        if (class_310.method_1551().method_1478().method_14486(currentTexture).isEmpty()) {
            return;
        }
        this.renderLayer(matrixStack, scaleFactor, currentTexture);
    }

    private void renderLayer(class_4587 matrixStack, float scaleFactor, class_2960 layer) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34510);
        RenderSystem.setShaderTexture((int)0, (class_2960)layer);
        matrixStack.method_22903();
        matrixStack.method_22905(this.scale / scaleFactor, this.scale / scaleFactor, this.scale);
        class_310.method_1551().method_1531().method_22813(layer);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
        for (int i = 0; i < 32; ++i) {
            this.renderSection((class_4588)buffer, i, (float)class_310.method_1551().field_1724.field_6012 * 0.005f * -this.speed, (float)Math.sin((double)i * Math.PI / 32.0), (float)Math.sin((double)(i + 1) * Math.PI / 32.0), matrixStack.method_23760().method_23762(), matrixStack.method_23760().method_23761());
        }
        tessellator.method_1350();
        matrixStack.method_22909();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public void renderSection(class_4588 builder, int zOffset, float textureDistanceOffset, float startScale, float endScale, Matrix3f matrix3f, Matrix4f matrix4f) {
        float panel = 0.16666667f;
        float sqrt = (float)Math.sqrt(3.0) / 2.0f;
        int vOffset = (double)((float)zOffset * panel + textureDistanceOffset) > 1.0 ? zOffset - 6 : zOffset;
        float distortion = this.computeDistortionFactor(this.time, zOffset);
        float distortionPlusOne = this.computeDistortionFactor(this.time, zOffset + 1);
        float panelDistanceOffset = panel + textureDistanceOffset;
        float vPanelOffset = (float)vOffset * panel + textureDistanceOffset;
        int uOffset = 0;
        float uPanelOffset = (float)uOffset * panel;
        this.addVertex(builder, matrix3f, matrix4f, 0.0f, -startScale + distortion, -zOffset, uPanelOffset, vPanelOffset);
        this.addVertex(builder, matrix3f, matrix4f, 0.0f, -endScale + distortionPlusOne, -zOffset - 1, uPanelOffset, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, endScale * -sqrt, endScale / -2.0f + distortionPlusOne, -zOffset - 1, uPanelOffset + panel, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, startScale * -sqrt, startScale / -2.0f + distortion, -zOffset, uPanelOffset + panel, vPanelOffset);
        uOffset = 1;
        uPanelOffset = (float)uOffset * panel;
        this.addVertex(builder, matrix3f, matrix4f, startScale * -sqrt, startScale / -2.0f + distortion, -zOffset, uPanelOffset, vPanelOffset);
        this.addVertex(builder, matrix3f, matrix4f, endScale * -sqrt, endScale / -2.0f + distortionPlusOne, -zOffset - 1, uPanelOffset, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, endScale * -sqrt, endScale / 2.0f + distortionPlusOne, -zOffset - 1, uPanelOffset + panel, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, startScale * -sqrt, startScale / 2.0f + distortion, -zOffset, uPanelOffset + panel, vPanelOffset);
        uOffset = 2;
        uPanelOffset = (float)uOffset * panel;
        this.addVertex(builder, matrix3f, matrix4f, 0.0f, endScale + distortionPlusOne, -zOffset - 1, uPanelOffset + panel, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, 0.0f, startScale + distortion, -zOffset, uPanelOffset + panel, vPanelOffset);
        this.addVertex(builder, matrix3f, matrix4f, startScale * -sqrt, startScale / 2.0f + distortion, -zOffset, uPanelOffset, vPanelOffset);
        this.addVertex(builder, matrix3f, matrix4f, endScale * -sqrt, endScale / 2.0f + distortionPlusOne, -zOffset - 1, uPanelOffset, (float)vOffset * panel + panelDistanceOffset);
        uOffset = 3;
        uPanelOffset = (float)uOffset * panel;
        this.addVertex(builder, matrix3f, matrix4f, 0.0f, startScale + distortion, -zOffset, uPanelOffset, vPanelOffset);
        this.addVertex(builder, matrix3f, matrix4f, 0.0f, endScale + distortionPlusOne, -zOffset - 1, uPanelOffset, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, endScale * sqrt, endScale / 2.0f + distortionPlusOne, -zOffset - 1, uPanelOffset + panel, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, startScale * sqrt, startScale / 2.0f + distortion, -zOffset, uPanelOffset + panel, vPanelOffset);
        uOffset = 4;
        uPanelOffset = (float)uOffset * panel;
        this.addVertex(builder, matrix3f, matrix4f, startScale * sqrt, startScale / 2.0f + distortion, -zOffset, uPanelOffset, vPanelOffset);
        this.addVertex(builder, matrix3f, matrix4f, endScale * sqrt, endScale / 2.0f + distortionPlusOne, -zOffset - 1, uPanelOffset, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, endScale * sqrt, endScale / -2.0f + distortionPlusOne, -zOffset - 1, uPanelOffset + panel, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, startScale * sqrt, startScale / -2.0f + distortion, -zOffset, uPanelOffset + panel, vPanelOffset);
        uOffset = 5;
        uPanelOffset = (float)uOffset * panel;
        this.addVertex(builder, matrix3f, matrix4f, 0.0f, -endScale + distortionPlusOne, -zOffset - 1, uPanelOffset + panel, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, 0.0f, -startScale + distortion, -zOffset, uPanelOffset + panel, vPanelOffset);
        this.addVertex(builder, matrix3f, matrix4f, startScale * sqrt, startScale / -2.0f + distortion, -zOffset, uPanelOffset, vPanelOffset);
        this.addVertex(builder, matrix3f, matrix4f, endScale * sqrt, endScale / -2.0f + distortionPlusOne, -zOffset - 1, uPanelOffset, (float)vOffset * panel + panelDistanceOffset);
    }

    private void addVertex(class_4588 builder, Matrix3f normalMatrix, Matrix4f matrix, float x, float y, float z, float u, float v) {
        builder.method_22918(matrix, x, y, z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(u, v).method_22916(0xF000F0).method_23763(normalMatrix, 0.0f, 0.0f, 0.0f).method_1344();
    }

    private float computeDistortionFactor(float time, int t) {
        return (float)(Math.sin((double)(time * this.distortionSpeed) * 2.0 * Math.PI + (double)((float)(13 - t) * this.distortionSeparationFactor)) * (double)this.distortionFactor) / 8.0f;
    }
}

