/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.renderers.doors;

import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.link.v2.block.AbstractLinkableBlockEntity;
import dev.amble.ait.client.boti.BOTI;
import dev.amble.ait.client.models.AnimatedModel;
import dev.amble.ait.client.models.doors.CapsuleDoorModel;
import dev.amble.ait.client.models.doors.exclusive.DoomDoorModel;
import dev.amble.ait.client.renderers.AITRenderLayers;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.compat.DependencyChecker;
import dev.amble.ait.core.blockentities.DoorBlockEntity;
import dev.amble.ait.core.blocks.DoorBlock;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.data.datapack.DatapackConsole;
import dev.amble.ait.data.schema.exterior.ClientExteriorVariantSchema;
import dev.amble.ait.registry.impl.exterior.ClientExteriorVariantRegistry;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Vector3f;

public class DoorRenderer<T extends DoorBlockEntity>
implements class_827<T> {
    private ClientExteriorVariantSchema variant;
    private AnimatedModel<DoorBlockEntity> model;

    public DoorRenderer(class_5614.class_5615 ctx) {
    }

    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        if (entity.method_10997() == null) {
            return;
        }
        if (!entity.isLinked()) {
            class_2680 blockState = entity.method_11010();
            float k = ((class_2350)blockState.method_11654((class_2769)DoorBlock.FACING)).method_10144();
            matrices.method_22903();
            matrices.method_22904(0.5, 1.5, 0.5);
            matrices.method_22905(1.0f, 1.0f, 1.0f);
            matrices.method_22907(class_7833.field_40715.rotationDegrees(k + 180.0f));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
            CapsuleDoorModel doorModel = new CapsuleDoorModel(CapsuleDoorModel.getTexturedModelData().method_32109());
            doorModel.method_2828(matrices, vertexConsumers.getBuffer(AITRenderLayers.method_23576((class_2960)ClientExteriorVariantRegistry.CAPSULE_DEFAULT.texture())), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            matrices.method_22909();
            return;
        }
        class_3695 profiler = entity.method_10997().method_16107();
        profiler.method_15396("door");
        ClientTardis tardis = ((AbstractLinkableBlockEntity)entity).tardis().get().asClient();
        if (!tardis.siege().isActive()) {
            this.renderDoor(profiler, tardis, entity, matrices, vertexConsumers, light, overlay, tickDelta);
        }
        profiler.method_15407();
    }

    private void renderDoor(class_3695 profiler, ClientTardis tardis, T entity, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, float tickDelta) {
        BiomeHandler biome;
        class_2960 biomeTexture;
        this.updateModel(tardis);
        class_2680 blockState = entity.method_11010();
        float k = ((class_2350)blockState.method_11654((class_2769)DoorBlock.FACING)).method_10144();
        class_2960 texture = this.variant.texture();
        if (this.variant.equals(ClientExteriorVariantRegistry.DOOM)) {
            texture = tardis.door().isOpen() ? DoomDoorModel.DOOM_DOOR_OPEN : DoomDoorModel.DOOM_DOOR;
        }
        matrices.method_22903();
        matrices.method_22904(0.5, 0.0, 0.5);
        Vector3f scale = tardis.stats().getScale();
        matrices.method_22905(scale.x(), scale.y(), scale.z());
        matrices.method_22907(class_7833.field_40715.rotationDegrees(k));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        if (!DependencyChecker.hasIris()) {
            this.model.renderWithAnimations(tardis, (DoorBlockEntity)entity, this.model.method_32008(), matrices, vertexConsumers.getBuffer(AITRenderLayers.method_23689((class_2960)texture)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f, tickDelta);
        }
        profiler.method_15396("emission");
        class_2960 emissive = this.variant.emission();
        if (!this.variant.equals(ClientExteriorVariantRegistry.DOOM) && emissive != null && !emissive.equals((Object)DatapackConsole.EMPTY)) {
            float green;
            float red;
            float u;
            float t;
            float s;
            boolean power = tardis.fuel().hasPower();
            boolean alarms = tardis.alarm().isEnabled();
            if (tardis.stats().getName() != null && "partytardis".equals(tardis.stats().getName().toLowerCase()) || !tardis.extra().getInsertedDisc().method_7960()) {
                int m = 25;
                int n = class_310.method_1551().field_1724.field_6012 / m + class_310.method_1551().field_1724.method_5628();
                int o = class_1767.values().length;
                int p = n % o;
                int q = (n + 1) % o;
                float r = (float)(class_310.method_1551().field_1724.field_6012 % m) / (float)m;
                float[] fs = class_1472.method_6634((class_1767)class_1767.method_7791((int)p));
                float[] gs = class_1472.method_6634((class_1767)class_1767.method_7791((int)q));
                s = fs[0] * (1.0f - r) + gs[0] * r;
                t = fs[1] * (1.0f - r) + gs[1] * r;
                u = fs[2] * (1.0f - r) + gs[2] * r;
            } else {
                float[] hs = new float[]{1.0f, 1.0f, 1.0f};
                s = hs[0];
                t = hs[1];
                u = hs[2];
            }
            float colorAlpha = 1.0f;
            float f = alarms ? (!power ? 0.25f : s) : (red = s);
            float f2 = alarms ? (!power ? 0.01f : 0.3f) : (green = t);
            float blue = alarms ? (!power ? 0.01f : 0.3f) : u;
            this.model.renderWithAnimations(tardis, (DoorBlockEntity)entity, this.model.method_32008(), matrices, vertexConsumers.getBuffer(AITRenderLayers.tardisEmissiveCullZOffset(this.variant.emission(), true)), 0xF000F0, class_4608.field_21444, red, green, blue, colorAlpha, tickDelta);
        }
        if (DependencyChecker.hasIris()) {
            this.model.renderWithAnimations(tardis, (DoorBlockEntity)entity, this.model.method_32008(), matrices, vertexConsumers.getBuffer(AITRenderLayers.method_23689((class_2960)texture)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f, tickDelta);
        }
        profiler.method_15405("biome");
        if (this.variant != ClientExteriorVariantRegistry.CORAL_GROWTH && (biomeTexture = (biome = (BiomeHandler)tardis.handler(TardisComponent.Id.BIOME)).getBiomeKey().get(this.variant.overrides())) != null && !texture.equals((Object)biomeTexture)) {
            this.model.renderWithAnimations(tardis, (DoorBlockEntity)entity, this.model.method_32008(), matrices, vertexConsumers.getBuffer(AITRenderLayers.method_28116((class_2960)biomeTexture)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f, tickDelta);
        }
        if ((tardis.door().getLeftRot() > 0.0f || this.variant.hasTransparentDoors()) && !tardis.isGrowth()) {
            BOTI.DOOR_RENDER_QUEUE.add((DoorBlockEntity)entity);
        }
        matrices.method_22909();
        profiler.method_15407();
    }

    private void updateModel(Tardis tardis) {
        if (tardis.getExterior().getVariant() == null) {
            return;
        }
        ClientExteriorVariantSchema variant = tardis.getExterior().getVariant().getClient();
        if (this.variant != variant) {
            this.variant = variant;
            this.model = variant.getDoor().model();
        }
    }

    public boolean rendersOutsideBoundingBox(DoorBlockEntity doorBlockEntity) {
        return true;
    }

    public int method_33893() {
        return 256;
    }

    public boolean isInRenderDistance(DoorBlockEntity doorBlockEntity, class_243 vec3d) {
        return class_243.method_24953((class_2382)doorBlockEntity.method_11016()).method_18805(1.0, 0.0, 1.0).method_24802((class_2374)vec3d.method_18805(1.0, 0.0, 1.0), (double)this.method_33893());
    }
}

