/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.renderers.entities;

import dev.amble.ait.AITMod;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.models.consoles.ControlModel;
import dev.amble.ait.client.renderers.SonicRendering;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.entities.ConsoleControlEntity;
import dev.amble.ait.core.tardis.Tardis;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5617;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ControlEntityRenderer
extends class_897<ConsoleControlEntity> {
    private static final class_2960 TEXTURE = AITMod.id("textures/entity/control/sequenced.png");
    ControlModel model = new ControlModel(ControlModel.getTexturedModelData().method_32109());

    public ControlEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public void render(ConsoleControlEntity entity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        super.method_3936((class_1297)entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
        if (SonicRendering.isPlayerHoldingScanningSonic() && AITModClient.CONFIG.showControlHitboxes) {
            ControlEntityRenderer.renderOutline(entity, matrixStack, vertexConsumerProvider);
        }
    }

    protected void renderLabelIfPresent(ConsoleControlEntity entity, class_2561 text, class_4587 matrices, class_4597 vertexConsumers, int light) {
        double d = this.field_4676.method_23168((class_1297)entity);
        if (d > 4096.0) {
            return;
        }
        class_2561 name = entity.method_5797();
        if (name == null) {
            return;
        }
        class_327 textRenderer = this.method_3932();
        float h = (float)(-textRenderer.method_27525((class_5348)name)) / 2.0f;
        float f = entity.method_51152() - 0.3f;
        if (!entity.isLinked()) {
            return;
        }
        Tardis tardis = entity.tardis().get();
        if (tardis == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_46416(0.0f, f, 0.0f);
        matrices.method_22907(this.field_4676.method_24197());
        matrices.method_22905(-0.0075f, -0.0075f, 0.0075f);
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        class_239 hitresult = class_310.method_1551().field_1765;
        if (hitresult != null) {
            boolean isPlayerLookingWithSonic = ControlEntityRenderer.isPlayerLookingAtControlWithSonic(hitresult, entity);
            class_5481 orderedText = name.method_30937();
            if (isPlayerLookingWithSonic) {
                textRenderer.method_37296(orderedText, h, (float)name.getString().length(), 0xF0F0F0, 0, matrix4f, vertexConsumers, 255);
            }
        }
        matrices.method_22909();
        if (hitresult == null) {
            return;
        }
        boolean sonicInConsole = ControlEntityRenderer.isScanningSonicInConsole(entity);
        boolean handlesInConsole = ControlEntityRenderer.isHandlesInConsole(entity);
        if (!entity.isPartOfSequence() || !sonicInConsole && !handlesInConsole) {
            return;
        }
        matrices.method_22903();
        matrices.method_22905(0.4f, 0.4f, 0.4f);
        matrices.method_22907(class_7833.field_40713.rotationDegrees(180.0f));
        matrices.method_22904(0.0, (double)(-2.0f - entity.getControlHeight() / 2.0f) + (double)entity.method_37908().field_9229.method_43057() * 0.02, 0.0);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(class_310.method_1551().method_1488() % 180.0f));
        float alpha = entity.method_37908().field_9229.method_43048(32) != 6 ? 0.4f : 0.05f;
        float red = entity.wasSequenced() ? 0.0f : 1.0f;
        float green = entity.wasSequenced() ? 1.0f : 1.0f - entity.getSequencePercentage();
        this.model.method_2828(matrices, vertexConsumers.getBuffer(class_1921.method_23580((class_2960)TEXTURE)), light, class_4608.field_21444, red, green, 0.0f, alpha);
        this.model.method_2828(matrices, vertexConsumers.getBuffer(class_1921.method_23026((class_2960)TEXTURE)), 0xFF00F0, class_4608.field_21444, red, green, 0.0f, alpha);
        matrices.method_22909();
    }

    private static void renderOutline(class_1297 entity, class_4587 matrices, class_4597 vertexConsumers) {
        class_4588 vertices = vertexConsumers.getBuffer((class_1921)class_1921.field_21695);
        class_238 box = entity.method_5829().method_989(-entity.method_23317(), -entity.method_23318(), -entity.method_23321());
        class_761.method_22982((class_4587)matrices, (class_4588)vertices, (class_238)box, (float)0.0f, (float)0.8f, (float)1.0f, (float)1.0f);
    }

    private static boolean isPlayerLookingAtControlWithSonic(class_239 hitResult, ConsoleControlEntity entity) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || !(hitResult instanceof class_3966)) {
            return false;
        }
        class_3966 entityHit = (class_3966)hitResult;
        class_1297 hitEntity = entityHit.method_17782();
        if (hitEntity == null) {
            return false;
        }
        class_1799 sonic = SonicRendering.getSonicStack((class_1657)player);
        if (sonic == null) {
            return false;
        }
        return hitEntity.equals((Object)entity) && SonicRendering.isScanningSonic(sonic);
    }

    private static boolean isScanningSonicInConsole(ConsoleControlEntity entity) {
        if (entity.getConsole() == null) {
            return false;
        }
        ConsoleBlockEntity console = entity.getConsole();
        if (console.getSonicScrewdriver() == null || console.getSonicScrewdriver().method_7960()) {
            return false;
        }
        class_1799 sonic = console.getSonicScrewdriver();
        if (sonic == null) {
            return false;
        }
        return SonicRendering.isScanningSonic(sonic);
    }

    private static boolean isHandlesInConsole(ConsoleControlEntity entity) {
        ConsoleBlockEntity console = entity.getConsole();
        if (console == null) {
            return false;
        }
        if (!console.isLinked()) {
            return false;
        }
        Tardis tardis = console.tardis().get();
        return tardis != null && tardis.butler().getHandles() != null;
    }

    public class_2960 getTexture(ConsoleControlEntity controlEntity) {
        return TEXTURE;
    }
}

