/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.renderers.entities;

import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.client.models.exteriors.ExteriorModel;
import dev.amble.ait.client.models.exteriors.SiegeModeModel;
import dev.amble.ait.client.renderers.AITRenderLayers;
import dev.amble.ait.compat.DependencyChecker;
import dev.amble.ait.core.blocks.ExteriorBlock;
import dev.amble.ait.core.entities.FallingTardisEntity;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisExterior;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.data.schema.exterior.ClientExteriorVariantSchema;
import dev.amble.ait.registry.impl.exterior.ClientExteriorVariantRegistry;
import net.minecraft.class_1059;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7718;
import net.minecraft.class_7833;
import net.minecraft.class_897;

public class FallingTardisRenderer
extends class_897<FallingTardisEntity> {
    public FallingTardisRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public void render(FallingTardisEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        BiomeHandler handler;
        class_2960 biomeTexture;
        Tardis tardis = entity.tardis().get();
        if (tardis == null) {
            return;
        }
        TardisExterior tardisExterior = tardis.getExterior();
        ClientExteriorVariantSchema exteriorVariant = tardisExterior.getVariant().getClient();
        if (exteriorVariant == null) {
            return;
        }
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        class_2960 texture = exteriorVariant.texture();
        class_2960 emission = exteriorVariant.emission();
        ExteriorModel model = exteriorVariant.model();
        if (model == null) {
            return;
        }
        matrices.method_22903();
        int k = (Integer)entity.getBlockState().method_11654((class_2769)ExteriorBlock.ROTATION);
        float h = class_7718.method_45482((int)k);
        matrices.method_22907(class_7833.field_40715.rotationDegrees(!exteriorVariant.equals(ClientExteriorVariantRegistry.DOOM) ? 180.0f + h : class_310.method_1551().field_1724.method_5791() + 180.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        boolean siege = tardis.siege().isActive();
        if (siege) {
            model = new SiegeModeModel(SiegeModeModel.getTexturedModelData().method_32109());
            texture = tardis.siege().texture().get();
        }
        model.renderEntity(entity, model.method_32008(), matrices, vertexConsumers.getBuffer(AITRenderLayers.method_23689((class_2960)texture)), light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (siege) {
            matrices.method_22909();
            return;
        }
        if (emission != null) {
            model.renderEntity(entity, model.method_32008(), matrices, vertexConsumers.getBuffer(DependencyChecker.hasIris() ? AITRenderLayers.tardisEmissiveCullZOffset(emission, true) : AITRenderLayers.method_23028((class_2960)emission)), 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (!exteriorVariant.equals(ClientExteriorVariantRegistry.CORAL_GROWTH) && (biomeTexture = (handler = (BiomeHandler)tardis.handler(TardisComponent.Id.BIOME)).getBiomeKey().get(exteriorVariant.overrides())) != null && !exteriorVariant.texture().equals((Object)biomeTexture)) {
            model.renderEntity(entity, model.method_32008(), matrices, vertexConsumers.getBuffer(AITRenderLayers.method_23689((class_2960)biomeTexture)), light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrices.method_22909();
    }

    public class_2960 getTexture(FallingTardisEntity entity) {
        if (entity.tardis().get() == null) {
            return class_1059.field_5275;
        }
        return entity.tardis().get().getExterior().getVariant().getClient().texture();
    }
}

