/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.renderers.entities;

import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.client.models.exteriors.ExteriorModel;
import dev.amble.ait.client.models.machines.ShieldsModel;
import dev.amble.ait.client.renderers.AITRenderLayers;
import dev.amble.ait.client.renderers.VortexRender;
import dev.amble.ait.core.AITDimensions;
import dev.amble.ait.core.entities.FlightTardisEntity;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.data.schema.exterior.ClientExteriorVariantSchema;
import net.minecraft.class_1059;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import net.minecraft.class_897;

public class FlightTardisRenderer
extends class_897<FlightTardisEntity> {
    private ExteriorModel model;
    private ClientExteriorVariantSchema variant;

    public FlightTardisRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public void render(FlightTardisEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        BiomeHandler biome;
        class_2960 biomeTexture;
        boolean doorsClosed;
        float deg;
        class_1309 class_13092;
        if (!entity.isLinked()) {
            return;
        }
        Tardis tardis = entity.tardis().get();
        if (tardis == null) {
            return;
        }
        this.updateModel(tardis);
        if (entity.method_5642() == null || !((class_13092 = entity.method_5642()) instanceof class_742)) {
            return;
        }
        class_742 player = (class_742)class_13092;
        if (player.method_5854() == null || player.method_5854() != entity) {
            return;
        }
        class_243 vec3d = entity.method_5828(tickDelta);
        class_243 vec3d2 = entity.lerpVelocity(tickDelta);
        double d = vec3d2.method_37268();
        double e = vec3d.method_37268();
        matrices.method_22903();
        if (tardis.door().isClosed() && !entity.field_36331) {
            matrices.method_22904(0.0, 0.25 * -vec3d2.method_10214(), 0.0);
        }
        if (tardis.travel().position().getDimension() == AITDimensions.TIME_VORTEX_WORLD) {
            VortexRender vortexRender = tardis.stats().getVortexEffects().toRender();
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40718.rotationDegrees((float)class_310.method_1551().field_1724.field_6012 / 100.0f * 360.0f));
            matrices.method_46416(0.0f, 0.0f, 500.0f);
            vortexRender.render(matrices);
            matrices.method_22909();
        }
        if (d > 0.0 && e > 0.0) {
            double l = (vec3d2.field_1352 * vec3d.field_1352 + vec3d2.field_1350 * vec3d.field_1350) / Math.sqrt(d * e);
            double m = vec3d2.field_1352 * vec3d.field_1350 - vec3d2.field_1350 * vec3d.field_1352;
            double v = Math.signum(m) * Math.acos(l);
            matrices.method_22907(class_7833.field_40716.rotation((float)v));
        }
        float f = deg = (doorsClosed = tardis.door().isClosed()) ? (float)(d * 22.5) : (float)(-d) * 22.5f;
        if (!entity.field_5992 && !doorsClosed) {
            this.model.method_32008().method_33425(0.0f, 0.0f, 0.0f);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        } else if (!entity.field_5992) {
            this.model.method_32008().method_33425(0.0f, entity.getRotation(tickDelta) * (float)tardis.travel().speed(), 0.0f);
        }
        matrices.method_22907(class_7833.field_40718.rotationDegrees(entity.field_5992 ? 180.0f : (float)(2.0 * Math.sin(0.2f * (tickDelta + (float)entity.field_6012)) + 180.0)));
        this.model.renderEntity(entity, this.model.method_32008(), matrices, vertexConsumers.getBuffer(AITRenderLayers.method_23689((class_2960)this.getTexture(entity))), light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (this.variant.emission() != null && tardis.fuel().hasPower()) {
            boolean alarms = tardis.alarm().isEnabled();
            float color = alarms ? 0.3f : 1.0f;
            this.model.renderEntity(entity, this.model.method_32008(), matrices, vertexConsumers.getBuffer(AITRenderLayers.tardisEmissiveCullZOffset(this.variant.emission(), true)), 0xF000F0, class_4608.field_21444, color, color, color, 1.0f);
        }
        if ((biomeTexture = (biome = (BiomeHandler)tardis.handler(TardisComponent.Id.BIOME)).getBiomeKey().get(this.variant.overrides())) != null && !this.getTexture(entity).equals((Object)biomeTexture)) {
            this.model.renderEntity(entity, this.model.method_32008(), matrices, vertexConsumers.getBuffer(AITRenderLayers.method_23689((class_2960)biomeTexture)), light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        int maxLight = 0xF000F0;
        matrices.method_22909();
        if (tardis.areVisualShieldsActive()) {
            matrices.method_22903();
            float delta = (tickDelta + (float)entity.field_6012) * 0.03f;
            ShieldsModel shieldsModel = new ShieldsModel(ShieldsModel.getTexturedModelData().method_32109());
            class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23018((class_2960)new class_2960("textures/misc/forcefield.png"), (float)(delta % 1.0f), (float)(delta * 0.1f % 1.0f)));
            shieldsModel.method_2828(matrices, vertexConsumer, maxLight, class_4608.field_21444, 0.0f, 0.25f, 0.5f, 1.0f);
            matrices.method_22909();
        }
    }

    private ExteriorModel getModel(Tardis tardis) {
        if (this.model == null) {
            this.model = tardis.getExterior().getVariant().getClient().model();
        }
        return this.model;
    }

    public class_2960 getTexture(FlightTardisEntity entity) {
        if (!entity.isLinked()) {
            return class_1059.field_5275;
        }
        return entity.tardis().get().getExterior().getVariant().getClient().texture();
    }

    private void updateModel(Tardis tardis) {
        ClientExteriorVariantSchema variant = tardis.getExterior().getVariant().getClient();
        if (this.variant != variant) {
            this.variant = variant;
            this.model = variant.model();
        }
    }
}

