/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.renderers.exteriors;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.link.v2.block.AbstractLinkableBlockEntity;
import dev.amble.ait.client.boti.BOTI;
import dev.amble.ait.client.models.exteriors.ExteriorModel;
import dev.amble.ait.client.models.exteriors.SiegeModeModel;
import dev.amble.ait.client.models.machines.ShieldsModel;
import dev.amble.ait.client.renderers.AITRenderLayers;
import dev.amble.ait.client.renderers.exteriors.DoomConstants;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.compat.DependencyChecker;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;
import dev.amble.ait.core.blocks.ExteriorBlock;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.core.tardis.handler.SiegeHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.data.datapack.DatapackConsole;
import dev.amble.ait.data.schema.exterior.ClientExteriorVariantSchema;
import dev.amble.ait.registry.impl.exterior.ClientExteriorVariantRegistry;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7718;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.joml.Vector3f;

public class ExteriorRenderer<T extends ExteriorBlockEntity>
implements class_827<T> {
    private static final class_2960 SHIELDS = AITMod.id("textures/environment/shields.png");
    private static final SiegeModeModel SIEGE_MODEL = new SiegeModeModel(SiegeModeModel.getTexturedModelData().method_32109());
    private static final ShieldsModel SHIELDS_MODEL = new ShieldsModel(ShieldsModel.getTexturedModelData().method_32109());
    private ClientExteriorVariantSchema variant;
    private ExteriorModel model;

    public ExteriorRenderer(class_5614.class_5615 ctx) {
    }

    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_3695 profiler = entity.method_10997().method_16107();
        profiler.method_15396("exterior");
        profiler.method_15396("find_tardis");
        if (!entity.isLinked()) {
            return;
        }
        ClientTardis tardis = ((AbstractLinkableBlockEntity)entity).tardis().get().asClient();
        profiler.method_15405("render");
        this.updateModel(tardis);
        if (tardis.travel() != null && tardis.travel().getAlpha() > 0.0f) {
            this.renderExterior(profiler, tardis, entity, tickDelta, matrices, vertexConsumers, light, overlay);
        }
        if (tardis.door() != null && (tardis.door().getLeftRot() > 0.0f || this.variant.hasTransparentDoors()) && !tardis.isGrowth() && tardis.travel().isLanded() && !tardis.siege().isActive() && !this.variant.equals(ClientExteriorVariantRegistry.DOOM)) {
            BOTI.EXTERIOR_RENDER_QUEUE.add((ExteriorBlockEntity)entity);
        }
        profiler.method_15407();
        profiler.method_15407();
    }

    private boolean awesomeIPEmissionHack(Tardis tardis) {
        return DependencyChecker.hasPortals() && ClientTardisUtil.getCurrentTardis() == tardis;
    }

    private void renderExterior(class_3695 profiler, ClientTardis tardis, T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        BiomeHandler handler;
        float alpha = tardis.travel().getAlpha(tickDelta);
        RenderSystem.enableCull();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        SiegeHandler siege = tardis.siege();
        if (siege.isActive()) {
            profiler.method_15396("siege");
            matrices.method_22903();
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            SIEGE_MODEL.renderWithAnimations(tardis, (ExteriorBlockEntity)entity, SIEGE_MODEL.method_32008(), matrices, vertexConsumers.getBuffer(AITRenderLayers.method_23689((class_2960)siege.texture().get())), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f, tickDelta);
            matrices.method_22909();
            profiler.method_15407();
            return;
        }
        TravelHandler travel = tardis.travel();
        CachedDirectedGlobalPos exteriorPos = travel.position();
        if (exteriorPos == null) {
            profiler.method_15407();
            return;
        }
        class_2680 blockState = entity.method_11010();
        int k = (Integer)blockState.method_11654((class_2769)ExteriorBlock.ROTATION);
        float h = class_7718.method_45482((int)k);
        boolean isDoom = this.variant.equals(ClientExteriorVariantRegistry.DOOM);
        matrices.method_22903();
        Vector3f animPositionOffset = travel.getAnimationPosition(tickDelta);
        matrices.method_46416(animPositionOffset.x(), animPositionOffset.y(), animPositionOffset.z());
        matrices.method_46416(0.5f, 0.0f, 0.5f);
        Vector3f animRotationOffset = travel.getAnimationRotation(tickDelta);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(animRotationOffset.z()));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(animRotationOffset.y()));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(animRotationOffset.x()));
        this.applyNameTransforms(tardis, matrices, tardis.stats().getName(), tickDelta);
        class_2960 texture = this.variant.texture();
        class_2960 emission = this.variant.emission();
        if (class_310.method_1551().field_1724 == null) {
            profiler.method_15407();
            return;
        }
        byte rotation = travel.position().getRotation();
        boolean isDiagonal = rotation > 0 && rotation < 4 || rotation > 4 && rotation < 8 || rotation > 8 && rotation < 12 || rotation > 12 && rotation < 16;
        float wrappedDegrees = class_3532.method_15393((float)(class_310.method_1551().field_1724.method_5791() + h + (isDiagonal ? 90.0f : 0.0f)));
        if (isDoom) {
            texture = DoomConstants.getTextureForRotation(wrappedDegrees, tardis);
            emission = DoomConstants.getEmissionForRotation(DoomConstants.getTextureForRotation(wrappedDegrees, tardis), tardis);
        }
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(!isDoom ? h + 180.0f : class_310.method_1551().field_1724.method_5791() + (wrappedDegrees > -135.0f && wrappedDegrees < 135.0f ? 180.0f : 0.0f) + (travel.position().getRotationDirection() == class_2350.field_11034 || travel.position().getRotationDirection() == class_2350.field_11039 ? 180.0f : 0.0f)));
        if (this.model == null) {
            profiler.method_15407();
            return;
        }
        if (((Boolean)travel.antigravs().get()).booleanValue() && ((Boolean)tardis.flight().falling().get()).booleanValue()) {
            float sinFunc = (float)Math.sin((float)class_310.method_1551().field_1724.field_6012 / 400.0f * 220.0f * 0.2f + 0.2f);
            matrices.method_46416(0.0f, sinFunc, 0.0f);
        }
        if (!DependencyChecker.hasIris()) {
            this.model.renderWithAnimations(tardis, entity, this.model.method_32008(), matrices, vertexConsumers.getBuffer(AITRenderLayers.method_23689((class_2960)texture)), light, overlay, 1.0f, 1.0f, 1.0f, alpha, tickDelta);
        }
        profiler.method_15396("emission");
        boolean alarms = tardis.alarm().isEnabled();
        boolean power = tardis.fuel().hasPower();
        if (alpha > 0.105f && emission != null && (power || alarms) && !emission.equals((Object)DatapackConsole.EMPTY) && !this.awesomeIPEmissionHack(tardis)) {
            float green;
            float red;
            float u = 1.0f;
            float t = 1.0f;
            float s = 1.0f;
            if ("partytardis".equals(tardis.stats().getName()) || !tardis.extra().getInsertedDisc().method_7960()) {
                float[] rgb = ClientTardisUtil.getPartyColors();
                u = rgb[0];
                t = rgb[1];
                s = rgb[2];
            } else if (tardis.sonic().getExteriorSonic() != null) {
                float time = (float)class_310.method_1551().field_1724.field_6012 + class_310.method_1551().method_1488();
                float progress = (float)((Math.sin((double)time * 0.03) + 1.0) / 2.0);
                float FROM_R = 1.0f;
                float FROM_G = 1.0f;
                float FROM_B = 1.0f;
                float TO_R = 0.3f;
                float TO_G = 0.3f;
                float TO_B = 1.0f;
                s = 1.0f * (1.0f - progress) + 0.3f * progress;
                t = 1.0f * (1.0f - progress) + 0.3f * progress;
                u = 1.0f * (1.0f - progress) + 1.0f * progress;
            }
            float colorAlpha = 1.0f - alpha;
            float f = alarms ? (!power ? 0.25f : s - colorAlpha) : (red = s - colorAlpha);
            float f2 = alarms ? (!power ? 0.01f : 0.3f) : (green = t - colorAlpha);
            float blue = alarms ? (!power ? 0.01f : 0.3f) : u - colorAlpha;
            this.model.renderWithAnimations(tardis, entity, this.model.method_32008(), matrices, vertexConsumers.getBuffer(AITRenderLayers.tardisEmissiveCullZOffset(this.variant.emission(), true)), 0xF000F0, class_4608.field_21444, red, green, blue, alpha, tickDelta);
        }
        if (DependencyChecker.hasIris()) {
            this.model.renderWithAnimations(tardis, entity, this.model.method_32008(), matrices, vertexConsumers.getBuffer(AITRenderLayers.method_23689((class_2960)texture)), light, overlay, 1.0f, 1.0f, 1.0f, alpha, tickDelta);
        }
        profiler.method_15405("biome");
        if (this.variant != ClientExteriorVariantRegistry.CORAL_GROWTH && (handler = (BiomeHandler)tardis.handler(TardisComponent.Id.BIOME)).getBiomeKey() != null) {
            class_2960 biomeTexture = handler.getBiomeKey().get(this.variant.overrides());
            if (alpha > 0.105f && biomeTexture != null && !texture.equals((Object)biomeTexture)) {
                this.model.renderWithAnimations(tardis, entity, this.model.method_32008(), matrices, vertexConsumers.getBuffer(AITRenderLayers.method_28116((class_2960)biomeTexture)), light, overlay, 1.0f, 1.0f, 1.0f, alpha, tickDelta);
            }
        }
        profiler.method_15407();
        matrices.method_22909();
        if (tardis.areVisualShieldsActive()) {
            profiler.method_15396("shields");
            float delta = (tickDelta + (float)class_310.method_1551().field_1724.field_6012) * 0.03f;
            class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23018((class_2960)SHIELDS, (float)(delta % 1.0f), (float)(delta * 0.1f % 1.0f)));
            matrices.method_22903();
            matrices.method_46416(0.5f, 0.0f, 0.5f);
            SHIELDS_MODEL.method_2828(matrices, vertexConsumer, 0xF000F0, class_4608.field_21444, 0.0f, 0.25f, 0.5f, alpha);
            matrices.method_22909();
            profiler.method_15407();
        }
        profiler.method_15396("sonic");
        class_1799 stack = tardis.sonic().getExteriorSonic();
        if (stack == null || entity.method_10997() == null) {
            profiler.method_15407();
            return;
        }
        matrices.method_22903();
        matrices.method_49278(class_7833.field_40715.rotationDegrees(180.0f + h + this.variant.sonicItemRotations()[0]), (float)entity.method_11016().method_46558().field_1352 - (float)entity.method_11016().method_10263(), (float)entity.method_11016().method_46558().field_1351 - (float)entity.method_11016().method_10264(), (float)entity.method_11016().method_46558().field_1350 - (float)entity.method_11016().method_10260());
        matrices.method_46416(this.variant.sonicItemTranslations().x(), this.variant.sonicItemTranslations().y(), this.variant.sonicItemTranslations().z());
        matrices.method_22907(class_7833.field_40714.rotationDegrees(this.variant.sonicItemRotations()[1]));
        matrices.method_22905(0.9f, 0.9f, 0.9f);
        int lightAbove = class_761.method_23794((class_1920)entity.method_10997(), (class_2338)entity.method_11016().method_10084());
        class_310.method_1551().method_1480().method_23178(stack, class_811.field_4318, lightAbove, class_4608.field_21444, matrices, vertexConsumers, entity.method_10997(), 0);
        matrices.method_22909();
        profiler.method_15407();
    }

    private void updateModel(Tardis tardis) {
        if (tardis.getExterior() == null) {
            return;
        }
        ClientExteriorVariantSchema variant = tardis.getExterior().getVariant().getClient();
        if (this.variant != variant) {
            this.variant = variant;
            this.model = variant.model();
        }
    }

    private void applyNameTransforms(Tardis tardis, class_4587 matrices, String name, float delta) {
        Vector3f scale = tardis.travel().getScale(delta);
        if (name.equalsIgnoreCase("grumm") || name.equalsIgnoreCase("dinnerbone")) {
            matrices.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
            matrices.method_46416(0.0f, scale.y + 0.25f, scale.z - 1.7f);
        }
        matrices.method_22905(scale.x, scale.y, scale.z);
    }

    public boolean rendersOutsideBoundingBox(ExteriorBlockEntity exteriorBlockEntity) {
        return true;
    }

    public int method_33893() {
        return 256;
    }

    public boolean isInRenderDistance(ExteriorBlockEntity exteriorBlockEntity, class_243 vec3d) {
        return class_243.method_24953((class_2382)exteriorBlockEntity.method_11016()).method_18805(1.0, 0.0, 1.0).method_24802((class_2374)vec3d.method_18805(1.0, 0.0, 1.0), (double)this.method_33893());
    }
}

