/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.renderers.monitors;

import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.models.monitors.CRTMonitorModel;
import dev.amble.ait.core.blockentities.MonitorBlockEntity;
import dev.amble.ait.core.blocks.MonitorBlock;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.util.MonitorStateUtil;
import dev.amble.ait.core.util.MonitorUtil;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2484;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_5614;
import net.minecraft.class_7718;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class MonitorRenderer<T extends MonitorBlockEntity>
implements class_827<T> {
    private static final class_2960 MONITOR_TEXTURE_DEFAULT = new class_2960("ait", "textures/blockentities/monitors/crt_monitor.png");
    private static final class_2960 MONITOR_TEXTURE_BLAZE = new class_2960("ait", "textures/blockentities/monitors/crt_monitor/blaze.png");
    public static final class_2960 EMISSIVE_MONITOR_TEXTURE = new class_2960("ait", "textures/blockentities/monitors/crt_monitor_emission.png");
    private final class_327 textRenderer;
    private final CRTMonitorModel crtMonitorModel;

    public MonitorRenderer(class_5614.class_5615 ctx) {
        this.textRenderer = class_310.method_1551().field_1772;
        this.crtMonitorModel = new CRTMonitorModel(CRTMonitorModel.getTexturedModelData().method_32109());
    }

    public void render(MonitorBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        MonitorStateUtil state = (MonitorStateUtil)((Object)entity.method_11010().method_11654(MonitorBlock.TEXTURE));
        class_2960 texture = switch (state) {
            case MonitorStateUtil.BLAZE -> MONITOR_TEXTURE_BLAZE;
            default -> MONITOR_TEXTURE_DEFAULT;
        };
        class_2680 blockState = entity.method_11010();
        int k = (Integer)blockState.method_11654((class_2769)class_2484.field_11505);
        float h = class_7718.method_45482((int)k);
        matrices.method_22903();
        matrices.method_46416(0.5f, 1.5f, 0.5f);
        matrices.method_22907(class_7833.field_40715.rotationDegrees(h));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        this.crtMonitorModel.method_2828(matrices, vertexConsumers.getBuffer(class_1921.method_23580((class_2960)texture)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        if (state == MonitorStateUtil.DEFAULT) {
            this.crtMonitorModel.method_2828(matrices, vertexConsumers.getBuffer(class_1921.method_42600((class_2960)EMISSIVE_MONITOR_TEXTURE)), 0xF000F00, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrices.method_22909();
        if (!entity.isLinked()) {
            return;
        }
        Tardis tardis = entity.tardis().get();
        if (!tardis.fuel().hasPower()) {
            return;
        }
        if (!AITModClient.CONFIG.showCRTMonitorText) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904(0.5, 0.75, 0.5);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22907(class_7833.field_40715.rotationDegrees(180.0f - h));
        matrices.method_22905(0.005f, 0.005f, 0.005f);
        matrices.method_46416(-50.0f, 0.0f, -80.0f);
        TravelHandler travel = tardis.travel();
        CachedDirectedGlobalPos abpp = travel.isLanded() || travel.getState() == TravelHandlerBase.State.MAT ? travel.position() : travel.getProgress();
        class_2338 abppPos = abpp.getPos();
        CachedDirectedGlobalPos abpd = tardis.travel().destination();
        class_2338 abpdPos = abpd.getPos();
        String positionPosText = " " + abppPos.method_10263() + ", " + abppPos.method_10264() + ", " + abppPos.method_10260();
        class_2561 positionDimensionText = class_2561.method_30163((String)MonitorUtil.truncateDimensionName(WorldUtil.worldText((class_5321<class_1937>)abpp.getDimension()).getString(), 20));
        this.textRenderer.method_37296(class_2561.method_30163((String)"\u274c").method_30937(), 0.0f, 0.0f, 0xF00F00, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163((String)positionPosText).method_30937(), 0.0f, 8.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(positionDimensionText.method_30937(), 0.0f, 16.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(WorldUtil.rot2Text(abpp.getRotation()).method_30937(), 0.0f, 24.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        String destinationPosText = " " + abpdPos.method_10263() + ", " + abpdPos.method_10264() + ", " + abpdPos.method_10260();
        class_2561 destinationDimensionText = class_2561.method_30163((String)MonitorUtil.truncateDimensionName(WorldUtil.worldText((class_5321<class_1937>)abpd.getDimension(), false).getString(), 20));
        this.textRenderer.method_37296(class_2561.method_30163((String)"\u271b").method_30937(), 0.0f, 40.0f, 61695, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163((String)destinationPosText).method_30937(), 0.0f, 48.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(destinationDimensionText.method_30937(), 0.0f, 56.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(WorldUtil.rot2Text(abpd.getRotation()).method_30937(), 0.0f, 64.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        String fuelText = Math.round(tardis.getFuel() / 50000.0 * 100.0) + "%";
        this.textRenderer.method_37296(class_2561.method_30163((String)"\u26fd").method_30937(), 0.0f, 78.0f, 0xFAF000, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163((String)fuelText).method_30937(), 8.0f, 78.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        String flightTimeText = tardis.travel().getState() == TravelHandlerBase.State.LANDED ? "0%" : tardis.travel().getDurationAsPercentage() + "%";
        this.textRenderer.method_37296(class_2561.method_30163((String)"\u23f3").method_30937(), 0.0f, 92.0f, 65295, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163((String)flightTimeText).method_30937(), 8.0f, 92.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        String name = tardis.stats().getName();
        this.textRenderer.method_37296(class_2561.method_30163((String)name).method_30937(), (float)(98 - this.textRenderer.method_1727(name)), 90.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        if (tardis.alarm().isEnabled()) {
            this.textRenderer.method_37296(class_2561.method_30163((String)"\u26a0").method_30937(), 84.0f, 0.0f, 0xFE0000, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        }
        matrices.method_22909();
    }
}

