/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.client.renderers.monitors;

import dev.amble.ait.client.models.decoration.PlaqueModel;
import dev.amble.ait.core.blockentities.WallMonitorBlockEntity;
import dev.amble.ait.core.blocks.PlaqueBlock;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.impl.DirectionControl;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class WallMonitorRenderer<T extends WallMonitorBlockEntity>
implements class_827<T> {
    public static final class_2960 PLAQUE_TEXTURE = new class_2960("ait", "textures/blockentities/monitors/wall_monitor.png");
    private final class_327 textRenderer;
    private final PlaqueModel plaqueModel;

    public WallMonitorRenderer(class_5614.class_5615 ctx) {
        this.textRenderer = class_310.method_1551().field_1772;
        this.plaqueModel = new PlaqueModel(PlaqueModel.getTexturedModelData().method_32109());
    }

    private String truncateDimensionName(String name, int maxLength) {
        if (name.length() > maxLength) {
            return name.substring(0, maxLength) + "...";
        }
        return name;
    }

    public void render(WallMonitorBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_2680 blockState = entity.method_11010();
        class_2350 k = (class_2350)blockState.method_11654((class_2769)PlaqueBlock.FACING);
        matrices.method_22903();
        matrices.method_46416(0.5f, 1.5f, 0.5f);
        matrices.method_22907(class_7833.field_40715.rotationDegrees(k.method_10144()));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        this.plaqueModel.method_2828(matrices, vertexConsumers.getBuffer(class_1921.method_23580((class_2960)PLAQUE_TEXTURE)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrices.method_22909();
        if (!entity.isLinked()) {
            return;
        }
        Tardis tardis = entity.tardis().get();
        if (!tardis.fuel().hasPower()) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904(0.5, 0.75, 0.5);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(k.method_10144()));
        matrices.method_22905(0.01f, 0.01f, 0.01f);
        float xVal = 0.0f;
        matrices.method_46416(xVal, -35.0f, 35.0f);
        TravelHandler travel = tardis.travel();
        CachedDirectedGlobalPos abpp = travel.isLanded() || travel.getState() == TravelHandlerBase.State.MAT ? travel.position() : travel.getProgress();
        class_2338 abppPos = abpp.getPos();
        CachedDirectedGlobalPos abpd = tardis.travel().destination();
        class_2338 abpdPos = abpd.getPos();
        String positionPosText = abppPos.method_10263() + ", " + abppPos.method_10264() + ", " + abppPos.method_10260();
        class_2561 positionDimensionText = class_2561.method_30163((String)this.truncateDimensionName(WorldUtil.worldText((class_5321<class_1937>)abpp.getDimension()).getString(), 16));
        String fuelText = Math.round(tardis.getFuel() / 50000.0 * 100.0) + "%";
        String destinationPosText = abpdPos.method_10263() + ", " + abpdPos.method_10264() + ", " + abpdPos.method_10260();
        class_2561 destinationDimensionText = class_2561.method_30163((String)this.truncateDimensionName(WorldUtil.worldText((class_5321<class_1937>)abpd.getDimension(), false).getString(), 16));
        float v = -20.0f;
        String arrow = DirectionControl.rotationForArrow(abpp.getRotation());
        String arrow2 = DirectionControl.rotationForArrow(abpd.getRotation());
        this.textRenderer.method_37296(class_2561.method_30163((String)positionPosText).method_30937(), v - xVal - (float)this.textRenderer.method_1727(positionPosText) / 2.0f, 35.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(positionDimensionText.method_30937(), v - xVal - (float)this.textRenderer.method_27525((class_5348)positionDimensionText) / 2.0f, 46.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163((String)arrow).method_30937(), 18.0f - xVal - (float)this.textRenderer.method_1727(arrow) / 2.0f, 42.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163((String)"-===========-").method_30937(), v - xVal - (float)this.textRenderer.method_1727("-===========-") / 2.0f, 55.0f, 61695, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163((String)destinationPosText).method_30937(), v - xVal - (float)this.textRenderer.method_1727(destinationPosText) / 2.0f, 67.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(destinationDimensionText.method_30937(), v - xVal - (float)this.textRenderer.method_27525((class_5348)positionDimensionText) / 2.0f, 78.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163((String)arrow2).method_30937(), 18.0f - xVal - (float)this.textRenderer.method_1727(arrow2) / 2.0f, 75.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163((String)"\u26fd").method_30937(), 53.0f - xVal - (float)this.textRenderer.method_1727("\u26fd") / 2.0f, 40.0f, 0xFAF000, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163((String)fuelText).method_30937(), 53.0f - xVal - (float)this.textRenderer.method_1727(fuelText) / 2.0f, 48.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        String flightTimeText = travel.getState() == TravelHandlerBase.State.LANDED ? "0%" : tardis.travel().getDurationAsPercentage() + "%";
        this.textRenderer.method_37296(class_2561.method_30163((String)"\u23f3").method_30937(), 53.0f - xVal - (float)this.textRenderer.method_1727("\u23f3") / 2.0f, 60.0f, 65295, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163((String)flightTimeText).method_30937(), 53.0f - xVal - (float)this.textRenderer.method_1727(flightTimeText) / 2.0f, 68.0f, 0xFFFFFF, 0, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        matrices.method_22909();
    }
}

